/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.kernelcontext.reductions;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestReductionsDoublesKernelContext
extends TornadoTestBase {
    public static double computeAddSequential(DoubleArray input) {
        double acc = 0.0;
        for (int i = 0; i < input.getSize(); ++i) {
            acc += input.get(i);
        }
        return acc;
    }

    public static void doubleReductionAddGlobalMemory(KernelContext context, DoubleArray a, DoubleArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = localGroupSize * groupID + localIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, a.get(id) + a.get(id + stride));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(id));
        }
    }

    private static void doubleReductionAddLocalMemory(KernelContext context, DoubleArray a, DoubleArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        double[] localA = context.allocateDoubleLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localA[n] = localA[n] + localA[localIdx + stride];
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    private static void doubleReductionAddLocalMemory(KernelContext context, DoubleArray a, DoubleArray b, int blockDim) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        double[] localA = context.allocateDoubleLocalArray(blockDim);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localA[n] = localA[n] + localA[localIdx + stride];
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static double computeMaxSequential(DoubleArray input) {
        double acc = 0.0;
        for (int i = 0; i < input.getSize(); ++i) {
            acc = TornadoMath.max((double)acc, (double)input.get(i));
        }
        return acc;
    }

    private static void doubleReductionMaxGlobalMemory(KernelContext context, DoubleArray a, DoubleArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = localGroupSize * groupID + localIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, TornadoMath.max((double)a.get(id), (double)a.get(id + stride)));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(id));
        }
    }

    public static void doubleReductionMaxLocalMemory(KernelContext context, DoubleArray a, DoubleArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        double[] localA = context.allocateDoubleLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = TornadoMath.max((double)localA[localIdx], (double)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static double computeMinSequential(DoubleArray input) {
        double acc = 0.0;
        for (int i = 0; i < input.getSize(); ++i) {
            acc = TornadoMath.min((double)acc, (double)input.get(i));
        }
        return acc;
    }

    private static void doubleReductionMinGlobalMemory(KernelContext context, DoubleArray a, DoubleArray b) {
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        int id = localGroupSize * groupID + localIdx;
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            a.set(id, TornadoMath.min((double)a.get(id), (double)a.get(id + stride)));
        }
        if (localIdx == 0) {
            b.set(groupID, a.get(id));
        }
    }

    public static void doubleReductionMinLocalMemory(KernelContext context, DoubleArray a, DoubleArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        double[] localA = context.allocateDoubleLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = TornadoMath.min((double)localA[localIdx], (double)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    @Test
    public void testDoubleReductionsAddGlobalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        DoubleArray input = new DoubleArray(1024);
        DoubleArray reduce = new DoubleArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (double)i));
        double sequential = TestReductionsDoublesKernelContext.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsDoublesKernelContext::doubleReductionAddGlobalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        double finalSum = 0.0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum += reduce.get(i2);
        }
        Assert.assertEquals((double)sequential, (double)finalSum, (double)0.0);
    }

    @Test
    public void testDoubleReductionsAddLocalMemory01() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        DoubleArray input = new DoubleArray(1024);
        DoubleArray reduce = new DoubleArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (double)i));
        double sequential = TestReductionsDoublesKernelContext.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsDoublesKernelContext::doubleReductionAddLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        double finalSum = 0.0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum += reduce.get(i2);
        }
        Assert.assertEquals((double)sequential, (double)finalSum, (double)0.0);
    }

    @Test
    public void testDoubleReductionsAddLocalMemory02() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        DoubleArray input = new DoubleArray(1024);
        DoubleArray reduce = new DoubleArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (double)i));
        double sequential = TestReductionsDoublesKernelContext.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestReductionsDoublesKernelContext::doubleReductionAddLocalMemory, (Object)context, (Object)input, (Object)reduce, (Object)256).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        double finalSum = 0.0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum += reduce.get(i2);
        }
        Assert.assertEquals((double)sequential, (double)finalSum, (double)0.0);
    }

    @Test
    public void testDoubleReductionsMaxGlobalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        DoubleArray input = new DoubleArray(1024);
        DoubleArray reduce = new DoubleArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (double)i));
        double sequential = TestReductionsDoublesKernelContext.computeMaxSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsDoublesKernelContext::doubleReductionMaxGlobalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        double finalSum = 0.0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.max((double)finalSum, (double)reduce.get(i2));
        }
        Assert.assertEquals((double)sequential, (double)finalSum, (double)0.0);
    }

    @Test
    public void testDoubleReductionsMaxLocalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        DoubleArray input = new DoubleArray(1024);
        DoubleArray reduce = new DoubleArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (double)i));
        double sequential = TestReductionsDoublesKernelContext.computeMaxSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsDoublesKernelContext::doubleReductionMaxLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        double finalSum = 0.0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.max((double)finalSum, (double)reduce.get(i2));
        }
        Assert.assertEquals((double)sequential, (double)finalSum, (double)0.0);
    }

    @Test
    public void testDoubleReductionsMinGlobalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        DoubleArray input = new DoubleArray(1024);
        DoubleArray reduce = new DoubleArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (double)i));
        double sequential = TestReductionsDoublesKernelContext.computeMinSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsDoublesKernelContext::doubleReductionMinGlobalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        double finalSum = 0.0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.min((double)finalSum, (double)reduce.get(i2));
        }
        Assert.assertEquals((double)sequential, (double)finalSum, (double)0.0);
    }

    @Test
    public void testDoubleReductionsMinLocalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        DoubleArray input = new DoubleArray(1024);
        DoubleArray reduce = new DoubleArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (double)i));
        double sequential = TestReductionsDoublesKernelContext.computeMinSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestReductionsDoublesKernelContext::doubleReductionMinLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        double finalSum = 0.0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.min((double)finalSum, (double)reduce.get(i2));
        }
        Assert.assertEquals((double)sequential, (double)finalSum, (double)0.0);
    }
}

