/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.kernelcontext.reductions;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestLocalMemoryReductionsHalfFloats
extends TornadoTestBase {
    public static HalfFloat computeAddSequential(HalfFloatArray input) {
        HalfFloat acc = new HalfFloat(0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            acc = HalfFloat.add((HalfFloat)acc, (HalfFloat)input.get(i));
        }
        return acc;
    }

    private static void halfFloatReductionAddLocalMemory(KernelContext context, HalfFloatArray a, HalfFloatArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        HalfFloat[] localA = context.allocateHalfFloatLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = HalfFloat.add((HalfFloat)localA[localIdx], (HalfFloat)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    private static void halfFloatReductionAddLocalMemory(KernelContext context, HalfFloatArray a, HalfFloatArray b, int blockDim) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        HalfFloat[] localA = context.allocateHalfFloatLocalArray(blockDim);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = HalfFloat.add((HalfFloat)localA[localIdx], (HalfFloat)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static HalfFloat computeMaxSequential(HalfFloatArray input) {
        HalfFloat acc = new HalfFloat(0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            acc = TornadoMath.max((HalfFloat)acc, (HalfFloat)input.get(i));
        }
        return acc;
    }

    public static void halfFloatReductionMaxLocalMemory(KernelContext context, HalfFloatArray a, HalfFloatArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        HalfFloat[] localA = context.allocateHalfFloatLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = TornadoMath.max((HalfFloat)localA[localIdx], (HalfFloat)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static HalfFloat computeMinSequential(HalfFloatArray input) {
        HalfFloat acc = new HalfFloat(0.0f);
        for (int i = 0; i < input.getSize(); ++i) {
            acc = TornadoMath.min((HalfFloat)acc, (HalfFloat)input.get(i));
        }
        return acc;
    }

    public static void halfFloatReductionMinLocalMemory(KernelContext context, HalfFloatArray a, HalfFloatArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        HalfFloat[] localA = context.allocateHalfFloatLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = TornadoMath.min((HalfFloat)localA[localIdx], (HalfFloat)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    @Test
    public void testHalfFloatReductionsAddLocalMemory01() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        HalfFloatArray input = new HalfFloatArray(1024);
        HalfFloatArray reduce = new HalfFloatArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, new HalfFloat((float)i)));
        HalfFloat sequential = TestLocalMemoryReductionsHalfFloats.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestLocalMemoryReductionsHalfFloats::halfFloatReductionAddLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        HalfFloat finalSum = new HalfFloat(0.0f);
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = HalfFloat.add((HalfFloat)finalSum, (HalfFloat)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential.getFloat32(), (float)finalSum.getFloat32(), (float)0.0f);
    }

    @Test
    public void testHalfFloatReductionsAddLocalMemory02() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        HalfFloatArray input = new HalfFloatArray(1024);
        HalfFloatArray reduce = new HalfFloatArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, new HalfFloat((float)i)));
        HalfFloat sequential = TestLocalMemoryReductionsHalfFloats.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestLocalMemoryReductionsHalfFloats::halfFloatReductionAddLocalMemory, (Object)context, (Object)input, (Object)reduce, (Object)256).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        HalfFloat finalSum = new HalfFloat(0.0f);
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = HalfFloat.add((HalfFloat)finalSum, (HalfFloat)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential.getFloat32(), (float)finalSum.getFloat32(), (float)0.0f);
    }

    @Test
    public void testHalfFloatReductionsMaxLocalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        HalfFloatArray input = new HalfFloatArray(1024);
        HalfFloatArray reduce = new HalfFloatArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, new HalfFloat((float)i)));
        HalfFloat sequential = TestLocalMemoryReductionsHalfFloats.computeMaxSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestLocalMemoryReductionsHalfFloats::halfFloatReductionMaxLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        HalfFloat finalSum = new HalfFloat(0.0f);
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.max((HalfFloat)finalSum, (HalfFloat)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential.getFloat32(), (float)finalSum.getFloat32(), (float)0.0f);
    }

    @Test
    public void testHalfFloatReductionsMinLocalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        HalfFloatArray input = new HalfFloatArray(1024);
        HalfFloatArray reduce = new HalfFloatArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, new HalfFloat((float)i)));
        HalfFloat sequential = TestLocalMemoryReductionsHalfFloats.computeMinSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestLocalMemoryReductionsHalfFloats::halfFloatReductionMinLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        HalfFloat finalSum = new HalfFloat(0.0f);
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.min((HalfFloat)finalSum, (HalfFloat)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential.getFloat32(), (float)finalSum.getFloat32(), (float)0.0f);
    }
}

