/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.kernelcontext.reductions;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestLocalMemoryReductionsBytes
extends TornadoTestBase {
    public static byte computeAddSequential(ByteArray input) {
        byte acc = 0;
        for (int i = 0; i < input.getSize(); ++i) {
            acc = (byte)(acc + input.get(i));
        }
        return acc;
    }

    private static void byteReductionAddLocalMemory(KernelContext context, ByteArray a, ByteArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        byte[] localA = context.allocateByteLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localA[n] = (byte)(localA[n] + localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    private static void byteReductionAddLocalMemory(KernelContext context, ByteArray a, ByteArray b, int blockDim) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        byte[] localA = context.allocateByteLocalArray(blockDim);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            int n = localIdx;
            localA[n] = (byte)(localA[n] + localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static byte computeMaxSequential(ByteArray input) {
        byte acc = 0;
        for (int i = 0; i < input.getSize(); ++i) {
            acc = TornadoMath.max((byte)acc, (byte)input.get(i));
        }
        return acc;
    }

    public static void byteReductionMaxLocalMemory(KernelContext context, ByteArray a, ByteArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        byte[] localA = context.allocateByteLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = TornadoMath.max((byte)localA[localIdx], (byte)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    public static byte computeMinSequential(ByteArray input) {
        byte acc = 0;
        for (int i = 0; i < input.getSize(); ++i) {
            acc = TornadoMath.min((byte)acc, (byte)input.get(i));
        }
        return acc;
    }

    public static void byteReductionMinLocalMemory(KernelContext context, ByteArray a, ByteArray b) {
        int globalIdx = context.globalIdx;
        int localIdx = context.localIdx;
        int localGroupSize = context.localGroupSizeX;
        int groupID = context.groupIdx;
        byte[] localA = context.allocateByteLocalArray(256);
        localA[localIdx] = a.get(globalIdx);
        for (int stride = localGroupSize / 2; stride > 0; stride /= 2) {
            context.localBarrier();
            if (localIdx >= stride) continue;
            localA[localIdx] = TornadoMath.min((byte)localA[localIdx], (byte)localA[localIdx + stride]);
        }
        if (localIdx == 0) {
            b.set(groupID, localA[0]);
        }
    }

    @Test
    public void testByteReductionsAddLocalMemory01() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        ByteArray input = new ByteArray(1024);
        ByteArray reduce = new ByteArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (byte)i));
        byte sequential = TestLocalMemoryReductionsBytes.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestLocalMemoryReductionsBytes::byteReductionAddLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        byte finalSum = 0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = (byte)(finalSum + reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testByteReductionsAddLocalMemory02() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        ByteArray input = new ByteArray(1024);
        ByteArray reduce = new ByteArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (byte)i));
        byte sequential = TestLocalMemoryReductionsBytes.computeAddSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestLocalMemoryReductionsBytes::byteReductionAddLocalMemory, (Object)context, (Object)input, (Object)reduce, (Object)256).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        byte finalSum = 0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = (byte)(finalSum + reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testByteReductionsMaxLocalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        ByteArray input = new ByteArray(1024);
        ByteArray reduce = new ByteArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (byte)i));
        byte sequential = TestLocalMemoryReductionsBytes.computeMaxSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestLocalMemoryReductionsBytes::byteReductionMaxLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        byte finalSum = 0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.max((byte)finalSum, (byte)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }

    @Test
    public void testByteReductionsMinLocalMemory() throws TornadoExecutionPlanException {
        int size = 1024;
        int localSize = 256;
        ByteArray input = new ByteArray(1024);
        ByteArray reduce = new ByteArray(4);
        IntStream.range(0, input.getSize()).sequential().forEach(i -> input.set(i, (byte)i));
        byte sequential = TestLocalMemoryReductionsBytes.computeMinSequential(input);
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input, 256}).task("t0", TestLocalMemoryReductionsBytes::byteReductionMinLocalMemory, (Object)context, (Object)input, (Object)reduce).transferToHost(1, new Object[]{reduce});
        worker.setGlobalWork(1024L, 1L, 1L);
        worker.setLocalWork(256L, 1L, 1L);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        byte finalSum = 0;
        for (int i2 = 0; i2 < reduce.getSize(); ++i2) {
            finalSum = TornadoMath.min((byte)finalSum, (byte)reduce.get(i2));
        }
        Assert.assertEquals((float)sequential, (float)finalSum, (float)0.0f);
    }
}

