/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.kernelcontext.api;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.WorkerGrid2D;
import uk.ac.manchester.tornado.api.WorkerGrid3D;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class KernelContextWorkGroupTests
extends TornadoTestBase {
    private static void apiTestGlobalGroupSizeX(KernelContext context, IntArray data) {
        data.set(0, context.globalGroupSizeX.intValue());
    }

    private static void apiTestGlobalGroupSizeY(KernelContext context, IntArray data) {
        data.set(0, context.globalGroupSizeY.intValue());
    }

    private static void apiTestGlobalGroupSizeZ(KernelContext context, IntArray data) {
        data.set(0, context.globalGroupSizeZ.intValue());
    }

    private static void apiTestLocalGroupSizeX(KernelContext context, IntArray data) {
        data.set(0, context.localGroupSizeX.intValue());
    }

    private static void apiTestLocalGroupSizeY(KernelContext context, IntArray data) {
        data.set(0, context.localGroupSizeY.intValue());
    }

    private static void apiTestLocalGroupSizeZ(KernelContext context, IntArray data) {
        data.set(0, context.localGroupSizeZ.intValue());
    }

    @Test
    public void test01() throws TornadoExecutionPlanException {
        KernelContext context = new KernelContext();
        GridScheduler grid = new GridScheduler();
        WorkerGrid1D worker = new WorkerGrid1D(16);
        grid.addWorkerGrid("s0.t0", (WorkerGrid)worker);
        IntArray data = new IntArray(16);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", KernelContextWorkGroupTests::apiTestGlobalGroupSizeX, (Object)context, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(grid).execute();
        }
        Assert.assertEquals((long)16L, (long)data.get(0));
    }

    @Test
    public void test02() throws TornadoExecutionPlanException {
        KernelContext context = new KernelContext();
        GridScheduler grid = new GridScheduler();
        WorkerGrid2D worker = new WorkerGrid2D(16, 8);
        grid.addWorkerGrid("s0.t0", (WorkerGrid)worker);
        IntArray data = new IntArray(16);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", KernelContextWorkGroupTests::apiTestGlobalGroupSizeY, (Object)context, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(grid).execute();
        }
        Assert.assertEquals((long)8L, (long)data.get(0));
    }

    @Test
    public void test03() throws TornadoExecutionPlanException {
        KernelContext context = new KernelContext();
        GridScheduler grid = new GridScheduler();
        WorkerGrid3D worker = new WorkerGrid3D(16, 8, 4);
        grid.addWorkerGrid("s0.t0", (WorkerGrid)worker);
        IntArray data = new IntArray(16);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", KernelContextWorkGroupTests::apiTestGlobalGroupSizeZ, (Object)context, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(grid).execute();
        }
        Assert.assertEquals((long)4L, (long)data.get(0));
    }

    @Test
    public void test04() throws TornadoExecutionPlanException {
        KernelContext context = new KernelContext();
        GridScheduler grid = new GridScheduler();
        WorkerGrid1D worker = new WorkerGrid1D(1024);
        worker.setLocalWork(8L, 1L, 1L);
        grid.addWorkerGrid("s0.t0", (WorkerGrid)worker);
        IntArray data = new IntArray(1024);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", KernelContextWorkGroupTests::apiTestLocalGroupSizeX, (Object)context, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(grid).execute();
        }
        Assert.assertEquals((long)worker.getLocalWork()[0], (long)data.get(0));
    }

    @Test
    public void test05() throws TornadoExecutionPlanException {
        KernelContext context = new KernelContext();
        GridScheduler grid = new GridScheduler();
        WorkerGrid2D worker = new WorkerGrid2D(1024, 512);
        worker.setLocalWork(1L, 8L, 1L);
        grid.addWorkerGrid("s0.t0", (WorkerGrid)worker);
        IntArray data = new IntArray(1024);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", KernelContextWorkGroupTests::apiTestLocalGroupSizeY, (Object)context, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(grid).execute();
        }
        Assert.assertEquals((long)worker.getLocalWork()[1], (long)data.get(0));
    }

    @Test
    public void test06() throws TornadoExecutionPlanException {
        KernelContext context = new KernelContext();
        GridScheduler grid = new GridScheduler();
        WorkerGrid3D worker = new WorkerGrid3D(1, 1, 1024);
        worker.setLocalWork(1L, 1L, 8L);
        grid.addWorkerGrid("s0.t0", (WorkerGrid)worker);
        IntArray data = new IntArray(1024);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", KernelContextWorkGroupTests::apiTestLocalGroupSizeZ, (Object)context, (Object)data).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(grid).execute();
        }
        Assert.assertEquals((long)worker.getLocalWork()[2], (long)data.get(0));
    }
}

