/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.kernelcontext.api;

import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class Grids
extends TornadoTestBase {
    final int gridSize = 32;
    final int size = 100000;

    private static void psKernel(KernelContext kc, FloatArray tArray, FloatArray vArray, FloatArray results) {
        int idx = kc.localIdx;
        results.set(5 * idx, (float)kc.globalIdx.intValue());
        results.set(5 * idx + 1, (float)kc.globalGroupSizeX.intValue());
        results.set(5 * idx + 2, (float)kc.localGroupSizeX.intValue());
        results.set(5 * idx + 3, (float)kc.localIdx.intValue());
        results.set(5 * idx + 4, 9999.0f);
    }

    @Test
    public void testWithCorrectNames() throws TornadoExecutionPlanException {
        FloatArray timesArray = new FloatArray(100000);
        FloatArray obsArray = new FloatArray(100000);
        FloatArray resArray = new FloatArray(100000);
        resArray.init(0.0f);
        WorkerGrid1D worker = new WorkerGrid1D(32);
        GridScheduler gridScheduler = new GridScheduler("foo.bar", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        worker.setLocalWork(32L, 1L, 1L);
        TaskGraph taskGraph = new TaskGraph("foo");
        taskGraph.transferToDevice(1, new Object[]{timesArray, obsArray}).task("bar", Grids::psKernel, (Object)context, (Object)timesArray, (Object)obsArray, (Object)resArray).transferToHost(1, new Object[]{resArray});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
    }

    @Test(expected=TornadoRuntimeException.class)
    public void testWithIncorrectGraphName() {
        FloatArray timesArray = new FloatArray(100000);
        FloatArray obsArray = new FloatArray(100000);
        FloatArray resArray = new FloatArray(100000);
        resArray.init(0.0f);
        WorkerGrid1D worker = new WorkerGrid1D(32);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        worker.setLocalWork(32L, 1L, 1L);
        TaskGraph taskGraph = new TaskGraph("foo");
        taskGraph.transferToDevice(1, new Object[]{timesArray, obsArray}).task("t0", Grids::psKernel, (Object)context, (Object)timesArray, (Object)obsArray, (Object)resArray).transferToHost(1, new Object[]{resArray});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.withGridScheduler(gridScheduler).execute();
    }

    @Test(expected=TornadoRuntimeException.class)
    public void testWithIncorrectGraphAndTaskName() {
        FloatArray timesArray = new FloatArray(100000);
        FloatArray obsArray = new FloatArray(100000);
        FloatArray resArray = new FloatArray(100000);
        resArray.init(0.0f);
        WorkerGrid1D worker = new WorkerGrid1D(32);
        GridScheduler gridScheduler = new GridScheduler("foo.bar", (WorkerGrid)worker);
        KernelContext context = new KernelContext();
        worker.setLocalWork(32L, 1L, 1L);
        TaskGraph taskGraph = new TaskGraph("t0");
        taskGraph.transferToDevice(1, new Object[]{timesArray, obsArray}).task("t0", Grids::psKernel, (Object)context, (Object)timesArray, (Object)obsArray, (Object)resArray).transferToHost(1, new Object[]{resArray});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.withGridScheduler(gridScheduler).execute();
    }
}

