/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.instances;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestInstances
extends TornadoTestBase {
    @Test
    public void testInit() throws TornadoExecutionPlanException {
        Foo f = new Foo();
        DoubleArray array = new DoubleArray(1000);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", f::compute, (Object)array, (Object)2.1).transferToHost(1, new Object[]{array});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((double)2.1, (double)array.get(i), (double)0.001);
        }
    }

    public void compute(DoubleArray array, double initValue) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, initValue);
        }
    }

    @Test
    public void testThis() throws TornadoExecutionPlanException {
        DoubleArray array = new DoubleArray(1000);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", this::compute, (Object)array, (Object)2.1).transferToHost(1, new Object[]{array});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((double)2.1, (double)array.get(i), (double)0.001);
        }
    }

    public static class Foo {
        public void compute(DoubleArray array, double initValue) {
            for (int i = 0; i < array.getSize(); ++i) {
                array.set(i, initValue);
            }
        }
    }
}

