/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.instances;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;

public class LocalVariableInstanceTest {
    public int[] sequential(int[] in) {
        int[] out = new int[in.length];
        for (int i = 0; i < in.length; ++i) {
            int x = i - 2 + 9;
            out[i] = i * x;
        }
        return out;
    }

    @Test
    public void testLocalVariable() throws TornadoExecutionPlanException {
        int[] in = new int[5];
        int[] out = new int[5];
        for (int i = 0; i < in.length; ++i) {
            in[i] = i;
        }
        MyMap mm = new MyMap();
        MapSkeleton msk = new MapSkeleton(mm);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{in}).task("t0", msk::map, (Object)in, (Object)out).transferToHost(1, new Object[]{out});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        int[] seq = this.sequential(in);
        Assert.assertArrayEquals((int[])seq, (int[])out);
    }

    public static class MyMap
    extends MiddleMap {
        @Override
        public int mymapintint(int i) {
            FlinkMapUDF fudf = new FlinkMapUDF();
            return fudf.map(i);
        }
    }

    public static class MapSkeleton {
        public MiddleMap mdm;

        MapSkeleton(MiddleMap mdm) {
            this.mdm = mdm;
        }

        public void map(int[] input, int[] output) {
            for (int i = 0; i < input.length; ++i) {
                output[i] = this.mdm.mymapintint(i);
            }
        }
    }

    public static abstract class MiddleMap {
        public abstract int mymapintint(int var1);
    }

    public static class FlinkMapUDF {
        public int map(int value) {
            int x = value - 2 + 9;
            return value * x;
        }
    }
}

