/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.images;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.images.ImageFloat;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestResizeImage
extends TornadoTestBase {
    public static void resize(ImageFloat dest, ImageFloat src, int scaleFactor) {
        for (int y = 0; y < dest.Y(); ++y) {
            for (int x = 0; x < dest.X(); ++x) {
                int cx = TornadoMath.clamp((int)(scaleFactor * x), (int)0, (int)(src.X() - 1));
                int cy = TornadoMath.clamp((int)(scaleFactor * y), (int)0, (int)(src.Y() - 1));
                float center = src.get(cx, cy);
                dest.set(x, y, center);
            }
        }
    }

    @Test
    public void testResizeImage() throws TornadoExecutionPlanException {
        int numElementsX = 8;
        int numElementsY = 8;
        ImageFloat imageSource = new ImageFloat(8, 8);
        ImageFloat imageDst = new ImageFloat(4, 4);
        Random rand = new Random();
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                imageSource.set(x, y, rand.nextFloat());
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageSource}).task("t0", TestResizeImage::resize, (Object)imageDst, (Object)imageSource, (Object)2).transferToHost(1, new Object[]{imageDst});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withPreCompilation().execute();
        }
        int scale = 2;
        for (int i = 0; i < imageDst.X(); ++i) {
            for (int j = 0; j < imageDst.Y(); ++j) {
                int cx = TornadoMath.clamp((int)(2 * i), (int)0, (int)(imageSource.X() - 1));
                int cy = TornadoMath.clamp((int)(2 * j), (int)0, (int)(imageSource.Y() - 1));
                float center = imageSource.get(cx, cy);
                Assert.assertEquals((double)imageDst.get(i, j), (double)center, (double)0.1);
            }
        }
    }

    @Test
    public void testResizeImageStreams() {
        int numElementsX = 8;
        int numElementsY = 8;
        ImageFloat image1 = new ImageFloat(8, 8);
        ImageFloat image2 = new ImageFloat(4, 4);
        Random rand = new Random();
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                image1.set(x, y, rand.nextFloat());
            }
        }
        IntStream.range(0, image2.X() * image2.Y()).parallel().forEach(index -> {
            int x = index % image2.X();
            int y = index / image2.X();
            int cx = TornadoMath.clamp((int)(2 * x), (int)0, (int)(image1.X() - 1));
            int cy = TornadoMath.clamp((int)(2 * y), (int)0, (int)(image1.Y() - 1));
            float center = image1.get(cx, cy);
            image2.set(x, y, center);
        });
        int scale = 2;
        for (int i = 0; i < image2.X(); ++i) {
            for (int j = 0; j < image2.Y(); ++j) {
                int cx = TornadoMath.clamp((int)(2 * i), (int)0, (int)(image1.X() - 1));
                int cy = TornadoMath.clamp((int)(2 * j), (int)0, (int)(image1.Y() - 1));
                float center = image1.get(cx, cy);
                Assert.assertEquals((double)image2.get(i, j), (double)center, (double)0.1);
            }
        }
    }
}

