/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.images;

import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.images.ImageByte3;
import uk.ac.manchester.tornado.api.types.images.ImageByte4;
import uk.ac.manchester.tornado.api.types.images.ImageFloat;
import uk.ac.manchester.tornado.api.types.images.ImageFloat3;
import uk.ac.manchester.tornado.api.types.images.ImageFloat4;
import uk.ac.manchester.tornado.api.types.images.ImageFloat8;
import uk.ac.manchester.tornado.api.types.vectors.Byte3;
import uk.ac.manchester.tornado.api.types.vectors.Byte4;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.api.types.vectors.Float8;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestImages
extends TornadoTestBase {
    public static void taskWithImages(ImageFloat a, ImageFloat b) {
        for (int i = 0; i < a.X(); ++i) {
            for (int j = 0; j < a.Y(); ++j) {
                float value = a.get(i, j);
                b.set(i, j, value);
            }
        }
    }

    public static void taskWithImagesFloat3(ImageFloat3 a, ImageFloat3 b) {
        for (int i = 0; i < a.X(); ++i) {
            for (int j = 0; j < a.Y(); ++j) {
                Float3 value = a.get(i, j);
                b.set(i, j, value);
            }
        }
    }

    public static void taskWithImagesFloat4(ImageFloat4 a, ImageFloat4 b) {
        for (int i = 0; i < a.X(); ++i) {
            for (int j = 0; j < a.Y(); ++j) {
                Float4 value = a.get(i, j);
                b.set(i, j, value);
            }
        }
    }

    public static void taskWithImagesFloat8(ImageFloat8 a, ImageFloat8 b) {
        for (int i = 0; i < a.X(); ++i) {
            for (int j = 0; j < a.Y(); ++j) {
                Float8 value = a.get(i, j);
                b.set(i, j, value);
            }
        }
    }

    public static void taskWithImagesByte3(ImageByte3 a, ImageByte3 b) {
        for (int i = 0; i < a.X(); ++i) {
            for (int j = 0; j < a.Y(); ++j) {
                Byte3 value = a.get(i, j);
                b.set(i, j, value);
            }
        }
    }

    public static void taskWithImagesByte4(ImageByte4 a, ImageByte4 b) {
        for (int i = 0; i < a.X(); ++i) {
            for (int j = 0; j < a.Y(); ++j) {
                Byte4 value = a.get(i, j);
                b.set(i, j, value);
            }
        }
    }

    public static void testCopyImagesParallel(ImageFloat a, ImageFloat b) {
        for (int i = 0; i < a.X(); ++i) {
            for (int j = 0; j < a.Y(); ++j) {
                float value = a.get(i, j) + 1.0f;
                b.set(i, j, value);
            }
        }
    }

    public static void testCopyImagesParallelRandom(ImageFloat a, ImageFloat b) {
        for (int i = 0; i < a.X(); ++i) {
            for (int j = 0; j < a.Y(); ++j) {
                float value = a.get(i, j) + 0.01f;
                b.set(i, j, value);
            }
        }
    }

    public static void testCopyImagesSequential(ImageFloat a, ImageFloat b) {
        for (int i = 0; i < a.X(); ++i) {
            for (int j = 0; j < a.Y(); ++j) {
                float value = a.get(i, j) + 1.0f;
                b.set(i, j, value);
            }
        }
    }

    @Test
    public void testImageFloat01() throws TornadoExecutionPlanException {
        int N = 128;
        int M = 128;
        ImageFloat image = new ImageFloat(128, 128);
        image.fill(100.0f);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{image}).task("t0", arg_0 -> ((ImageFloat)image).fill(arg_0), (Object)Float.valueOf(1.0f)).transferToHost(1, new Object[]{image});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                Assert.assertEquals((double)1.0, (double)image.get(i, j), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat02() throws TornadoExecutionPlanException {
        int M = 128;
        int N = 32;
        ImageFloat image = new ImageFloat(128, 32);
        image.fill(100.0f);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", arg_0 -> ((ImageFloat)image).fill(arg_0), (Object)Float.valueOf(1.0f)).transferToHost(1, new Object[]{image});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 32; ++j) {
                Assert.assertEquals((double)1.0, (double)image.get(i, j), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat03() throws TornadoExecutionPlanException {
        int M = 32;
        int N = 512;
        ImageFloat image = new ImageFloat(32, 512);
        image.fill(100.0f);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", arg_0 -> ((ImageFloat)image).fill(arg_0), (Object)Float.valueOf(1.0f)).transferToHost(1, new Object[]{image});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 512; ++j) {
                Assert.assertEquals((double)1.0, (double)image.get(i, j), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat04() throws TornadoExecutionPlanException {
        int M = 32;
        int N = 32;
        ImageFloat imageA = new ImageFloat(32, 32);
        ImageFloat imageB = new ImageFloat(32, 32);
        imageA.fill(100.0f);
        imageB.fill(0.0f);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageA}).task("t1", TestImages::taskWithImages, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                Assert.assertEquals((double)100.0, (double)imageB.get(i, j), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat05() throws TornadoExecutionPlanException {
        int M = 16;
        int N = 4;
        ImageFloat imageA = new ImageFloat(16, 4);
        ImageFloat imageB = new ImageFloat(16, 4);
        imageA.fill(100.0f);
        imageB.fill(-1.0f);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageA}).task("t1", TestImages::taskWithImages, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 4; ++j) {
                Assert.assertEquals((double)100.0, (double)imageB.get(i, j), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat06() throws TornadoExecutionPlanException {
        int M = 256;
        int N = 512;
        ImageFloat imageA = new ImageFloat(256, 512);
        ImageFloat imageB = new ImageFloat(256, 512);
        imageA.fill(100.0f);
        imageB.fill(-1.0f);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageA}).task("t1", TestImages::taskWithImages, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 512; ++j) {
                Assert.assertEquals((double)100.0, (double)imageB.get(i, j), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat07() throws TornadoExecutionPlanException {
        int M = 512;
        int N = 512;
        ImageFloat3 imageA = new ImageFloat3(512, 512);
        ImageFloat3 imageB = new ImageFloat3(512, 512);
        imageA.fill(100.0f);
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 512; ++j) {
                Float3 value = new Float3(10.0f, 20.0f, 30.0f);
                imageA.set(i, j, value);
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageA}).task("t0", TestImages::taskWithImagesFloat3, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 512; ++j) {
                Float3 result = imageB.get(i, j);
                Assert.assertEquals((double)10.0, (double)result.getX(), (double)0.001);
                Assert.assertEquals((double)20.0, (double)result.getY(), (double)0.001);
                Assert.assertEquals((double)30.0, (double)result.getZ(), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat08() throws TornadoExecutionPlanException {
        int M = 512;
        int N = 32;
        ImageFloat3 imageA = new ImageFloat3(512, 32);
        ImageFloat3 imageB = new ImageFloat3(512, 32);
        imageA.fill(100.0f);
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 32; ++j) {
                Float3 value = new Float3(10.0f, 20.0f, 30.0f);
                imageA.set(i, j, value);
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageA}).task("t0", TestImages::taskWithImagesFloat3, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 32; ++j) {
                Float3 result = imageB.get(i, j);
                Assert.assertEquals((double)10.0, (double)result.getX(), (double)0.001);
                Assert.assertEquals((double)20.0, (double)result.getY(), (double)0.001);
                Assert.assertEquals((double)30.0, (double)result.getZ(), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat09() throws TornadoExecutionPlanException {
        int M = 512;
        int N = 512;
        ImageFloat4 imageA = new ImageFloat4(512, 512);
        ImageFloat4 imageB = new ImageFloat4(512, 512);
        imageA.fill(100.0f);
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 512; ++j) {
                Float4 value = new Float4(10.0f, 20.0f, 30.0f, 40.0f);
                imageA.set(i, j, value);
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageA}).task("t0", TestImages::taskWithImagesFloat4, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 512; ++j) {
                Float4 result = imageB.get(i, j);
                Assert.assertEquals((double)10.0, (double)result.getX(), (double)0.001);
                Assert.assertEquals((double)20.0, (double)result.getY(), (double)0.001);
                Assert.assertEquals((double)30.0, (double)result.getZ(), (double)0.001);
                Assert.assertEquals((double)40.0, (double)result.getW(), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat10() throws TornadoExecutionPlanException {
        int M = 32;
        int N = 512;
        ImageFloat4 imageA = new ImageFloat4(32, 512);
        ImageFloat4 imageB = new ImageFloat4(32, 512);
        imageA.fill(100.0f);
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 512; ++j) {
                Float4 value = new Float4(10.0f, 20.0f, 30.0f, 40.0f);
                imageA.set(i, j, value);
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageA}).task("t0", TestImages::taskWithImagesFloat4, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 512; ++j) {
                Float4 result = imageB.get(i, j);
                Assert.assertEquals((double)10.0, (double)result.getX(), (double)0.001);
                Assert.assertEquals((double)20.0, (double)result.getY(), (double)0.001);
                Assert.assertEquals((double)30.0, (double)result.getZ(), (double)0.001);
                Assert.assertEquals((double)40.0, (double)result.getW(), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat11() throws TornadoExecutionPlanException {
        int M = 512;
        int N = 32;
        ImageFloat8 imageA = new ImageFloat8(512, 32);
        ImageFloat8 imageB = new ImageFloat8(512, 32);
        imageA.fill(100.0f);
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 32; ++j) {
                Float8 value = new Float8(10.0f, 20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f, 80.0f);
                imageA.set(i, j, value);
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageA}).task("t0", TestImages::taskWithImagesFloat8, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 32; ++j) {
                Float8 result = imageB.get(i, j);
                Assert.assertEquals((double)10.0, (double)result.getS0(), (double)0.001);
                Assert.assertEquals((double)20.0, (double)result.getS1(), (double)0.001);
                Assert.assertEquals((double)30.0, (double)result.getS2(), (double)0.001);
                Assert.assertEquals((double)40.0, (double)result.getS3(), (double)0.001);
                Assert.assertEquals((double)50.0, (double)result.getS4(), (double)0.001);
                Assert.assertEquals((double)60.0, (double)result.getS5(), (double)0.001);
                Assert.assertEquals((double)70.0, (double)result.getS6(), (double)0.001);
                Assert.assertEquals((double)80.0, (double)result.getS7(), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat12() throws TornadoExecutionPlanException {
        int M = 512;
        int N = 512;
        ImageByte3 imageA = new ImageByte3(512, 512);
        ImageByte3 imageB = new ImageByte3(512, 512);
        imageA.fill((byte)10);
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 512; ++j) {
                Byte3 value = new Byte3(10, 11, 12);
                imageA.set(i, j, value);
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageA}).task("t0", TestImages::taskWithImagesByte3, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 512; ++j) {
                Byte3 result = imageB.get(i, j);
                Assert.assertEquals((double)10.0, (double)result.getX(), (double)0.001);
                Assert.assertEquals((double)11.0, (double)result.getY(), (double)0.001);
                Assert.assertEquals((double)12.0, (double)result.getZ(), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat13() throws TornadoExecutionPlanException {
        int M = 16;
        int N = 2048;
        ImageByte3 imageA = new ImageByte3(16, 2048);
        ImageByte3 imageB = new ImageByte3(16, 2048);
        imageA.fill((byte)10);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 2048; ++j) {
                Byte3 value = new Byte3(10, 11, 12);
                imageA.set(i, j, value);
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageA}).task("t0", TestImages::taskWithImagesByte3, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 2048; ++j) {
                Byte3 result = imageB.get(i, j);
                Assert.assertEquals((double)10.0, (double)result.getX(), (double)0.001);
                Assert.assertEquals((double)11.0, (double)result.getY(), (double)0.001);
                Assert.assertEquals((double)12.0, (double)result.getZ(), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat14() throws TornadoExecutionPlanException {
        int M = 64;
        int N = 64;
        ImageByte4 imageA = new ImageByte4(64, 64);
        ImageByte4 imageB = new ImageByte4(64, 64);
        imageA.fill((byte)10);
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                Byte4 value = new Byte4(10, 11, 12, 13);
                imageA.set(i, j, value);
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageA}).task("t0", TestImages::taskWithImagesByte4, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                Byte4 result = imageB.get(i, j);
                Assert.assertEquals((double)10.0, (double)result.getX(), (double)0.001);
                Assert.assertEquals((double)11.0, (double)result.getY(), (double)0.001);
                Assert.assertEquals((double)12.0, (double)result.getZ(), (double)0.001);
                Assert.assertEquals((double)13.0, (double)result.getW(), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat15() throws TornadoExecutionPlanException {
        int M = 32;
        int N = 1024;
        ImageByte4 imageA = new ImageByte4(32, 1024);
        ImageByte4 imageB = new ImageByte4(32, 1024);
        imageA.fill((byte)10);
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 1024; ++j) {
                Byte4 value = new Byte4(10, 11, 12, 13);
                imageA.set(i, j, value);
            }
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{imageA}).task("t0", TestImages::taskWithImagesByte4, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 1024; ++j) {
                Byte4 result = imageB.get(i, j);
                Assert.assertEquals((double)10.0, (double)result.getX(), (double)0.001);
                Assert.assertEquals((double)11.0, (double)result.getY(), (double)0.001);
                Assert.assertEquals((double)12.0, (double)result.getZ(), (double)0.001);
                Assert.assertEquals((double)13.0, (double)result.getW(), (double)0.001);
            }
        }
    }

    @Test
    public void testImageFloat16() throws TornadoExecutionPlanException {
        int M = 64;
        int N = 64;
        int base = 10;
        ImageFloat imageA = new ImageFloat(64, 64);
        ImageFloat imageB = new ImageFloat(64, 64);
        imageA.fill(10.0f);
        TaskGraph taskGraph = new TaskGraph("testLoop").transferToDevice(1, new Object[]{imageA}).task("image", TestImages::testCopyImagesParallel, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            for (int iteration = 0; iteration < 10000; ++iteration) {
                int j;
                int i;
                executionPlan.execute();
                for (i = 0; i < 64; ++i) {
                    for (j = 0; j < 64; ++j) {
                        Assert.assertEquals((float)(11 + iteration), (float)imageB.get(i, j), (float)0.1f);
                    }
                }
                for (i = 0; i < 64; ++i) {
                    for (j = 0; j < 64; ++j) {
                        imageA.set(i, j, imageB.get(i, j));
                    }
                }
            }
        }
    }

    @Test
    public void testImageFloat17() throws TornadoExecutionPlanException {
        int M = 64;
        int N = 64;
        int base = 10;
        ImageFloat imageA = new ImageFloat(64, 64);
        ImageFloat imageB = new ImageFloat(64, 64);
        imageA.fill(10.0f);
        TaskGraph taskGraph = new TaskGraph("testLoop").transferToDevice(1, new Object[]{imageA}).task("image", TestImages::testCopyImagesSequential, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            for (int iteration = 0; iteration < 10000; ++iteration) {
                int j;
                int i;
                executionPlan.execute();
                for (i = 0; i < 64; ++i) {
                    for (j = 0; j < 64; ++j) {
                        Assert.assertEquals((float)(11 + iteration), (float)imageB.get(i, j), (float)0.1f);
                    }
                }
                for (i = 0; i < 64; ++i) {
                    for (j = 0; j < 64; ++j) {
                        imageA.set(i, j, imageB.get(i, j));
                    }
                }
            }
        }
    }

    @Test
    public void testImageFloat18() throws TornadoExecutionPlanException {
        int M = 64;
        int N = 64;
        float base = new Random().nextFloat();
        ImageFloat imageA = new ImageFloat(64, 64);
        ImageFloat imageB = new ImageFloat(64, 64);
        imageA.fill(base);
        TaskGraph taskGraph = new TaskGraph("testLoop").transferToDevice(1, new Object[]{imageA}).task("image", TestImages::testCopyImagesParallelRandom, (Object)imageA, (Object)imageB).transferToHost(1, new Object[]{imageB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            for (int iteration = 0; iteration < 10000; ++iteration) {
                int j;
                int i;
                executionPlan.execute();
                for (i = 0; i < 64; ++i) {
                    for (j = 0; j < 64; ++j) {
                        Assert.assertEquals((float)(base + 0.01f), (float)imageB.get(i, j), (float)0.01f);
                    }
                }
                base += 0.01f;
                for (i = 0; i < 64; ++i) {
                    for (j = 0; j < 64; ++j) {
                        imageA.set(i, j, imageB.get(i, j));
                    }
                }
            }
        }
    }
}

