/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.functional;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;

public class TestStreams {
    private static void deviceDummyCompute(DoubleArray src, DoubleArray dst) {
        for (int i = 0; i < src.getSize(); ++i) {
            dst.set(i, src.get(i) * 2.0);
        }
    }

    private static void hostComputeMethod() throws TornadoExecutionPlanException {
        DoubleArray src = new DoubleArray(1024);
        DoubleArray dst = new DoubleArray(1024);
        String threadName = Thread.currentThread().getName();
        TaskGraph taskGraph = new TaskGraph("s1").transferToDevice(1, new Object[]{src, dst}).task(threadName, TestStreams::deviceDummyCompute, (Object)src, (Object)dst).transferToHost(1, new Object[]{dst});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executor = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executor.execute();
        }
    }

    @Test
    public void testParallelStreams() throws TornadoExecutionPlanException {
        ArrayList<Integer> s = new ArrayList<Integer>();
        for (int i = 0; i < 512; ++i) {
            s.add(i);
        }
        s.parallelStream().forEach(k -> {
            try {
                TestStreams.hostComputeMethod();
            }
            catch (TornadoExecutionPlanException e) {
                Assert.fail((String)("Got exception " + String.valueOf((Object)e)));
            }
        });
    }
}

