/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.functional;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestLambdas
extends TornadoTestBase {
    @Test
    public void testVectorFunctionLambda() throws TornadoExecutionPlanException {
        int numElements = 4096;
        DoubleArray a = new DoubleArray(4096);
        DoubleArray b = new DoubleArray(4096);
        DoubleArray c = new DoubleArray(4096);
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, Math.random());
            b.set(i, Math.random());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", (x, y, z) -> {
            for (int i = 0; i < z.getSize(); ++i) {
                z.set(i, x.get(i) + y.get(i));
            }
        }, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((double)(a.get(i2) + b.get(i2)), (double)c.get(i2), (double)0.001);
        }
    }

    @Test
    public void testVectorFunctionLambda02() throws TornadoExecutionPlanException {
        int numElements = 4096;
        DoubleArray a = new DoubleArray(4096);
        DoubleArray b = new DoubleArray(4096);
        DoubleArray c = new DoubleArray(4096);
        Random r = new Random();
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, r.nextDouble());
            b.set(i, (double)r.nextInt(1000));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", (x, y, z) -> {
            for (int i = 0; i < z.getSize(); ++i) {
                z.set(i, x.get(i) * y.get(i));
            }
        }, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((double)(a.get(i2) * b.get(i2)), (double)c.get(i2), (double)0.001);
        }
    }

    @Test
    public void testVectorFunctionLambda03() throws TornadoExecutionPlanException {
        int numElements = 4096;
        DoubleArray a = new DoubleArray(4096);
        IntArray b = new IntArray(4096);
        DoubleArray c = new DoubleArray(4096);
        Random r = new Random();
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, r.nextDouble());
            b.set(i, r.nextInt(1000));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", (x, y, z) -> {
            for (int i = 0; i < z.getSize(); ++i) {
                z.set(i, x.get(i) * (double)y.get(i));
            }
        }, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((double)(a.get(i2) * (double)b.get(i2)), (double)c.get(i2), (double)0.001);
        }
    }

    @Test
    public void testParameterUnboxing() throws TornadoExecutionPlanException {
        float[] arrayToCopy = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.transferToDevice(1, new Object[]{arrayToCopy});
        FloatArray resultArray = new FloatArray(arrayToCopy.length);
        taskGraph.transferToHost(1, new Object[]{resultArray});
        taskGraph.task("t0", (source, sourceOffset, destination, destinationOffset, length) -> {
            for (int i = 0; i < length; ++i) {
                destination.set(destinationOffset + i, source[sourceOffset + i]);
            }
        }, (Object)arrayToCopy, (Object)0, (Object)resultArray, (Object)0, (Object)arrayToCopy.length);
        ImmutableTaskGraph snapshot = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{snapshot});){
            executionPlan.execute();
        }
        Assert.assertArrayEquals((float[])arrayToCopy, (float[])resultArray.toHeapArray(), (float)0.001f);
    }
}

