/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.foundation;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;
import uk.ac.manchester.tornado.unittests.foundation.TestKernels;

public class TestShorts
extends TornadoTestBase {
    @Test
    public void testShortAdd() throws TornadoExecutionPlanException {
        int numElements = 256;
        ShortArray a = new ShortArray(256);
        ShortArray b = new ShortArray(256);
        ShortArray c = new ShortArray(256);
        b.init((short)1);
        c.init((short)3);
        ShortArray expectedResult = new ShortArray(256);
        expectedResult.init((short)4);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b, c}).task("t0", TestKernels::vectorSumShortCompute, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((long)expectedResult.get(i), (long)a.get(i));
        }
    }
}

