/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.foundation;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;
import uk.ac.manchester.tornado.unittests.foundation.TestKernels;

public class TestLong
extends TornadoTestBase {
    @Test
    public void testLongsCopy() throws TornadoExecutionPlanException {
        int numElements = 256;
        LongArray a = new LongArray(256);
        LongArray expected = new LongArray(256);
        for (int i = 0; i < 256; ++i) {
            expected.set(i, 50L);
        }
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestKernels::testLongsCopy, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((long)expected.get(i), (long)a.get(i));
        }
    }

    @Test
    public void testLongsAdd() throws TornadoExecutionPlanException {
        int numElements = 256;
        LongArray a = new LongArray(256);
        LongArray b = new LongArray(256);
        LongArray c = new LongArray(256);
        b.init(Integer.MAX_VALUE);
        c.init(1L);
        LongArray expected = new LongArray(256);
        for (int i = 0; i < 256; ++i) {
            expected.set(i, b.get(i) + c.get(i));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b, c}).task("t0", TestKernels::vectorSumLongCompute, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((long)expected.get(i), (long)a.get(i));
        }
    }
}

