/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.foundation;

import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;

public class TestKernels {
    public static void copyTest(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 50);
        }
    }

    public static void addValue(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, a.get(i) + 50);
        }
    }

    public static void copyTest2(IntArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i));
        }
    }

    public static void compute(IntArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) + 50);
        }
    }

    public static void init(IntArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 100);
            b.set(i, 500);
        }
    }

    public static void vectorAddCompute(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) + c.get(i));
        }
    }

    public static void vectorMul(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) * c.get(i));
        }
    }

    public static void vectorSub(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) - c.get(i));
        }
    }

    public static void vectorDiv(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) / c.get(i));
        }
    }

    public static void vectorSquare(IntArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) * b.get(i));
        }
    }

    public static void saxpy(IntArray a, IntArray b, IntArray c, int alpha) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, alpha * b.get(i) + c.get(i));
        }
    }

    public static void copyTestZero(IntArray a) {
        a.set(0, 50);
    }

    public static void sum(int[] a, int[] b, int[] c) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = b[i] + c[i];
        }
    }

    public static void vectorAddFloatCompute(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) + c.get(i));
        }
    }

    public static void vectorAddDoubleCompute(DoubleArray a, DoubleArray b, DoubleArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) + c.get(i));
        }
    }

    public static void vectorMulDoubleCompute(DoubleArray a, DoubleArray b, DoubleArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) * c.get(i));
        }
    }

    public static void vectorSubDoubleCompute(DoubleArray a, DoubleArray b, DoubleArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) - c.get(i));
        }
    }

    public static void vectorDivDoubleCompute(DoubleArray a, DoubleArray b, DoubleArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) / c.get(i));
        }
    }

    public static void vectorSubFloatCompute(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) - c.get(i));
        }
    }

    public static void vectorMulFloatCompute(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) * c.get(i));
        }
    }

    public static void vectorDivFloatCompute(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) / c.get(i));
        }
    }

    public static void testFloatCopy(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 50.0f);
        }
    }

    public static void testDoublesCopy(DoubleArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 50.0);
        }
    }

    public static void testLongsCopy(LongArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 50L);
        }
    }

    public static void vectorSumLongCompute(LongArray a, LongArray b, LongArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, b.get(i) + c.get(i));
        }
    }

    public static void vectorSumShortCompute(ShortArray a, ShortArray b, ShortArray c) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, (short)(b.get(i) + c.get(i)));
        }
    }

    public static void testIfInt(IntArray a) {
        if (a.get(0) == 0) {
            a.set(0, 50);
        }
    }

    public static void testIfInt2(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            if (a.get(i) != 0) continue;
            a.set(i, 50);
        }
    }

    public static void testIfInt3(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            if (a.get(i) == 0) {
                a.set(i, 50);
                continue;
            }
            a.set(i, 100);
        }
    }

    public static void testIfInt4(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            if (a.get(i) > 0) {
                a.set(i, 50);
                continue;
            }
            a.set(i, 100);
        }
    }

    public static void testIfInt5(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            if (a.get(i) >= 0) {
                a.set(i, 50);
                continue;
            }
            a.set(i, 100);
        }
    }

    public static void testIfInt6(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            if (a.get(i) >= 0 && a.get(i) <= 1) {
                a.set(i, 100);
                continue;
            }
            a.set(i, 200);
        }
    }
}

