/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.foundation;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;
import uk.ac.manchester.tornado.unittests.foundation.TestKernels;

public class TestIntegers
extends TornadoTestBase {
    @Test
    public void test01() throws TornadoExecutionPlanException {
        int numElements = 256;
        IntArray a = new IntArray(256);
        TaskGraph taskGraph = new TaskGraph("s0").task("t,@", TestKernels::copyTestZero, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((long)50L, (long)a.get(0));
    }

    @Test
    public void test02() throws TornadoExecutionPlanException {
        int numElements = 512;
        IntArray a = new IntArray(512);
        IntArray expectedResult = new IntArray(512);
        expectedResult.init(50);
        TaskGraph taskGraph = new TaskGraph("s1").transferToDevice(1, new Object[]{a}).task("t1", TestKernels::copyTest, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 512; ++i) {
            Assert.assertEquals((long)expectedResult.get(i), (long)a.get(i));
        }
    }

    @Test
    public void test03() throws TornadoExecutionPlanException {
        int numElements = 256;
        IntArray a = new IntArray(256);
        IntArray b = new IntArray(256);
        b.init(100);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b}).task("t0", TestKernels::copyTest2, (Object)a, (Object)b).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((long)a.get(i), (long)b.get(i));
        }
    }

    @Test
    public void test04() throws TornadoExecutionPlanException {
        int numElements = 256;
        IntArray a = new IntArray(256);
        IntArray b = new IntArray(256);
        b.init(100);
        IntArray expectedResult = new IntArray(256);
        expectedResult.init(150);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b}).task("t0", TestKernels::compute, (Object)a, (Object)b).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((long)expectedResult.get(i), (long)a.get(i));
        }
    }

    @Test
    public void test05() throws TornadoExecutionPlanException {
        int numElements = 131072;
        IntArray a = new IntArray(131072);
        IntArray b = new IntArray(131072);
        IntArray expectedResultA = new IntArray(131072);
        IntArray expectedResultB = new IntArray(131072);
        expectedResultA.init(100);
        expectedResultB.init(500);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestKernels::init, (Object)a, (Object)b).transferToHost(1, new Object[]{a, b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 131072; ++i) {
            Assert.assertEquals((long)expectedResultA.get(i), (long)a.get(i));
            Assert.assertEquals((long)expectedResultB.get(i), (long)b.get(i));
        }
    }

    @Test
    public void test06() throws TornadoExecutionPlanException {
        int numElements = 131072;
        IntArray a = new IntArray(131072);
        IntArray b = new IntArray(131072);
        IntArray expectedResultA = new IntArray(131072);
        IntArray expectedResultB = new IntArray(131072);
        expectedResultA.init(100);
        expectedResultB.init(500);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestKernels::init, (Object)a, (Object)b).transferToHost(1, new Object[]{a, b});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withPrintKernel().execute();
        }
        for (int i = 0; i < 131072; ++i) {
            Assert.assertEquals((long)expectedResultA.get(i), (long)a.get(i));
            Assert.assertEquals((long)expectedResultB.get(i), (long)b.get(i));
        }
    }

    @Test
    public void test07() throws TornadoExecutionPlanException {
        int numElements = 131072;
        IntArray a = new IntArray(131072);
        IntArray b = new IntArray(131072);
        IntArray expectedResultA = new IntArray(131072);
        IntArray expectedResultB = new IntArray(131072);
        expectedResultA.init(100);
        expectedResultB.init(500);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestKernels::init, (Object)a, (Object)b).transferToHost(1, new Object[]{a, b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withThreadInfo().execute();
            executionPlan.withoutThreadInfo().execute();
        }
        for (int i = 0; i < 131072; ++i) {
            Assert.assertEquals((long)expectedResultA.get(i), (long)a.get(i));
            Assert.assertEquals((long)expectedResultB.get(i), (long)b.get(i));
        }
    }
}

