/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.foundation;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;
import uk.ac.manchester.tornado.unittests.foundation.TestKernels;

public class TestFloats
extends TornadoTestBase {
    @Test
    public void testFloatsCopy() throws TornadoExecutionPlanException {
        int numElements = 256;
        FloatArray a = new FloatArray(256);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestKernels::testFloatCopy, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((float)a.get(0), (float)50.0f, (float)0.01f);
    }

    @Test
    public void testVectorFloatAdd() throws TornadoExecutionPlanException {
        int numElements = 256;
        FloatArray a = new FloatArray(256);
        FloatArray b = new FloatArray(256);
        FloatArray c = new FloatArray(256);
        b.init(100.0f);
        c.init(200.0f);
        FloatArray expected = new FloatArray(256);
        for (int i = 0; i < 256; ++i) {
            expected.set(i, b.get(i) + c.get(i));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b, c}).task("t0", TestKernels::vectorAddFloatCompute, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((float)expected.get(i), (float)a.get(i), (float)0.01f);
        }
    }

    @Test
    public void testVectorFloatSub() throws TornadoExecutionPlanException {
        int numElements = 256;
        FloatArray a = new FloatArray(256);
        FloatArray b = new FloatArray(256);
        FloatArray c = new FloatArray(256);
        b.init(200.0f);
        c.init(100.0f);
        FloatArray expected = new FloatArray(256);
        for (int i = 0; i < 256; ++i) {
            expected.set(i, b.get(i) - c.get(i));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b, c}).task("t0", TestKernels::vectorSubFloatCompute, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((float)expected.get(i), (float)a.get(i), (float)0.01f);
        }
    }

    @Test
    public void testVectorFloatMul() throws TornadoExecutionPlanException {
        int numElements = 256;
        FloatArray a = new FloatArray(256);
        FloatArray b = new FloatArray(256);
        FloatArray c = new FloatArray(256);
        b.init(100.0f);
        c.init(5.0f);
        FloatArray expected = new FloatArray(256);
        for (int i = 0; i < 256; ++i) {
            expected.set(i, b.get(i) * c.get(i));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b, c}).task("t0", TestKernels::vectorMulFloatCompute, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((float)expected.get(i), (float)a.get(i), (float)0.01f);
        }
    }

    @Test
    public void testVectorFloatDiv() throws TornadoExecutionPlanException {
        int numElements = 256;
        FloatArray a = new FloatArray(256);
        FloatArray b = new FloatArray(256);
        FloatArray c = new FloatArray(256);
        b.init(100.0f);
        c.init(5.0f);
        FloatArray expected = new FloatArray(256);
        for (int i = 0; i < 256; ++i) {
            expected.set(i, b.get(i) / c.get(i));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b, c}).task("t0", TestKernels::vectorDivFloatCompute, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((float)expected.get(i), (float)a.get(i), (float)0.01f);
        }
    }
}

