/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.foundation;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;
import uk.ac.manchester.tornado.unittests.foundation.TestKernels;

public class TestDoubles
extends TornadoTestBase {
    @Test
    public void testDoublesCopy() throws TornadoExecutionPlanException {
        int numElements = 256;
        DoubleArray a = new DoubleArray(256);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestKernels::testDoublesCopy, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)a.get(0), (double)50.0, (double)0.01);
    }

    @Test
    public void testDoublesAdd() throws TornadoExecutionPlanException {
        int numElements = 256;
        DoubleArray a = new DoubleArray(256);
        DoubleArray b = new DoubleArray(256);
        DoubleArray c = new DoubleArray(256);
        b.init(100.0);
        c.init(200.0);
        DoubleArray expected = new DoubleArray(256);
        for (int i = 0; i < 256; ++i) {
            expected.set(i, b.get(i) + c.get(i));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b, c}).task("t0", TestKernels::vectorAddDoubleCompute, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((double)expected.get(i), (double)a.get(i), (double)0.01f);
        }
    }

    @Test
    public void testDoublesSub() throws TornadoExecutionPlanException {
        int numElements = 256;
        DoubleArray a = new DoubleArray(256);
        DoubleArray b = new DoubleArray(256);
        DoubleArray c = new DoubleArray(256);
        b.init(2.2);
        c.init(3.5);
        DoubleArray expected = new DoubleArray(256);
        for (int i = 0; i < 256; ++i) {
            expected.set(i, b.get(i) - c.get(i));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b, c}).task("t0", TestKernels::vectorSubDoubleCompute, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((double)expected.get(i), (double)a.get(i), (double)0.01f);
        }
    }

    @Test
    public void testDoublesMul() throws TornadoExecutionPlanException {
        int numElements = 256;
        DoubleArray a = new DoubleArray(256);
        DoubleArray b = new DoubleArray(256);
        DoubleArray c = new DoubleArray(256);
        b.init(2.2);
        c.init(3.5);
        DoubleArray expected = new DoubleArray(256);
        for (int i = 0; i < 256; ++i) {
            expected.set(i, b.get(i) * c.get(i));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b, c}).task("t0", TestKernels::vectorMulDoubleCompute, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((double)expected.get(i), (double)a.get(i), (double)0.01f);
        }
    }

    @Test
    public void testDoublesDiv() throws TornadoExecutionPlanException {
        int numElements = 256;
        DoubleArray a = new DoubleArray(256);
        DoubleArray b = new DoubleArray(256);
        DoubleArray c = new DoubleArray(256);
        b.init(10.2);
        c.init(2.0);
        DoubleArray expected = new DoubleArray(256);
        for (int i = 0; i < 256; ++i) {
            expected.set(i, b.get(i) / c.get(i));
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{b, c}).task("t0", TestKernels::vectorDivDoubleCompute, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < 256; ++i) {
            Assert.assertEquals((double)expected.get(i), (double)a.get(i), (double)0.01f);
        }
    }
}

