/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.foundation;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;
import uk.ac.manchester.tornado.unittests.foundation.TestKernels;

public class MultipleRuns
extends TornadoTestBase {
    @Test
    public void multipleRuns() throws TornadoExecutionPlanException {
        int numElements = 512;
        IntArray a = new IntArray(512);
        int iterations = 50;
        IntArray expectedResult = new IntArray(512);
        expectedResult.init(2500);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestKernels::addValue, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            for (int i = 0; i < 50; ++i) {
                executionPlan.execute();
            }
        }
        for (int i = 0; i < expectedResult.getSize(); ++i) {
            Assert.assertEquals((long)expectedResult.get(i), (long)a.get(i));
        }
    }
}

