/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.flatmap;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestFlatMap
extends TornadoTestBase {
    private static final int SIZE = 256;

    private static void computeFlatMap(FloatArray input, FloatArray output, int size) {
        for (int i = 0; i < size; ++i) {
            if (!(input.get(i) > 100.0f)) continue;
            for (int j = 0; j < size; ++j) {
                output.set(i * size + j, input.get(i) + (float)j);
            }
        }
    }

    @Test
    public void testFlatMap() throws TornadoExecutionPlanException {
        FloatArray input = new FloatArray(65536);
        FloatArray output = new FloatArray(65536);
        FloatArray seq = new FloatArray(65536);
        Random r = new Random();
        IntStream.range(0, input.getSize()).forEach(i -> input.set(i, (float)(50 + r.nextInt(100))));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", TestFlatMap::computeFlatMap, (Object)input, (Object)output, (Object)256).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestFlatMap.computeFlatMap(input, seq, 256);
        for (int i2 = 0; i2 < input.getSize(); ++i2) {
            Assert.assertEquals((float)seq.get(i2), (float)output.get(i2), (float)0.001f);
        }
    }
}

