/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.fields;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Parallel;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;
import uk.ac.manchester.tornado.unittests.common.TornadoVMPTXNotSupported;

public class TestInheritedFields
extends TornadoTestBase {
    public static void incrementPrimitiveA(PrimitiveA a, int size) {
        @Parallel int i = 0;
        while (i < size) {
            int n = i++;
            a.valueA[n] = a.valueA[n] + 1.0f;
        }
    }

    public static void incrementPrimitiveB(PrimitiveB b, int size) {
        @Parallel int i = 0;
        while (i < size) {
            int n = i;
            b.valueA[n] = b.valueA[n] + 1.0f;
            int n2 = i++;
            b.valueB[n2] = b.valueB[n2] + 1.0f;
        }
    }

    public static void incrementTornadoA(TornadoA a, int size) {
        for (int i = 0; i < size; ++i) {
            a.valueA.set(i, a.valueA.get(i) + 1.0f);
        }
    }

    public static void incrementTornadoB(TornadoB b, int size) {
        for (int i = 0; i < size; ++i) {
            b.valueA.set(i, b.valueA.get(i) + 1.0f);
            b.valueB.set(i, b.valueB.get(i) + 1.0f);
        }
    }

    @Before
    public void backendCheck() {
        if (TornadoExecutionPlan.DEFAULT_DEVICE.getTornadoVMBackend() == TornadoVMBackendType.PTX) {
            throw new TornadoVMPTXNotSupported("Test designed to run with multiple backends, including a PTX backend");
        }
    }

    @Test
    public void testIncrementPrimitiveB() {
        int N = 1000;
        PrimitiveB b = new PrimitiveB(1000);
        TaskGraph tg = new TaskGraph("tg");
        tg.transferToDevice(1, new Object[]{b});
        tg.task("t0", TestInheritedFields::incrementPrimitiveB, (Object)b, (Object)1000);
        tg.transferToHost(1, new Object[]{b});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{tg.snapshot()});){
            executionPlan.execute();
            Assert.assertEquals((double)1.0, (double)b.valueA[0], (double)0.0);
            Assert.assertEquals((double)1.0, (double)b.valueB[0], (double)0.0);
        }
        catch (TornadoExecutionPlanException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testIncrementPrimitiveAB() {
        int N = 1000;
        PrimitiveB b = new PrimitiveB(1000);
        TaskGraph tg = new TaskGraph("tg");
        tg.transferToDevice(1, new Object[]{b});
        tg.task("t0", TestInheritedFields::incrementPrimitiveA, (Object)b, (Object)1000);
        tg.task("t1", TestInheritedFields::incrementPrimitiveB, (Object)b, (Object)1000);
        tg.transferToHost(1, new Object[]{b});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{tg.snapshot()});){
            executionPlan.execute();
            Assert.assertEquals((double)2.0, (double)b.valueA[0], (double)0.0);
            Assert.assertEquals((double)1.0, (double)b.valueB[0], (double)0.0);
        }
        catch (TornadoExecutionPlanException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testIncrementTornadoB() {
        int N = 1000;
        TornadoB b = new TornadoB(1000);
        TaskGraph tg = new TaskGraph("tg");
        tg.transferToDevice(1, new Object[]{b});
        tg.task("t0", TestInheritedFields::incrementTornadoB, (Object)b, (Object)1000);
        tg.transferToHost(1, new Object[]{b});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{tg.snapshot()});){
            executionPlan.execute();
            Assert.assertEquals((double)1.0, (double)b.valueA.get(0), (double)0.0);
            Assert.assertEquals((double)1.0, (double)b.valueB.get(0), (double)0.0);
        }
        catch (TornadoExecutionPlanException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testIncrementTornadoAB() {
        int N = 1000;
        TornadoB b = new TornadoB(1000);
        TaskGraph tg = new TaskGraph("tg");
        tg.transferToDevice(1, new Object[]{b});
        tg.task("t0", TestInheritedFields::incrementTornadoA, (Object)b, (Object)1000);
        tg.task("t1", TestInheritedFields::incrementTornadoB, (Object)b, (Object)1000);
        tg.transferToHost(1, new Object[]{b});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{tg.snapshot()});){
            executionPlan.execute();
            Assert.assertEquals((double)2.0, (double)b.valueA.get(0), (double)0.0);
            Assert.assertEquals((double)1.0, (double)b.valueB.get(0), (double)0.0);
        }
        catch (TornadoExecutionPlanException e) {
            e.printStackTrace();
        }
    }

    public static class PrimitiveA {
        public final float[] valueA;

        public PrimitiveA(int size) {
            this.valueA = new float[size];
        }
    }

    public static class PrimitiveB
    extends PrimitiveA {
        public final float[] valueB;

        public PrimitiveB(int size) {
            super(size);
            this.valueB = new float[size];
        }
    }

    public static class TornadoA {
        public final FloatArray valueA;

        public TornadoA(int size) {
            this.valueA = new FloatArray(size);
        }
    }

    public static class TornadoB
    extends TornadoA {
        public final FloatArray valueB;

        public TornadoB(int size) {
            super(size);
            this.valueB = new FloatArray(size);
        }
    }
}

