/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.fields;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.DataRange;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestFields
extends TornadoTestBase {
    public static void setField(A a, float value) {
        a.someOtherField = value;
    }

    public static void setNestedField(A a, float value) {
        a.b.someField = value;
    }

    public static void setNestedArray(A a, IntArray indexes) {
        for (int i = 0; i < indexes.getSize(); ++i) {
            a.b.someArray.set(i, a.b.someArray.get(i) + indexes.get(i) + 3);
        }
    }

    @Test
    public void testFields01() throws TornadoExecutionPlanException {
        int N = 1024;
        Foo foo = new Foo(1024);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", foo::computeInit);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            executionResult.transferToHost(new Object[]{foo.output});
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)100L, (long)foo.output.get(i));
        }
    }

    @Test
    public void testFields02() throws TornadoExecutionPlanException {
        int N = 1024;
        Foo foo = new Foo(1024);
        foo.initRandom();
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", foo::computeAdd);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            executionResult.transferToHost(new Object[]{foo.output});
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)(foo.a.get(i) + foo.b.get(i)), (long)foo.output.get(i));
        }
    }

    @Test
    public void testFields03() throws TornadoExecutionPlanException {
        int N = 1024;
        Bar bar = new Bar(1024, 15);
        TaskGraph taskGraph = new TaskGraph("Bar");
        taskGraph.task("init", bar::computeInit);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            executionResult.transferToHost(new Object[]{bar.output});
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)15L, (long)bar.output.get(i));
        }
    }

    @Test
    public void testFieldsPartialCopyout() throws TornadoExecutionPlanException {
        int N = 1024;
        Foo foo = new Foo(1024);
        foo.initRandom();
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", foo::computeAdd);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            DataRange dataRange = new DataRange((TornadoNativeArray)foo.output);
            executionResult.transferToHost(dataRange.withSize(512L));
            executionResult.transferToHost(dataRange.withOffset(512L).withSize(512L));
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)(foo.a.get(i) + foo.b.get(i)), (long)foo.output.get(i));
        }
    }

    @Test
    public void testFieldsLazyCopyout() throws TornadoExecutionPlanException {
        int N = 1024;
        Foo foo = new Foo(1024);
        foo.initRandom();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{foo.a, foo.b}).task("t0", foo::computeAdd, (Object)foo.a, (Object)foo.b, (Object)foo.output).transferToHost(2, new Object[]{foo.output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            executionResult.transferToHost(new Object[]{foo.output});
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)(foo.a.get(i) + foo.b.get(i)), (long)foo.output.get(i));
        }
    }

    @Test
    public void testFieldsPartialLazyCopyout() throws TornadoExecutionPlanException {
        int N = 1024;
        Foo foo = new Foo(1024);
        foo.initRandom();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{foo.a, foo.b}).task("t0", foo::computeAdd, (Object)foo.a, (Object)foo.b, (Object)foo.output).transferToHost(2, new Object[]{foo.output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            DataRange dataRange = new DataRange((TornadoNativeArray)foo.output);
            executionResult.transferToHost(dataRange.withSize(512L));
            executionResult.transferToHost(dataRange.withOffset(512L).withSize(512L));
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)(foo.a.get(i) + foo.b.get(i)), (long)foo.output.get(i));
        }
    }

    @Test
    public void testSetField() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        B b = new B();
        A a = new A(b);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.transferToDevice(1, new Object[]{a});
        taskGraph.task("t0", TestFields::setField, (Object)a, (Object)Float.valueOf(77.0f));
        taskGraph.transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((float)77.0f, (float)a.someOtherField, (float)0.01f);
        Assert.assertEquals((double)-1.0, (double)a.b.someField, (double)0.01f);
        for (int i = 0; i < b.someArray.getSize(); ++i) {
            Assert.assertEquals((long)-1L, (long)a.b.someArray.get(i));
        }
    }

    @Test
    public void testSetNestedField() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        B b = new B();
        A a = new A(b);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.transferToDevice(1, new Object[]{a});
        taskGraph.task("t0", TestFields::setNestedField, (Object)a, (Object)Float.valueOf(77.0f));
        taskGraph.transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((double)77.0, (double)a.b.someField, (double)0.01f);
        Assert.assertEquals((float)-1.0f, (float)a.someOtherField, (float)0.01f);
        for (int i = 0; i < b.someArray.getSize(); ++i) {
            Assert.assertEquals((long)-1L, (long)a.b.someArray.get(i));
        }
    }

    @Test
    public void testSetNestedArray() throws TornadoExecutionPlanException {
        B b = new B();
        A a = new A(b);
        IntArray indexes = new IntArray(b.someArray.getSize());
        indexes.init(1);
        b.someArray.init(2);
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.transferToDevice(1, new Object[]{a});
        taskGraph.task("t0", TestFields::setNestedArray, (Object)a, (Object)indexes);
        taskGraph.transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < b.someArray.getSize(); ++i) {
            Assert.assertEquals((long)6L, (long)a.b.someArray.get(i));
        }
        Assert.assertEquals((float)-1.0f, (float)a.someOtherField, (float)0.01f);
        Assert.assertEquals((double)-1.0, (double)a.b.someField, (double)0.01f);
    }

    private static class A {
        private final B b;
        float someOtherField;

        A(B b) {
            this.b = b;
            this.someOtherField = -1.0f;
        }
    }

    private static class B {
        final IntArray someArray = new IntArray(100);
        double someField = -1.0;

        B() {
            this.someArray.init(-1);
        }
    }

    private static class Foo {
        final IntArray output;
        final IntArray a;
        final IntArray b;

        Foo(int elements) {
            this.output = new IntArray(elements);
            this.a = new IntArray(elements);
            this.b = new IntArray(elements);
        }

        public void initRandom() {
            Random r = new Random();
            IntStream.range(0, this.a.getSize()).forEach(idx -> {
                this.a.set(idx, r.nextInt(100));
                this.b.set(idx, r.nextInt(100));
            });
        }

        public void computeInit() {
            for (int i = 0; i < this.output.getSize(); ++i) {
                this.output.set(i, 100);
            }
        }

        public void computeAdd() {
            for (int i = 0; i < this.output.getSize(); ++i) {
                this.output.set(i, this.a.get(i) + this.b.get(i));
            }
        }

        public void computeAdd(IntArray a, IntArray b, IntArray output) {
            for (int i = 0; i < output.getSize(); ++i) {
                output.set(i, a.get(i) + b.get(i));
            }
        }
    }

    private static class Bar {
        final IntArray output;
        final int initValue;

        Bar(int elements, int initValue) {
            this.output = new IntArray(elements);
            this.initValue = initValue;
        }

        public void computeInit() {
            for (int i = 0; i < this.output.getSize(); ++i) {
                this.output.set(i, this.initValue);
            }
        }
    }
}

