/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.fails;

import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoBackend;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoFailureException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestFails
extends TornadoTestBase {
    private void reset() {
        for (int backendIndex = 0; backendIndex < TornadoRuntimeProvider.getTornadoRuntime().getNumBackends(); ++backendIndex) {
            TornadoBackend driver = TornadoRuntimeProvider.getTornadoRuntime().getBackend(backendIndex);
            for (int deviceIndex = 0; deviceIndex < driver.getNumDevices(); ++deviceIndex) {
                driver.getDevice(deviceIndex).clean();
            }
        }
    }

    @Test(expected=TornadoFailureException.class)
    public void test01() {
        FloatArray x = new FloatArray(100);
        FloatArray y = new FloatArray(100);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{x}).task("s0", (a, b) -> {
            for (int i = 0; i < 100; ++i) {
            }
        }, (Object)x, (Object)y).transferToHost(1, new Object[]{y});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlanPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlanPlan.withPreCompilation().execute();
        this.reset();
        executionPlanPlan.execute();
    }

    private static void kernel(FloatArray a, FloatArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            b.set(i, a.get(i));
        }
    }

    @Test(expected=TornadoRuntimeException.class)
    public void test02() {
        FloatArray x = new FloatArray(100);
        FloatArray y = new FloatArray(100);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{x}).task("s0", TestFails::kernel, (Object)x, (Object)y).transferToHost(1, new Object[]{y});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlanPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlanPlan.execute();
    }
}

