/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.fails;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.annotations.Reduce;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoBailoutRuntimeException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DFloat;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class CodeFail
extends TornadoTestBase {
    public static void foo(FloatArray a) {
        float[] x = new float[a.getSize() % 10];
        for (int i = 0; i < x.length; ++i) {
            a.set(i, a.get(i) * a.get(i));
        }
    }

    @Test
    public void codeFail01() {
        FloatArray a = new FloatArray(1000);
        FloatArray b = new FloatArray(1000);
        Random r = new Random();
        IntStream.range(0, a.getSize()).forEach(i -> {
            a.set(i, r.nextFloat());
            b.set(i, a.get(i));
        });
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", CodeFail::foo, (Object)a).transferToDevice(0, new Object[]{a}).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
    }

    public static void bar(FloatArray a) {
        Matrix2DFloat f = new Matrix2DFloat(256, 256);
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                f.set(i, j, 10.0f);
            }
        }
    }

    @Test
    public void codeFail02() {
        try {
            FloatArray a = new FloatArray(1000);
            FloatArray b = new FloatArray(1000);
            Random r = new Random();
            IntStream.range(0, a.getSize()).forEach(i -> {
                a.set(i, r.nextFloat());
                b.set(i, a.get(i));
            });
            TaskGraph taskGraph = new TaskGraph("s0");
            taskGraph.task("t0", CodeFail::bar, (Object)a).transferToDevice(0, new Object[]{a}).transferToHost(1, new Object[]{a});
            ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
            TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
            executionPlan.execute();
        }
        catch (TornadoBailoutRuntimeException e) {
            this.assertNotBackend(TornadoVMBackendType.OPENCL);
            this.assertNotBackend(TornadoVMBackendType.SPIRV);
        }
    }

    public static void zoo(IntArray input, @Reduce IntArray output1, @Reduce IntArray output2) {
        for (int i = 0; i < input.getSize(); ++i) {
            output1.set(0, output1.get(0) + input.get(i));
            output2.set(0, output2.get(0) + input.get(i));
        }
    }

    @Test(expected=TornadoBailoutRuntimeException.class)
    public void codeFail03() {
        int size = 128;
        IntArray input = new IntArray(128);
        IntArray result1 = new IntArray(1);
        result1.init(0);
        IntArray result2 = new IntArray(1);
        result2.init(0);
        IntStream.range(0, 128).parallel().forEach(i -> input.set(i, i));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{input}).task("t0", CodeFail::zoo, (Object)input, (Object)result1, (Object)result2).transferToHost(1, new Object[]{result1, result2});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
    }
}

