/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.executor;

import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.TornadoProfilerResult;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.enums.ProfilerMode;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.TestHello;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestExecutor
extends TornadoTestBase {
    @Test
    public void test01() throws TornadoExecutionPlanException {
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        IntArray c = new IntArray(numElements);
        a.init(1);
        b.init(2);
        TaskGraph tg = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = tg.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoDevice defaultDevice = TornadoExecutionPlan.DEFAULT_DEVICE;
            String deviceName = defaultDevice.getPhysicalDevice().getDeviceName();
            Assert.assertNotNull((Object)deviceName);
            executionPlan.withProfiler(ProfilerMode.SILENT).withPreCompilation().withDevice(defaultDevice).withDefaultScheduler();
            TornadoExecutionResult executionResult = executionPlan.execute();
            TornadoProfilerResult profilerResult = executionResult.getProfilerResult();
            Assert.assertNotNull((Object)profilerResult);
            for (int i = 0; i < c.getSize(); ++i) {
                Assert.assertEquals((long)(a.get(i) + b.get(i)), (long)c.get(i));
            }
        }
    }

    @Test
    public void test02() throws TornadoExecutionPlanException {
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        IntArray c = new IntArray(numElements);
        a.init(1);
        b.init(2);
        TaskGraph tg = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = tg.snapshot();
        try (TornadoExecutionPlan executorPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            for (int i = 0; i < 10; ++i) {
                executorPlan.execute();
            }
        }
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((long)(a.get(i) + b.get(i)), (long)c.get(i));
        }
    }

    @Test
    public void test03() throws TornadoExecutionPlanException {
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        IntArray c = new IntArray(numElements);
        boolean INIT_A = true;
        int INIT_B = 2;
        a.init(1);
        b.init(2);
        TaskGraph tg = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = tg.snapshot();
        try (TornadoExecutionPlan executorPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executorPlan.execute();
            for (int i = 0; i < c.getSize(); ++i) {
                Assert.assertEquals((long)(a.get(i) + b.get(i)), (long)c.get(i));
            }
            int[] d = new int[numElements];
            Arrays.fill(d, 10);
            tg.transferToDevice(1, new Object[]{d});
            executorPlan.execute();
        }
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((long)3L, (long)c.get(i));
        }
    }

    @Test
    public void test04() throws TornadoExecutionPlanException {
        int numElements = 16;
        int ITERATIONS = 10;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        boolean INIT_A = false;
        a.init(0);
        TaskGraph tg = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestHello::simple, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = tg.snapshot();
        try (TornadoExecutionPlan executorPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executorPlan.execute();
            TaskGraph tg2 = new TaskGraph("graph2").transferToDevice(1, new Object[]{b}).task("t0", TestHello::simple, (Object)b, (Object)a).transferToHost(1, new Object[]{a});
            ImmutableTaskGraph immutableTaskGraph2 = tg2.snapshot();
            try (TornadoExecutionPlan executorPlan2 = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph2});){
                for (int i = 0; i < 10; ++i) {
                    executorPlan.execute();
                    executorPlan2.execute();
                }
            }
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)20L, (long)a.get(i));
        }
    }

    @Test
    public void test05() throws TornadoExecutionPlanException {
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        IntArray c = new IntArray(numElements);
        a.init(1);
        b.init(2);
        TaskGraph tg = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{tg.snapshot()});){
            executionPlan.execute();
            executionPlan.printTraceExecutionPlan();
            try {
                String string = executionPlan.getTraceExecutionPlan();
            }
            catch (NullPointerException e) {
                Assert.fail();
            }
            TornadoDevice device = TornadoExecutionPlan.getDevice((int)0, (int)0);
            WorkerGrid1D workerGrid = new WorkerGrid1D(16);
            GridScheduler grid = new GridScheduler("s0.t0", (WorkerGrid)workerGrid);
            TornadoExecutionPlan trace = executionPlan.withPreCompilation().withDevice(device).withGridScheduler(grid).withThreadInfo().withProfiler(ProfilerMode.SILENT);
            executionPlan.execute();
            trace.printTraceExecutionPlan();
            executionPlan.printTraceExecutionPlan();
            String trace1 = trace.getTraceExecutionPlan();
            String trace2 = executionPlan.getTraceExecutionPlan();
            Assert.assertEquals((Object)trace1, (Object)trace2);
            TornadoExecutionResult planResult = executionPlan.getPlanResult(0);
            System.out.println("After the execution");
            System.out.println(planResult.getProfilerResult().getTraceExecutionPlan());
        }
    }

    @Test
    public void test06() throws TornadoExecutionPlanException {
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        IntArray c = new IntArray(numElements);
        a.init(1);
        b.init(2);
        TaskGraph tg1 = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        TaskGraph tg2 = new TaskGraph("s1").transferToDevice(0, new Object[]{a, b}).task("t1", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{tg1.snapshot(), tg2.snapshot()});){
            int i;
            executionPlan.withGraph(1).execute();
            for (i = 0; i < c.getSize(); ++i) {
                Assert.assertEquals((long)(a.get(i) + b.get(i)), (long)c.get(i));
            }
            executionPlan.withGraph(0).execute();
            for (i = 0; i < c.getSize(); ++i) {
                Assert.assertEquals((long)(a.get(i) + b.get(i)), (long)c.get(i));
            }
            executionPlan.withAllGraphs().execute();
        }
    }

    @Test
    public void test07() throws TornadoExecutionPlanException {
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        IntArray c = new IntArray(numElements);
        Random r = new Random();
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        }
        TaskGraph tg1 = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        TaskGraph tg2 = new TaskGraph("s1").transferToDevice(1, new Object[]{c}).task("t1", TestHello::compute, (Object)c).transferToHost(1, new Object[]{c});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{tg1.snapshot(), tg2.snapshot()});){
            int i;
            executionPlan.withGraph(0).execute();
            for (i = 0; i < c.getSize(); ++i) {
                Assert.assertEquals((long)(a.get(i) + b.get(i)), (long)c.get(i));
            }
            executionPlan.withGraph(1).execute();
            for (i = 0; i < c.getSize(); ++i) {
                Assert.assertEquals((long)((a.get(i) + b.get(i)) * 2), (long)c.get(i));
            }
        }
    }
}

