/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.dynsize;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class ResizeTest
extends TornadoTestBase {
    public static void resize01(FloatArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 1.0f);
        }
    }

    public static void resize02(FloatArray a, FloatArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            b.set(i, a.get(i) + 10.0f);
        }
    }

    public FloatArray createArray(int numElements) {
        FloatArray a = new FloatArray(numElements);
        IntStream.range(0, numElements).sequential().forEach(i -> a.set(i, 10.0f));
        return a;
    }

    @Test
    public void testDynamicSize01() throws TornadoExecutionPlanException {
        FloatArray a = this.createArray(256);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", ResizeTest::resize01, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlanPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlanPlan.execute();
        }
        FloatArray b = this.createArray(512);
        TaskGraph taskGraph2 = new TaskGraph("graph2").transferToDevice(1, new Object[]{b}).task("t0", ResizeTest::resize01, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph2 = taskGraph2.snapshot();
        try (TornadoExecutionPlan executionPlanPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph2});){
            executionPlanPlan.execute();
        }
        for (int i = 0; i < b.getSize(); ++i) {
            Assert.assertEquals((float)1.0f, (float)b.get(i), (float)0.001f);
        }
    }

    @Test
    public void testDynamicSize02() throws TornadoExecutionPlanException {
        FloatArray a = this.createArray(256);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", ResizeTest::resize01, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlanPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlanPlan.execute();
        }
        FloatArray b = this.createArray(512);
        TaskGraph taskGraph2 = new TaskGraph("graph2").transferToDevice(1, new Object[]{b}).task("t0", ResizeTest::resize01, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph2 = taskGraph2.snapshot();
        try (TornadoExecutionPlan executionPlanPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph2});){
            executionPlanPlan.execute();
        }
        FloatArray c = this.createArray(2048);
        TaskGraph taskGraph3 = new TaskGraph("graph3").transferToDevice(1, new Object[]{c}).task("t0", ResizeTest::resize01, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph3 = taskGraph3.snapshot();
        try (TornadoExecutionPlan executionPlanPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph3});){
            executionPlanPlan.execute();
        }
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((float)1.0f, (float)c.get(i), (float)0.001f);
        }
    }
}

