/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.compiler;

import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestCompilerFlagsAPI
extends TornadoTestBase {
    private static void foo(FloatArray data) {
        for (int i = 0; i < data.getSize(); ++i) {
            data.set(i, data.get(i) + 1.0f);
        }
    }

    @Test
    public void testOpenCL() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        FloatArray data = new FloatArray(512);
        data.init(1.0f);
        TaskGraph taskGraph = new TaskGraph("init").task("foo", TestCompilerFlagsAPI::foo, (Object)data).transferToHost(1, new Object[]{data});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withCompilerFlags(TornadoVMBackendType.OPENCL, "-cl-opt-disable").execute();
        }
    }

    @Test
    public void testPTX() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.OPENCL);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        FloatArray data = new FloatArray(512);
        data.init(1.0f);
        TaskGraph taskGraph = new TaskGraph("init").task("foo", TestCompilerFlagsAPI::foo, (Object)data).transferToHost(1, new Object[]{data});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withCompilerFlags(TornadoVMBackendType.PTX, "CU_JIT_OPTIMIZATION_LEVEL 0").execute();
        }
    }

    @Test
    public void testSPIRV() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.OPENCL);
        this.assertNotBackend(TornadoVMBackendType.PTX);
        FloatArray data = new FloatArray(512);
        data.init(1.0f);
        TaskGraph taskGraph = new TaskGraph("init").task("foo", TestCompilerFlagsAPI::foo, (Object)data).transferToHost(1, new Object[]{data});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withCompilerFlags(TornadoVMBackendType.SPIRV, "-ze-opt-level 1").execute();
        }
    }
}

