/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.codegen;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestSignedComparisonsCodegen
extends TornadoTestBase {
    private static void testKernel01(KernelContext context, IntArray array) {
        int idx = context.globalIdx;
        if (0 < idx && idx < array.getSize()) {
            array.set(idx, 1);
        }
    }

    private static void testKernel02(KernelContext context, IntArray array) {
        int idx = context.globalIdx;
        if (idx > 2 && idx % 2 == 0) {
            array.set(idx, 1);
        }
    }

    private static void testKernel03(KernelContext context, IntArray array) {
        int idx = context.globalIdx;
        if (idx > 2 || idx % 2 == 0) {
            array.set(idx, 1);
        }
    }

    private static void testKernel04(KernelContext context, IntArray array) {
        boolean isInBounds;
        int idx = context.globalIdx;
        int i = 5 - idx;
        boolean bl = isInBounds = 0 < idx && idx < array.getSize() && 0 < i && i < array.getSize();
        if (isInBounds) {
            array.set(idx, 1);
        }
    }

    @Test
    public void testSigned01() {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 8;
        IntArray testArr = new IntArray(size);
        testArr.init(0);
        WorkerGrid1D workerGrid = new WorkerGrid1D(size / 2);
        GridScheduler gridScheduler = new GridScheduler("testSigned.testKernel01", (WorkerGrid)workerGrid);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("testSigned").transferToDevice(0, new Object[]{testArr}).task("testKernel01", TestSignedComparisonsCodegen::testKernel01, (Object)context, (Object)testArr).transferToHost(1, new Object[]{testArr});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        catch (TornadoExecutionPlanException e) {
            throw new RuntimeException(e);
        }
        Assert.assertArrayEquals((int[])new int[]{0, 1, 1, 1, 0, 0, 0, 0}, (int[])testArr.toHeapArray());
    }

    @Test
    public void testSigned02() {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 8;
        IntArray testArr = new IntArray(size);
        testArr.init(0);
        WorkerGrid1D workerGrid = new WorkerGrid1D(size);
        GridScheduler gridScheduler = new GridScheduler("testSigned.testKernel02", (WorkerGrid)workerGrid);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("testSigned").transferToDevice(0, new Object[]{testArr}).task("testKernel02", TestSignedComparisonsCodegen::testKernel02, (Object)context, (Object)testArr).transferToHost(1, new Object[]{testArr});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        catch (TornadoExecutionPlanException e) {
            throw new RuntimeException(e);
        }
        Assert.assertArrayEquals((int[])new int[]{0, 0, 0, 0, 1, 0, 1, 0}, (int[])testArr.toHeapArray());
    }

    @Test
    public void testSigned03() {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 8;
        IntArray testArr = new IntArray(size);
        testArr.init(0);
        WorkerGrid1D workerGrid = new WorkerGrid1D(size / 2);
        GridScheduler gridScheduler = new GridScheduler("testSigned.testKernel03", (WorkerGrid)workerGrid);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("testSigned").transferToDevice(0, new Object[]{testArr}).task("testKernel03", TestSignedComparisonsCodegen::testKernel03, (Object)context, (Object)testArr).transferToHost(1, new Object[]{testArr});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        catch (TornadoExecutionPlanException e) {
            throw new RuntimeException(e);
        }
        Assert.assertArrayEquals((int[])new int[]{1, 0, 1, 1, 0, 0, 0, 0}, (int[])testArr.toHeapArray());
    }

    @Test
    public void testSigned04() {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 8;
        IntArray testArr = new IntArray(size);
        WorkerGrid1D workerGrid = new WorkerGrid1D(size);
        GridScheduler gridScheduler = new GridScheduler("testSigned.testKernel04", (WorkerGrid)workerGrid);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("testSigned").transferToDevice(0, new Object[]{testArr}).task("testKernel04", TestSignedComparisonsCodegen::testKernel04, (Object)context, (Object)testArr).transferToHost(1, new Object[]{testArr});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        catch (TornadoExecutionPlanException e) {
            throw new RuntimeException(e);
        }
        Assert.assertArrayEquals((int[])new int[]{0, 1, 1, 1, 1, 0, 0, 0}, (int[])testArr.toHeapArray());
    }
}

