/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.codegen;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestShortCircuits
extends TornadoTestBase {
    private static void runShortCircuitOrNode(KernelContext context, IntArray array) {
        int idx = context.globalIdx;
        int i = 1 - idx;
        int j = 1 + idx;
        boolean isInBounds = i < array.getSize() || j < array.getSize();
        array.set(idx, isInBounds ? 1 : 0);
    }

    private static void runShortCircuitAndNode(KernelContext context, IntArray array) {
        int idx = context.globalIdx;
        int i = 1 - idx;
        int j = 1 + idx;
        boolean isInBounds = i < array.getSize() && j < array.getSize();
        array.set(idx, isInBounds ? 1 : 0);
    }

    @Test
    public void testShortCircuitOrNode() {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 8;
        IntArray testArr = new IntArray(size);
        testArr.init(-1);
        WorkerGrid1D workerGrid = new WorkerGrid1D(size);
        GridScheduler gridScheduler = new GridScheduler("s0.runShortCircuitOrNode", (WorkerGrid)workerGrid);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{testArr}).task("runShortCircuitOrNode", TestShortCircuits::runShortCircuitOrNode, (Object)context, (Object)testArr).transferToHost(1, new Object[]{testArr});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        catch (TornadoInternalError e) {
            System.out.println(e.getMessage());
        }
        catch (TornadoExecutionPlanException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)1L, (long)testArr.get(i));
        }
    }

    @Test
    public void testShortCircuitAndNode() {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 8;
        IntArray testArr = new IntArray(size);
        testArr.init(-1);
        WorkerGrid1D workerGrid = new WorkerGrid1D(size);
        GridScheduler gridScheduler = new GridScheduler("s0.runShortCircuitAndNode", (WorkerGrid)workerGrid);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{testArr}).task("runShortCircuitAndNode", TestShortCircuits::runShortCircuitAndNode, (Object)context, (Object)testArr).transferToHost(1, new Object[]{testArr});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        catch (TornadoExecutionPlanException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                Assert.assertEquals((long)0L, (long)testArr.get(i));
                continue;
            }
            Assert.assertEquals((long)1L, (long)testArr.get(i));
        }
    }
}

