/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.branching;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DDouble;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestLoopConditions
extends TornadoTestBase {
    public static void conditionBeforeSingleLoopReturn(IntArray a, IntArray b, IntArray c) {
        if (a.get(0) > b.get(0)) {
            return;
        }
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void conditionBeforeSingleLoopComputation(IntArray a, IntArray b, IntArray c) {
        if (a.get(0) > b.get(0)) {
            b.set(0, a.get(0));
        }
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void conditionInSingleLoopReturn(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            if (a.get(0) > b.get(0)) {
                return;
            }
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void conditionInSingleLoopComputation(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            if (a.get(i) > b.get(i)) {
                b.set(i, a.get(i));
            }
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void conditionBeforeOuterForLoopReturn(Matrix2DDouble matrixA, Matrix2DDouble matrixB, Matrix2DDouble result) {
        if (matrixA.get(0, 0) != matrixB.get(1, 1)) {
            return;
        }
        for (int i = 0; i < result.getNumRows(); ++i) {
            for (int j = 0; j < result.getNumColumns(); ++j) {
                result.set(i, j, matrixA.get(i, j) + matrixB.get(i, j));
            }
        }
    }

    public static void conditionBeforeOuterForLoopComputation(Matrix2DDouble matrixA, Matrix2DDouble matrixB, Matrix2DDouble result) {
        if (matrixA.get(0, 0) != matrixB.get(1, 1)) {
            result.set(0, 0, matrixA.get(0, 0) + matrixB.get(0, 0));
        }
        for (int i = 0; i < result.getNumRows(); ++i) {
            for (int j = 0; j < result.getNumColumns(); ++j) {
                result.set(i, j, matrixA.get(i, j) + matrixB.get(i, j));
            }
        }
    }

    public static void conditionBeforeInnerForLoopReturn(Matrix2DDouble matrixA, Matrix2DDouble matrixB, Matrix2DDouble result) {
        for (int i = 0; i < result.getNumRows(); ++i) {
            if (matrixA.get(0, 0) != matrixB.get(1, 1)) {
                return;
            }
            for (int j = 0; j < result.getNumColumns(); ++j) {
                result.set(i, j, matrixA.get(i, j) + matrixB.get(i, j));
            }
        }
    }

    public static void conditionBeforeInnerForLoopComputation(Matrix2DDouble matrixA, Matrix2DDouble matrixB, Matrix2DDouble result) {
        for (int i = 0; i < result.getNumRows(); ++i) {
            if (matrixA.get(0, 0) != matrixB.get(1, 1)) {
                result.set(0, 0, matrixA.get(0, 0) + matrixB.get(0, 0));
            }
            for (int j = 0; j < result.getNumColumns(); ++j) {
                result.set(i, j, matrixA.get(i, j) + matrixB.get(i, j));
            }
        }
    }

    public static void conditionInInnerForLoopReturn(Matrix2DDouble matrixA, Matrix2DDouble matrixB, Matrix2DDouble result) {
        for (int i = 0; i < result.getNumRows(); ++i) {
            for (int j = 0; j < result.getNumColumns(); ++j) {
                if (matrixA.get(0, 0) != matrixB.get(1, 1)) {
                    return;
                }
                result.set(i, j, matrixA.get(i, j) + matrixB.get(i, j));
            }
        }
    }

    public static void conditionInInnerForLoopComputation(Matrix2DDouble matrixA, Matrix2DDouble matrixB, Matrix2DDouble result) {
        for (int i = 0; i < result.getNumRows(); ++i) {
            for (int j = 0; j < result.getNumColumns(); ++j) {
                if (matrixA.get(0, 0) != matrixB.get(1, 1)) {
                    result.set(0, 0, matrixA.get(0, 0) + matrixB.get(0, 0));
                }
                result.set(i, j, matrixA.get(i, j) + matrixB.get(i, j));
            }
        }
    }

    public static void conditionAfterInnerForLoopComputation(Matrix2DDouble matrixA, Matrix2DDouble matrixB, Matrix2DDouble result) {
        for (int i = 0; i < result.getNumRows(); ++i) {
            for (int j = 0; j < result.getNumColumns(); ++j) {
                result.set(i, j, matrixA.get(i, j) + matrixB.get(i, j));
            }
            if (matrixA.get(0, 0) == matrixB.get(1, 1)) continue;
            result.set(0, 0, matrixA.get(0, 0) + matrixB.get(0, 0));
        }
    }

    public static void conditionAfterOuterForLoopComputation(Matrix2DDouble matrixA, Matrix2DDouble matrixB, Matrix2DDouble result) {
        for (int i = 0; i < result.getNumRows(); ++i) {
            for (int j = 0; j < result.getNumColumns(); ++j) {
                result.set(i, j, matrixA.get(i, j) + matrixB.get(i, j));
            }
        }
        if (matrixA.get(0, 0) != matrixB.get(1, 1)) {
            result.set(0, 0, matrixA.get(0, 0) + matrixB.get(0, 0));
        }
    }

    public static Matrix2DDouble matrix2DDoubleInit(int X, int Y) {
        double[][] a = new double[X][Y];
        Random r = new Random();
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                a[i][j] = r.nextDouble();
            }
        }
        return new Matrix2DDouble(a);
    }

    @Test
    public void testConditionBeforeSingleLoopReturn() throws TornadoExecutionPlanException {
        int numberOfElements = 2048;
        IntArray a = new IntArray(2048);
        IntArray b = new IntArray(2048);
        IntArray c = new IntArray(2048);
        IntArray serial = new IntArray(2048);
        Random r = new Random();
        IntStream.range(0, 2048).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestLoopConditions::conditionBeforeSingleLoopReturn, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoopConditions.conditionBeforeSingleLoopReturn(a, b, serial);
        for (int i2 = 0; i2 < 2048; ++i2) {
            Assert.assertEquals((long)serial.get(i2), (long)c.get(i2));
        }
    }

    @Test
    public void testConditionBeforeSingleLoopComputation() throws TornadoExecutionPlanException {
        int numberOfElements = 2048;
        IntArray a = new IntArray(2048);
        IntArray b = new IntArray(2048);
        IntArray c = new IntArray(2048);
        IntArray serial = new IntArray(2048);
        Random r = new Random();
        IntStream.range(0, 2048).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestLoopConditions::conditionBeforeSingleLoopComputation, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoopConditions.conditionBeforeSingleLoopComputation(a, b, serial);
        for (int i2 = 0; i2 < 2048; ++i2) {
            Assert.assertEquals((long)serial.get(i2), (long)c.get(i2));
        }
    }

    @Test
    public void testConditionInSingleLoopReturn() throws TornadoExecutionPlanException {
        int numberOfElements = 2048;
        IntArray a = new IntArray(2048);
        IntArray b = new IntArray(2048);
        IntArray c = new IntArray(2048);
        IntArray serial = new IntArray(2048);
        Random r = new Random();
        IntStream.range(0, 2048).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestLoopConditions::conditionInSingleLoopReturn, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoopConditions.conditionInSingleLoopReturn(a, b, serial);
        for (int i2 = 0; i2 < 2048; ++i2) {
            Assert.assertEquals((long)serial.get(i2), (long)c.get(i2));
        }
    }

    @Test
    public void testConditionInSingleLoopComputation() throws TornadoExecutionPlanException {
        int numberOfElements = 2048;
        IntArray a = new IntArray(2048);
        IntArray b = new IntArray(2048);
        IntArray c = new IntArray(2048);
        IntArray serial = new IntArray(2048);
        Random r = new Random();
        IntStream.range(0, 2048).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestLoopConditions::conditionInSingleLoopComputation, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoopConditions.conditionInSingleLoopComputation(a, b, serial);
        for (int i2 = 0; i2 < 2048; ++i2) {
            Assert.assertEquals((long)serial.get(i2), (long)c.get(i2));
        }
    }

    @Test
    public void testConditionBeforeOuterForLoopReturn() throws TornadoExecutionPlanException {
        int X = 128;
        int Y = 128;
        Matrix2DDouble matrixA = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixB = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixC = new Matrix2DDouble(X, Y);
        Matrix2DDouble matrixSerial = new Matrix2DDouble(X, Y);
        TaskGraph taskGraph = new TaskGraph("t0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("s0", TestLoopConditions::conditionBeforeOuterForLoopReturn, (Object)matrixA, (Object)matrixB, (Object)matrixC).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoopConditions.conditionBeforeOuterForLoopReturn(matrixA, matrixB, matrixSerial);
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Assert.assertEquals((double)matrixSerial.get(i, j), (double)matrixC.get(i, j), (double)0.01);
            }
        }
    }

    @Test
    public void testConditionBeforeOuterForLoopComputation() throws TornadoExecutionPlanException {
        int X = 128;
        int Y = 128;
        Matrix2DDouble matrixA = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixB = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixC = new Matrix2DDouble(X, Y);
        Matrix2DDouble matrixSerial = new Matrix2DDouble(X, Y);
        TaskGraph taskGraph = new TaskGraph("t0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("s0", TestLoopConditions::conditionBeforeOuterForLoopComputation, (Object)matrixA, (Object)matrixB, (Object)matrixC).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoopConditions.conditionBeforeOuterForLoopComputation(matrixA, matrixB, matrixSerial);
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Assert.assertEquals((double)matrixSerial.get(i, j), (double)matrixC.get(i, j), (double)0.01);
            }
        }
    }

    @Test
    public void testConditionBeforeInnerForLoopReturn() throws TornadoExecutionPlanException {
        int X = 128;
        int Y = 128;
        Matrix2DDouble matrixA = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixB = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixC = new Matrix2DDouble(X, Y);
        Matrix2DDouble matrixSerial = new Matrix2DDouble(X, Y);
        TaskGraph taskGraph = new TaskGraph("t0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("s0", TestLoopConditions::conditionBeforeInnerForLoopReturn, (Object)matrixA, (Object)matrixB, (Object)matrixC).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoopConditions.conditionBeforeInnerForLoopReturn(matrixA, matrixB, matrixSerial);
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Assert.assertEquals((double)matrixSerial.get(i, j), (double)matrixC.get(i, j), (double)0.01);
            }
        }
    }

    @Test
    public void testConditionBeforeInnerForLoopComputation() throws TornadoExecutionPlanException {
        int X = 128;
        int Y = 128;
        Matrix2DDouble matrixA = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixB = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixC = new Matrix2DDouble(X, Y);
        Matrix2DDouble matrixSerial = new Matrix2DDouble(X, Y);
        TaskGraph taskGraph = new TaskGraph("t0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("s0", TestLoopConditions::conditionBeforeInnerForLoopComputation, (Object)matrixA, (Object)matrixB, (Object)matrixC).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoopConditions.conditionBeforeInnerForLoopComputation(matrixA, matrixB, matrixSerial);
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Assert.assertEquals((double)matrixSerial.get(i, j), (double)matrixC.get(i, j), (double)0.01);
            }
        }
    }

    @Test
    public void testConditionInInnerForLoopReturn() throws TornadoExecutionPlanException {
        int X = 128;
        int Y = 128;
        Matrix2DDouble matrixA = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixB = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixC = new Matrix2DDouble(X, Y);
        Matrix2DDouble matrixSerial = new Matrix2DDouble(X, Y);
        TaskGraph taskGraph = new TaskGraph("t0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("s0", TestLoopConditions::conditionInInnerForLoopReturn, (Object)matrixA, (Object)matrixB, (Object)matrixC).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoopConditions.conditionInInnerForLoopReturn(matrixA, matrixB, matrixSerial);
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Assert.assertEquals((double)matrixSerial.get(i, j), (double)matrixC.get(i, j), (double)0.01);
            }
        }
    }

    @Test
    public void testConditionInInnerForLoopComputation() throws TornadoExecutionPlanException {
        int X = 128;
        int Y = 128;
        Matrix2DDouble matrixA = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixB = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixC = new Matrix2DDouble(X, Y);
        Matrix2DDouble matrixSerial = new Matrix2DDouble(X, Y);
        TaskGraph taskGraph = new TaskGraph("t0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("s0", TestLoopConditions::conditionInInnerForLoopComputation, (Object)matrixA, (Object)matrixB, (Object)matrixC).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoopConditions.conditionInInnerForLoopComputation(matrixA, matrixB, matrixSerial);
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Assert.assertEquals((double)matrixSerial.get(i, j), (double)matrixC.get(i, j), (double)0.01);
            }
        }
    }

    @Test
    public void testConditionAfterInnerForLoopComputation() throws TornadoExecutionPlanException {
        int X = 128;
        int Y = 128;
        Matrix2DDouble matrixA = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixB = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixC = new Matrix2DDouble(X, Y);
        Matrix2DDouble matrixSerial = new Matrix2DDouble(X, Y);
        TaskGraph taskGraph = new TaskGraph("t0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("s0", TestLoopConditions::conditionAfterInnerForLoopComputation, (Object)matrixA, (Object)matrixB, (Object)matrixC).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoopConditions.conditionAfterInnerForLoopComputation(matrixA, matrixB, matrixSerial);
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Assert.assertEquals((double)matrixSerial.get(i, j), (double)matrixC.get(i, j), (double)0.01);
            }
        }
    }

    @Test
    public void testConditionAfterOuterForLoopComputation() throws TornadoExecutionPlanException {
        int X = 128;
        int Y = 128;
        Matrix2DDouble matrixA = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixB = TestLoopConditions.matrix2DDoubleInit(X, Y);
        Matrix2DDouble matrixC = new Matrix2DDouble(X, Y);
        Matrix2DDouble matrixSerial = new Matrix2DDouble(X, Y);
        TaskGraph taskGraph = new TaskGraph("t0").transferToDevice(0, new Object[]{matrixA, matrixB}).task("s0", TestLoopConditions::conditionAfterOuterForLoopComputation, (Object)matrixA, (Object)matrixB, (Object)matrixC).transferToHost(1, new Object[]{matrixC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestLoopConditions.conditionAfterOuterForLoopComputation(matrixA, matrixB, matrixSerial);
        for (int i = 0; i < X; ++i) {
            for (int j = 0; j < Y; ++j) {
                Assert.assertEquals((double)matrixSerial.get(i, j), (double)matrixC.get(i, j), (double)0.01);
            }
        }
    }
}

