/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.branching;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestConditionals
extends TornadoTestBase {
    public static void ifStatement(IntArray a) {
        if (a.get(0) > 1) {
            a.set(0, 10);
        }
    }

    public static void ifElseStatement(IntArray a) {
        if (a.get(0) == 1) {
            a.set(0, 5);
        } else {
            a.set(0, 10);
        }
    }

    public static void nestedIfElseStatement(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            if (a.get(i) > 100) {
                if (a.get(i) > 200) {
                    a.set(i, 5);
                } else {
                    a.set(i, 10);
                }
                a.set(i, a.get(i) + 20);
                continue;
            }
            a.set(i, 2);
        }
    }

    public static void switchStatement(IntArray a) {
        int value = a.get(0);
        switch (value) {
            case 10: {
                a.set(0, 5);
                break;
            }
            case 20: {
                a.set(0, 10);
                break;
            }
            default: {
                a.set(0, 20);
            }
        }
    }

    public static void switchStatement2(IntArray a) {
        int value = a.get(0);
        switch (value) {
            case 10: {
                a.set(0, 5);
                break;
            }
            case 20: {
                a.set(0, 10);
            }
        }
    }

    public static void switchStatement3(IntArray a) {
        block4: for (int i = 0; i < a.getSize(); ++i) {
            int value = a.get(i);
            switch (value) {
                case 10: {
                    a.set(i, 5);
                    continue block4;
                }
                case 20: {
                    a.set(i, 10);
                }
            }
        }
    }

    public static void switchStatement4(IntArray a) {
        block4: for (int i = 0; i < a.getSize(); ++i) {
            int value = a.get(i);
            switch (value) {
                case 10: {
                    a.set(i, 5);
                    continue block4;
                }
                case 20: {
                    a.set(i, 10);
                }
            }
        }
    }

    public static void switchStatement5(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            int value = a.get(i);
            switch (value) {
                case 12: {
                    a.set(i, 5);
                    break;
                }
                case 22: {
                    a.set(i, 10);
                    break;
                }
                case 42: {
                    a.set(i, 30);
                }
            }
            a.set(i, a.get(i) * 2);
        }
    }

    public static void switchStatement6(IntArray a) {
        block4: for (int i = 0; i < a.getSize(); ++i) {
            int value = a.get(i);
            switch (value) {
                case 12: 
                case 22: {
                    a.set(i, 10);
                    continue block4;
                }
                case 42: {
                    a.set(i, 30);
                }
            }
        }
    }

    public static void ternaryCondition(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, a.get(i) == 20 ? 10 : 5);
        }
    }

    public static void ternaryComplexCondition(IntArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            for (int x = 0; x < a.getSize(); ++x) {
                if (i != a.getSize()) continue;
                a.set(x, a.get(x) == 20 ? a.get(x) + b.get(x) : 5);
            }
        }
    }

    public static void ternaryComplexCondition2(IntArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, a.get(i) == 20 ? a.get(i) + b.get(i) : 5);
        }
    }

    public static void integerTestMove(IntArray output, int dimensionSize) {
        for (int i = 0; i < dimensionSize; ++i) {
            for (int j = 0; j < dimensionSize; ++j) {
                if (i % 2 == 0 & j % 2 == 0) {
                    output.set(i + j * dimensionSize, 10);
                    continue;
                }
                output.set(i + j * dimensionSize, -1);
            }
        }
    }

    private static void testShortCircuit(KernelContext context, IntArray array) {
        int idx = context.globalIdx;
        int i = 1 - idx;
        int j = 1 + idx;
        boolean isInBounds = i < array.getSize() && j < array.getSize();
        array.set(idx, isInBounds ? 1 : 0);
    }

    @Test
    public void testIfStatement() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(5);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::ifStatement, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((long)10L, (long)a.get(0));
    }

    @Test
    public void testIfElseStatement() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(5);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::ifElseStatement, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((long)10L, (long)a.get(0));
    }

    @Test
    public void testNestedIfElseStatement() throws TornadoExecutionPlanException {
        int size = 128;
        IntArray a = new IntArray(128);
        IntArray serial = new IntArray(128);
        IntStream.range(0, 128).forEach(i -> {
            a.set(i, 50);
            serial.set(i, a.get(i));
        });
        TestConditionals.nestedIfElseStatement(serial);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::nestedIfElseStatement, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < 128; ++i2) {
            Assert.assertEquals((long)serial.get(i2), (long)a.get(i2));
        }
    }

    @Test
    public void testSwitch() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(20);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::switchStatement, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((long)10L, (long)a.get(0));
    }

    @Test
    public void testSwitchDefault() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(23);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::switchStatement, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((long)20L, (long)a.get(0));
    }

    @Test
    public void testSwitch2() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(20);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::switchStatement2, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((long)10L, (long)a.get(0));
    }

    @Test
    public void testSwitch3() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(20);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::switchStatement3, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Test
    public void testSwitch4() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(20);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::switchStatement4, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Test
    public void testSwitch5() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(12);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::switchStatement5, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Test
    public void testTernaryCondition() throws TornadoExecutionPlanException {
        int size = 10;
        IntArray a = new IntArray(10);
        a.init(20);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::ternaryCondition, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Test
    public void testComplexTernaryCondition() throws TornadoExecutionPlanException {
        int size = 8192;
        IntArray a = new IntArray(8192);
        IntArray b = new IntArray(8192);
        a.init(20);
        b.init(30);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::ternaryComplexCondition, (Object)a, (Object)b).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)20L, (long)a.get(i));
        }
    }

    @Test
    public void testComplexTernaryCondition2() throws TornadoExecutionPlanException {
        int size = 8192;
        IntArray a = new IntArray(8192);
        IntArray b = new IntArray(8192);
        a.init(20);
        b.init(30);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::ternaryComplexCondition2, (Object)a, (Object)b).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)50L, (long)a.get(i));
        }
    }

    @Test
    public void testSwitch6() throws TornadoExecutionPlanException {
        int size = 8192;
        IntArray a = new IntArray(8192);
        a.init(42);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::switchStatement6, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)30L, (long)a.get(i));
        }
    }

    @Test
    public void testSwitch7() throws TornadoExecutionPlanException {
        int size = 8192;
        IntArray a = new IntArray(8192);
        a.init(12);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::switchStatement6, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Test
    public void testSwitch8() throws TornadoExecutionPlanException {
        int size = 8192;
        IntArray a = new IntArray(8192);
        a.init(22);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestConditionals::switchStatement6, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)10L, (long)a.get(i));
        }
    }

    @Test
    public void testIntegerTestMove() throws TornadoExecutionPlanException {
        int size = 1024;
        IntArray output = new IntArray(0x100000);
        IntArray sequential = new IntArray(0x100000);
        IntStream.range(0, sequential.getSize()).sequential().forEach(i -> sequential.set(i, i));
        IntStream.range(0, output.getSize()).sequential().forEach(i -> output.set(i, i));
        TaskGraph taskGraph = new TaskGraph("s0");
        taskGraph.task("t0", TestConditionals::integerTestMove, (Object)output, (Object)1024).transferToHost(1, new Object[]{output});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestConditionals.integerTestMove(sequential, 1024);
        for (int i2 = 0; i2 < 0x100000; ++i2) {
            Assert.assertEquals((long)sequential.get(i2), (long)output.get(i2));
        }
    }

    @Test
    public void testConditionalShortCircuit() {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        IntArray testArr = new IntArray(8);
        WorkerGrid1D workerGrid = new WorkerGrid1D(8);
        GridScheduler gridScheduler = new GridScheduler("testConditionalShortCircuit.kernel", (WorkerGrid)workerGrid);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("testConditionalShortCircuit").transferToDevice(0, new Object[]{testArr}).task("kernel", TestConditionals::testShortCircuit, (Object)context, (Object)testArr).transferToHost(1, new Object[]{testArr});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        boolean caughtInternalException = false;
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        catch (TornadoInternalError e) {
            System.out.println(e.getMessage());
            caughtInternalException = true;
        }
        catch (TornadoExecutionPlanException e) {
            throw new RuntimeException(e);
        }
        Assert.assertFalse((boolean)caughtInternalException);
    }
}

