/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.bitsets;

import java.util.Random;
import org.apache.lucene.util.LongBitSet;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class BitSetTests
extends TornadoTestBase {
    public static void intersectionCount(int numWords, LongBitSet a, LongBitSet b, LongArray result) {
        long[] aBits = a.getBits();
        long[] bBits = b.getBits();
        for (int i = 0; i < numWords; ++i) {
            result.set(i, (long)Long.bitCount(aBits[i] & bBits[i]));
        }
    }

    @Test
    public void test01() throws TornadoExecutionPlanException {
        int numWords = 8192;
        Random rand = new Random(7L);
        long[] aBits = new long[8192];
        long[] bBits = new long[8192];
        LongBitSet a = new LongBitSet(aBits, 65536L);
        LongBitSet b = new LongBitSet(bBits, 65536L);
        LongArray result = new LongArray(8192);
        LongArray seq = new LongArray(8192);
        for (int i = 0; i < aBits.length; ++i) {
            aBits[i] = rand.nextLong();
            bBits[i] = rand.nextLong();
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", BitSetTests::intersectionCount, (Object)8192, (Object)a, (Object)b, (Object)result).transferToHost(1, new Object[]{result});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        BitSetTests.intersectionCount(8192, a, b, seq);
        for (int i = 0; i < 8192; ++i) {
            Assert.assertEquals((float)seq.get(i), (float)result.get(i), (float)0.1f);
        }
    }
}

