/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.batches;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.exceptions.TornadoBailoutRuntimeException;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;
import uk.ac.manchester.tornado.unittests.tools.Exceptions.UnsupportedConfigurationException;

public class TestBatches
extends TornadoTestBase {
    @Override
    public void before() {
        super.before();
        System.setProperty("tornado.reuse.device.buffers", "False");
    }

    public static void compute(FloatArray array) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, array.get(i));
        }
    }

    public static void compute(FloatArray arrayA, FloatArray arrayB) {
        for (int i = 0; i < arrayA.getSize(); ++i) {
            arrayB.set(i, arrayA.get(i) + 100.0f);
        }
    }

    public static void compute(FloatArray arrayA, FloatArray arrayB, FloatArray arrayC) {
        for (int i = 0; i < arrayA.getSize(); ++i) {
            arrayC.set(i, arrayA.get(i) + arrayB.get(i));
        }
    }

    public static void compute(IntArray arrayA, IntArray arrayB, IntArray arrayC) {
        for (int i = 0; i < arrayA.getSize(); ++i) {
            arrayC.set(i, arrayA.get(i) + arrayB.get(i));
        }
    }

    public static void compute(LongArray arrayA, LongArray arrayB, LongArray arrayC) {
        for (int i = 0; i < arrayA.getSize(); ++i) {
            arrayC.set(i, arrayA.get(i) + arrayB.get(i));
        }
    }

    public static void compute(DoubleArray arrayA, DoubleArray arrayB, DoubleArray arrayC) {
        for (int i = 0; i < arrayA.getSize(); ++i) {
            arrayC.set(i, arrayA.get(i) + arrayB.get(i));
        }
    }

    public static void compute(ShortArray arrayA, ShortArray arrayB, ShortArray arrayC) {
        for (int i = 0; i < arrayA.getSize(); ++i) {
            arrayC.set(i, (short)(arrayA.get(i) + arrayB.get(i)));
        }
    }

    static void compute(IntArray in, IntArray out) {
        for (int i = 0; i < in.getSize(); ++i) {
            out.set(i, in.get(i));
        }
    }

    static void compute(IntArray in, LongArray out) {
        for (int i = 0; i < out.getSize(); ++i) {
            out.set(i, (long)in.get(i));
        }
    }

    static void compute(int[] in, int[] out) {
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
    }

    static void compute(int[] in, long[] out) {
        for (int i = 0; i < out.length; ++i) {
            out[i] = in[i];
        }
    }

    static void compute(int[] in, IntArray out) {
        for (int i = 0; i < in.length; ++i) {
            out.set(i, in[i]);
        }
    }

    static void compute(IntArray in, int[] out) {
        for (int i = 0; i < in.getSize(); ++i) {
            out[i] = in.get(i);
        }
    }

    static void compute(int[] in, float[] out) {
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
    }

    static void compute(IntArray in, FloatArray out) {
        for (int i = 0; i < in.getSize(); ++i) {
            out.set(i, (float)in.get(i));
        }
    }

    static void compute(int[] in, FloatArray out) {
        for (int i = 0; i < in.length; ++i) {
            out.set(i, (float)in[i]);
        }
    }

    static void compute(IntArray in, float[] out) {
        for (int i = 0; i < in.getSize(); ++i) {
            out[i] = in.get(i);
        }
    }

    public static void compute(FloatArray data, float beta) {
        for (int i = 0; i < data.getSize(); ++i) {
            data.set(i, (float)(i * 20) + beta);
        }
    }

    @Test
    public void test100MBSmall() throws TornadoExecutionPlanException {
        int size = 30000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(100, MemoryUnit.MB);
        if ((long)(size * 4) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 4L / 2L) * 0.9);
        }
        FloatArray arrayA = new FloatArray(size);
        FloatArray arrayB = new FloatArray(size);
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> arrayA.set(idx, 0.0f));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA}).task("t0", TestBatches::compute, (Object)arrayA, (Object)arrayB).transferToHost(1, new Object[]{arrayB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("60MB").execute();
        }
        for (int i = 0; i < arrayB.getSize(); ++i) {
            Assert.assertEquals((float)(arrayA.get(i) + 100.0f), (float)arrayB.get(i), (float)0.1f);
        }
    }

    @Test
    public void test100MBSmallLazy() throws TornadoExecutionPlanException {
        int size = 30000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(100, MemoryUnit.MB);
        if ((long)(size * 4) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 4L / 2L) * 0.9);
        }
        FloatArray arrayA = new FloatArray(size);
        FloatArray arrayB = new FloatArray(size);
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> arrayA.set(idx, 0.0f));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA}).task("t0", TestBatches::compute, (Object)arrayA, (Object)arrayB).transferToHost(2, new Object[]{arrayB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult tornadoExecutionResult = executionPlan.withBatch("60MB").execute();
            tornadoExecutionResult.transferToHost(new Object[]{arrayB});
        }
        for (int i = 0; i < arrayB.getSize(); ++i) {
            Assert.assertEquals((float)(arrayA.get(i) + 100.0f), (float)arrayB.get(i), (float)0.1f);
        }
    }

    @Test
    public void test100MB() throws TornadoExecutionPlanException {
        int size = 200000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(100, MemoryUnit.MB);
        if ((long)(size * 4) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 4L / 2L) * 0.9);
        }
        FloatArray arrayA = new FloatArray(size);
        FloatArray arrayB = new FloatArray(size);
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> arrayA.set(idx, 0.0f));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA}).task("t0", TestBatches::compute, (Object)arrayA, (Object)arrayB).transferToHost(1, new Object[]{arrayB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("100MB").execute();
        }
        for (int i = 0; i < arrayB.getSize(); ++i) {
            Assert.assertEquals((float)(arrayA.get(i) + 100.0f), (float)arrayB.get(i), (float)0.1f);
        }
    }

    @Test
    public void test100MBLazy() throws TornadoExecutionPlanException {
        int size = 200000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(100, MemoryUnit.MB);
        if ((long)(size * 4) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 4L / 2L) * 0.9);
        }
        FloatArray arrayA = new FloatArray(size);
        FloatArray arrayB = new FloatArray(size);
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> arrayA.set(idx, 0.0f));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA}).task("t0", TestBatches::compute, (Object)arrayA, (Object)arrayB).transferToHost(2, new Object[]{arrayB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult tornadoExecutionResult = executionPlan.withBatch("100MB").execute();
            tornadoExecutionResult.transferToHost(new Object[]{arrayB});
        }
        for (int i = 0; i < arrayB.getSize(); ++i) {
            Assert.assertEquals((float)(arrayA.get(i) + 100.0f), (float)arrayB.get(i), (float)0.1f);
        }
    }

    @Test
    public void test300MB() throws TornadoExecutionPlanException {
        int size = 250000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(300, MemoryUnit.MB);
        if ((long)(size * 4) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 4L / 2L) * 0.9);
        }
        FloatArray arrayA = new FloatArray(size);
        FloatArray arrayB = new FloatArray(size);
        Random r = new Random();
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> arrayA.set(idx, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA}).task("t0", TestBatches::compute, (Object)arrayA, (Object)arrayB).transferToHost(1, new Object[]{arrayB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("300MB").execute();
        }
        for (int i = 0; i < arrayB.getSize(); ++i) {
            Assert.assertEquals((float)(arrayA.get(i) + 100.0f), (float)arrayB.get(i), (float)1.0f);
        }
    }

    @Test
    public void test300MBLazy() throws TornadoExecutionPlanException {
        int size = 250000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(300, MemoryUnit.MB);
        if ((long)(size * 4) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 4L / 2L) * 0.9);
        }
        FloatArray arrayA = new FloatArray(size);
        FloatArray arrayB = new FloatArray(size);
        Random r = new Random();
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> arrayA.set(idx, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA}).task("t0", TestBatches::compute, (Object)arrayA, (Object)arrayB).transferToHost(2, new Object[]{arrayB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult tornadoExecutionResult = executionPlan.withBatch("300MB").execute();
            tornadoExecutionResult.transferToHost(new Object[]{arrayB});
        }
        for (int i = 0; i < arrayB.getSize(); ++i) {
            Assert.assertEquals((float)(arrayA.get(i) + 100.0f), (float)arrayB.get(i), (float)1.0f);
        }
    }

    @Test
    public void test512MB() throws TornadoExecutionPlanException {
        int size = 200000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(512, MemoryUnit.MB);
        if ((long)(size * 4) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 4L) * 0.9);
        }
        FloatArray arrayA = new FloatArray(size);
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> arrayA.set(idx, (float)idx));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA}).task("t0", TestBatches::compute, (Object)arrayA).transferToHost(1, new Object[]{arrayA});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("512MB").execute();
        }
        for (int i = 0; i < arrayA.getSize(); ++i) {
            Assert.assertEquals((float)i, (float)arrayA.get(i), (float)0.1f);
        }
    }

    @Test
    public void test512MBLazy() throws TornadoExecutionPlanException {
        int size = 200000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(512, MemoryUnit.MB);
        if ((long)(size * 4) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 4L) * 0.9);
        }
        FloatArray arrayA = new FloatArray(size);
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> arrayA.set(idx, (float)idx));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA}).task("t0", TestBatches::compute, (Object)arrayA).transferToHost(2, new Object[]{arrayA});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult tornadoExecutionResult = executionPlan.withBatch("512MB").execute();
            tornadoExecutionResult.transferToHost(new Object[]{arrayA});
        }
        for (int i = 0; i < arrayA.getSize(); ++i) {
            Assert.assertEquals((float)i, (float)arrayA.get(i), (float)0.1f);
        }
    }

    @Test
    public void test50MB() throws TornadoExecutionPlanException {
        int size = 20000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(50, MemoryUnit.MB);
        if ((long)(size * 4) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 4L / 3L) * 0.9);
        }
        FloatArray arrayA = new FloatArray(size);
        FloatArray arrayB = new FloatArray(size);
        FloatArray arrayC = new FloatArray(size);
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> {
            arrayA.set(idx, (float)idx);
            arrayB.set(idx, (float)idx);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA, arrayB}).task("t0", TestBatches::compute, (Object)arrayA, (Object)arrayB, (Object)arrayC).transferToHost(1, new Object[]{arrayC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("50MB").execute();
        }
        for (int i = 0; i < arrayA.getSize(); ++i) {
            Assert.assertEquals((float)(arrayA.get(i) + arrayB.get(i)), (float)arrayC.get(i), (float)0.1f);
        }
    }

    @Test
    public void test50MBInteger() throws TornadoExecutionPlanException {
        int size = 20000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(50, MemoryUnit.MB);
        if ((long)(size * 4) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 4L / 3L) * 0.9);
        }
        IntArray arrayA = new IntArray(size);
        IntArray arrayB = new IntArray(size);
        IntArray arrayC = new IntArray(size);
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> {
            arrayA.set(idx, idx);
            arrayB.set(idx, idx);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA, arrayB}).task("t0", TestBatches::compute, (Object)arrayA, (Object)arrayB, (Object)arrayC).transferToHost(1, new Object[]{arrayC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("50MB").execute();
        }
        for (int i = 0; i < arrayA.getSize(); ++i) {
            Assert.assertEquals((long)(arrayA.get(i) + arrayB.get(i)), (long)arrayC.get(i));
        }
    }

    @Test
    public void test50MBShort() throws TornadoExecutionPlanException {
        int size = 80000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(50, MemoryUnit.MB);
        if ((long)(size * 2) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 2L / 3L) * 0.9);
        }
        ShortArray arrayA = new ShortArray(size);
        ShortArray arrayB = new ShortArray(size);
        ShortArray arrayC = new ShortArray(size);
        Random r = new Random();
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> {
            arrayA.set(idx, (short)r.nextInt(16383));
            arrayB.set(idx, (short)r.nextInt(16383));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA, arrayB}).task("t0", TestBatches::compute, (Object)arrayA, (Object)arrayB, (Object)arrayC).transferToHost(1, new Object[]{arrayC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("50MB").execute();
        }
        for (int i = 0; i < arrayA.getSize(); ++i) {
            Assert.assertEquals((long)(arrayA.get(i) + arrayB.get(i)), (long)arrayC.get(i));
        }
    }

    @Test
    public void test50MBDouble() throws TornadoExecutionPlanException {
        int size = 20000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(50, MemoryUnit.MB);
        if ((long)(size * 8) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 8L / 3L) * 0.9);
        }
        DoubleArray arrayA = new DoubleArray(size);
        DoubleArray arrayB = new DoubleArray(size);
        DoubleArray arrayC = new DoubleArray(size);
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> {
            arrayA.set(idx, (double)idx);
            arrayB.set(idx, (double)idx);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA, arrayB}).task("t0", TestBatches::compute, (Object)arrayA, (Object)arrayB, (Object)arrayC).transferToHost(1, new Object[]{arrayC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("50MB").execute();
        }
        for (int i = 0; i < arrayA.getSize(); ++i) {
            Assert.assertEquals((double)(arrayA.get(i) + arrayB.get(i)), (double)arrayC.get(i), (double)0.01);
        }
    }

    @Test
    public void test50MBLong() throws TornadoExecutionPlanException {
        int size = 20000000;
        long maxAllocMemory = this.checkMaxHeapAllocationOnDevice(50, MemoryUnit.MB);
        if ((long)(size * 8) > maxAllocMemory) {
            size = (int)((double)(maxAllocMemory / 8L / 3L) * 0.9);
        }
        LongArray arrayA = new LongArray(size);
        LongArray arrayB = new LongArray(size);
        LongArray arrayC = new LongArray(size);
        IntStream.range(0, arrayA.getSize()).sequential().forEach(idx -> {
            arrayA.set(idx, (long)idx);
            arrayB.set(idx, (long)idx);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA, arrayB}).task("t0", TestBatches::compute, (Object)arrayA, (Object)arrayB, (Object)arrayC).transferToHost(1, new Object[]{arrayC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("50MB").execute();
        }
        for (int i = 0; i < arrayA.getSize(); ++i) {
            Assert.assertEquals((long)(arrayA.get(i) + arrayB.get(i)), (long)arrayC.get(i));
        }
    }

    @Test
    public void testSameInputSizeAndTypeRestriction() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(5, MemoryUnit.MB);
        IntArray a0 = new IntArray(2000000);
        IntArray a1 = new IntArray(3000000);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a0}).task("t0", TestBatches::compute, (Object)a0, (Object)a1).transferToHost(1, new Object[]{a1});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            Assert.assertThrows(TornadoBailoutRuntimeException.class, () -> executionPlan.withBatch("1MB").execute());
        }
    }

    @Test
    public void testSameInputSizeAndTypeRestrictionJavaArrays() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(5, MemoryUnit.MB);
        int[] a0 = new int[2000000];
        int[] a1 = new int[3000000];
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a0}).task("t0", TestBatches::compute, (Object)a0, (Object)a1).transferToHost(1, new Object[]{a1});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            Assert.assertThrows(TornadoBailoutRuntimeException.class, () -> executionPlan.withBatch("1MB").execute());
        }
    }

    @Test
    public void testSameInputTypeRestriction() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(6, MemoryUnit.MB);
        IntArray a0 = new IntArray(4000000);
        LongArray a1 = new LongArray(2000000);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a0}).task("t0", TestBatches::compute, (Object)a0, (Object)a1).transferToHost(1, new Object[]{a1});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            Assert.assertThrows(TornadoBailoutRuntimeException.class, () -> executionPlan.withBatch("1MB").execute());
        }
    }

    @Test
    public void testSameInputTypeRestrictionJavaArrays() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(6, MemoryUnit.MB);
        int[] a0 = new int[4000000];
        long[] a1 = new long[2000000];
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a0}).task("t0", TestBatches::compute, (Object)a0, (Object)a1).transferToHost(1, new Object[]{a1});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            Assert.assertThrows(TornadoBailoutRuntimeException.class, () -> executionPlan.withBatch("1MB").execute());
        }
    }

    @Test
    public void testSameInputSize() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(4, MemoryUnit.MB);
        IntArray a0 = new IntArray(2000000);
        IntStream.range(0, a0.getSize()).forEach(i -> a0.set(i, i));
        FloatArray a1 = new FloatArray(2000000);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a0}).task("t0", TestBatches::compute, (Object)a0, (Object)a1).transferToHost(1, new Object[]{a1});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("1MB").execute();
        }
        for (int i2 = 0; i2 < a1.getSize(); ++i2) {
            Assert.assertEquals((double)a0.get(i2), (double)a1.get(i2), (double)1.0E-20);
        }
    }

    @Test
    public void testSameInputSizeJavaArrays() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(4, MemoryUnit.MB);
        int[] a0 = new int[2000000];
        IntStream.range(0, a0.length).forEach(i -> {
            a0[i] = i;
        });
        float[] a1 = new float[2000000];
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a0}).task("t0", TestBatches::compute, (Object)a0, (Object)a1).transferToHost(1, new Object[]{a1});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("1MB").execute();
        }
        for (int i2 = 0; i2 < a1.length; ++i2) {
            Assert.assertEquals((double)a0[i2], (double)a1[i2], (double)1.0E-20);
        }
    }

    @Test
    public void testSameInputSizeJavaToTornado() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(4, MemoryUnit.MB);
        int[] a0 = new int[2000000];
        IntStream.range(0, a0.length).forEach(i -> {
            a0[i] = i;
        });
        FloatArray a1 = new FloatArray(2000000);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a0}).task("t0", TestBatches::compute, (Object)a0, (Object)a1).transferToHost(1, new Object[]{a1});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("1MB").execute();
        }
        for (int i2 = 0; i2 < a1.getSize(); ++i2) {
            Assert.assertEquals((double)a0[i2], (double)a1.get(i2), (double)1.0E-20);
        }
    }

    @Test
    public void testSameInputSizeTornadoToJava() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(4, MemoryUnit.MB);
        IntArray a0 = new IntArray(2000000);
        IntStream.range(0, a0.getSize()).forEach(i -> a0.set(i, i));
        float[] a1 = new float[2000000];
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a0}).task("t0", TestBatches::compute, (Object)a0, (Object)a1).transferToHost(1, new Object[]{a1});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("1MB").execute();
        }
        for (int i2 = 0; i2 < a1.length; ++i2) {
            Assert.assertEquals((double)a0.get(i2), (double)a1[i2], (double)1.0E-20);
        }
    }

    @Test
    public void testSameInputSizeAndTypeJavaToTornado() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(4, MemoryUnit.MB);
        int[] a0 = new int[2000000];
        IntStream.range(0, a0.length).forEach(i -> {
            a0[i] = i;
        });
        IntArray a1 = new IntArray(2000000);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a0}).task("t0", TestBatches::compute, (Object)a0, (Object)a1).transferToHost(1, new Object[]{a1});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("1MB").execute();
        }
        for (int i2 = 0; i2 < a1.getSize(); ++i2) {
            Assert.assertEquals((long)a0[i2], (long)a1.get(i2));
        }
    }

    @Test
    public void testSameInputSizeAndTypeTornadoToJava() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(4, MemoryUnit.MB);
        IntArray a0 = new IntArray(2000000);
        IntStream.range(0, a0.getSize()).forEach(i -> a0.set(i, i));
        int[] a1 = new int[2000000];
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a0}).task("t0", TestBatches::compute, (Object)a0, (Object)a1).transferToHost(1, new Object[]{a1});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withBatch("1MB").execute();
        }
        for (int i2 = 0; i2 < a1.length; ++i2) {
            Assert.assertEquals((long)a0.get(i2), (long)a1[i2]);
        }
    }

    public static void parallelInitialization(FloatArray data) {
        for (int i = 0; i < data.getSize(); ++i) {
            data.set(i, (float)i);
        }
    }

    public static void compute2(FloatArray data) {
        for (int i = 0; i < data.getSize(); ++i) {
            float value = data.get(i);
            data.set(i, value * 2.0f);
        }
    }

    @Test
    public void testBatchNotEven() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(64, MemoryUnit.MB);
        FloatArray array = new FloatArray(0x1000000);
        FloatArray arraySeq = new FloatArray(0x1000000);
        for (int i = 0; i < arraySeq.getSize(); ++i) {
            arraySeq.set(i, (float)i);
        }
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestBatches::parallelInitialization, (Object)array).task("t1", TestBatches::compute2, (Object)array).transferToHost(1, new Object[]{array});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withBatch("10MB").execute();
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((float)(arraySeq.get(i) * 2.0f), (float)array.get(i), (float)0.01f);
        }
    }

    @Test
    public void testBatchNotEven2() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(64, MemoryUnit.MB);
        FloatArray array = new FloatArray(0x1000000);
        FloatArray array2 = new FloatArray(0x1000000);
        array.init(1.0f);
        array2.init(1.0f);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{array}).task("t1", TestBatches::compute2, (Object)array).task("t2", TestBatches::compute2, (Object)array).transferToHost(1, new Object[]{array});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withBatch("10MB").execute();
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((float)(array2.get(i) * 4.0f), (float)array.get(i), (float)0.01f);
        }
    }

    @Test
    public void testBatchNotEven2Lazy() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(64, MemoryUnit.MB);
        FloatArray array = new FloatArray(0x1000000);
        FloatArray array2 = new FloatArray(0x1000000);
        array.init(1.0f);
        array2.init(1.0f);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{array}).task("t1", TestBatches::compute2, (Object)array).task("t2", TestBatches::compute2, (Object)array).transferToHost(1, new Object[]{array});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            TornadoExecutionResult tornadoExecutionResult = executionPlan.withBatch("10MB").execute();
            tornadoExecutionResult.transferToHost(new Object[]{array});
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((float)(array2.get(i) * 4.0f), (float)array.get(i), (float)0.01f);
        }
    }

    @Test
    public void testBatchThreadIndex() throws TornadoExecutionPlanException {
        this.checkMaxHeapAllocationOnDevice(64, MemoryUnit.MB);
        FloatArray array = new FloatArray(0x1000000);
        FloatArray arraySeq = new FloatArray(0x1000000);
        float beta = 2.0f;
        for (int i = 0; i < arraySeq.getSize(); ++i) {
            arraySeq.set(i, (float)(i * 20) + beta);
        }
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestBatches::compute, (Object)array, (Object)Float.valueOf(beta)).transferToHost(1, new Object[]{array});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withBatch("10MB").execute();
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((float)arraySeq.get(i), (float)array.get(i), (float)0.01f);
        }
    }

    private long checkMaxHeapAllocationOnDevice(int size, MemoryUnit memoryUnit) throws UnsupportedConfigurationException {
        long memThreshold;
        long maxAllocMemory = TestBatches.getTornadoRuntime().getDefaultDevice().getDeviceContext().getMemoryManager().getHeapSize();
        switch (memoryUnit.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 1: {
                long l = (long)size * 1024L * 1024L * 1024L;
                break;
            }
            case 0: {
                long l = (long)size * 1024L * 1024L;
                break;
            }
            case 2: {
                long l = memThreshold = (long)size * 1024L * 1024L * 1024L * 1024L;
            }
        }
        if (maxAllocMemory < memThreshold) {
            throw new UnsupportedConfigurationException("Not enough memory to run the test");
        }
        return maxAllocMemory;
    }

    private static enum MemoryUnit {
        MB,
        GB,
        TB;

    }
}

