/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.atomics;

import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.AccessorParameters;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestAtomics
extends TornadoTestBase {
    public static void atomic04(IntArray input) {
        AtomicInteger tai = new AtomicInteger(200);
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, tai.incrementAndGet());
        }
    }

    public static void atomic04Get(IntArray input) {
        AtomicInteger tai = new AtomicInteger(200);
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, tai.incrementAndGet());
            int a = tai.get();
            if (a != 201) continue;
            input.set(i, 0);
        }
    }

    public static void atomic06(IntArray a, IntArray b) {
        AtomicInteger taiA = new AtomicInteger(200);
        AtomicInteger taiB = new AtomicInteger(100);
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, taiA.incrementAndGet());
            b.set(i, taiB.incrementAndGet());
        }
    }

    public static void atomic07(IntArray input) {
        AtomicInteger ai = new AtomicInteger(200);
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, ai.incrementAndGet());
        }
    }

    public static void atomic08(IntArray input) {
        AtomicInteger ai = new AtomicInteger(200);
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, ai.decrementAndGet());
        }
    }

    public static int callAtomic(IntArray input, int i, AtomicInteger ai) {
        return input.get(i) + ai.incrementAndGet();
    }

    public static void atomic09(IntArray input, AtomicInteger ai) {
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, TestAtomics.callAtomic(input, i, ai));
        }
    }

    public static void atomic10(IntArray input, AtomicInteger ai, AtomicInteger bi) {
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, input.get(i) + ai.incrementAndGet() + bi.incrementAndGet());
        }
    }

    public static void atomic13DecrementAndGet(IntArray input, AtomicInteger ai) {
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, input.get(i) + ai.decrementAndGet());
        }
    }

    public static void atomic13GetAndDecrement(IntArray input, AtomicInteger ai) {
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, input.get(i) + ai.getAndDecrement());
        }
    }

    public static void atomic14(IntArray input, AtomicInteger ai, AtomicInteger bi) {
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, input.get(i) + ai.incrementAndGet());
            input.set(i, input.get(i) + bi.decrementAndGet());
        }
    }

    public static void atomic15(IntArray input, AtomicInteger ai) {
        AtomicInteger bi = new AtomicInteger(500);
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, input.get(i) + ai.incrementAndGet());
            input.set(i, input.get(i) + bi.incrementAndGet());
        }
    }

    public static void atomic16(IntArray input, AtomicInteger ai) {
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, input.get(i) + ai.incrementAndGet());
        }
    }

    public static void atomic17GetAndIncrement(IntArray input, AtomicInteger ai) {
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, ai.getAndIncrement());
        }
    }

    public static void atomic17GetAndIncrement(KernelContext context, IntArray input, AtomicInteger ai) {
        int i = context.globalIdx;
        if (i < input.getSize()) {
            input.set(i, ai.getAndIncrement());
        }
    }

    public static void atomic17IncrementAndGet(IntArray input, AtomicInteger ai) {
        for (int i = 0; i < input.getSize(); ++i) {
            input.set(i, ai.incrementAndGet());
        }
    }

    public static void atomic17IncrementAndGet(KernelContext context, IntArray input, AtomicInteger ai) {
        int i = context.globalIdx;
        if (i < input.getSize()) {
            input.set(i, ai.incrementAndGet());
        }
    }

    public static void atomic18(KernelContext context, IntArray data) {
        for (int i = 0; i < data.getSize(); ++i) {
            context.atomicAdd(data, i, 1);
        }
    }

    public static void atomic18(KernelContext context, int[] data, int[] incrementingValues) {
        for (int i = 0; i < data.length; ++i) {
            context.atomicAdd(data, i, incrementingValues[i]);
        }
    }

    public static void atomic18(KernelContext context, LongArray data) {
        for (int i = 0; i < data.getSize(); ++i) {
            context.atomicAdd(data, i, 1L);
        }
    }

    public static void atomic18(KernelContext context, FloatArray data) {
        for (int i = 0; i < data.getSize(); ++i) {
            context.atomicAdd(data, i, 1.0f);
        }
    }

    public static void atomic18(KernelContext context, DoubleArray data) {
        for (int i = 0; i < data.getSize(); ++i) {
            context.atomicAdd(data, i, 1.0);
        }
    }

    public static void atomic18Kernel(KernelContext context, IntArray input) {
        int tid = context.globalIdx;
        if (tid < input.getSize()) {
            context.atomicAdd(input, tid, 1);
        }
    }

    public static void atomic19(KernelContext context, IntArray input, IntArray output) {
        for (int tid = 0; tid < input.getSize(); ++tid) {
            int index = input.get(tid);
            context.atomicAdd(output, index, 1);
        }
    }

    public static void atomic19Kernel(KernelContext context, IntArray input, IntArray output) {
        int tid = context.globalIdx;
        if (tid < input.getSize()) {
            int index = input.get(tid);
            context.atomicAdd(output, index, 1);
        }
    }

    @Test
    public void testAtomic04() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray a = new IntArray(32);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestAtomics::atomic04, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            if (!executionResult.isReady()) {
                Assert.fail();
            }
        }
        boolean repeated = this.isValueRepeated(a);
        Assert.assertFalse((boolean)repeated);
    }

    @Test
    public void testAtomic04Get() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray a = new IntArray(32);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestAtomics::atomic04Get, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            if (!executionResult.isReady()) {
                Assert.fail();
            }
        }
        boolean repeated = this.isValueRepeated(a);
        Assert.assertFalse((boolean)repeated);
    }

    @Test
    public void testAtomic05_precompiled() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray a = new IntArray(32);
        IntArray b = new IntArray(1);
        a.init(0);
        String deviceToRun = System.getProperties().getProperty("device", "0");
        int deviceNumber = Integer.parseInt(deviceToRun);
        TornadoDevice defaultDevice = TornadoRuntimeProvider.getTornadoRuntime().getBackend(0).getDevice(deviceNumber);
        String tornadoSDK = System.getenv("TORNADOVM_HOME");
        boolean coops = TornadoNativeArray.ARRAY_HEADER == 16L;
        String basePath = tornadoSDK + "/examples/generated/";
        String fileStem = coops ? "atomics" : "atomics_uncompressed";
        String kernelPath = basePath + fileStem + ".cl";
        AccessorParameters accessorParameters = new AccessorParameters(2);
        accessorParameters.set(0, (Object)a, Access.WRITE_ONLY);
        accessorParameters.set(1, (Object)b, Access.WRITE_ONLY);
        TaskGraph taskGraph = new TaskGraph("s0").prebuiltTask("t0", "add", kernelPath, accessorParameters, new int[]{155}).transferToHost(1, new Object[]{a});
        WorkerGrid1D workerGrid = new WorkerGrid1D(32);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)workerGrid);
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withGridScheduler(gridScheduler).withDevice(defaultDevice).execute();
        }
        boolean repeated = this.isValueRepeated(a);
        Assert.assertFalse((boolean)repeated);
    }

    @Test
    public void testAtomic06() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 2048;
        IntArray a = new IntArray(2048);
        IntArray b = new IntArray(2048);
        a.init(1);
        b.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestAtomics::atomic06, (Object)a, (Object)b).transferToHost(1, new Object[]{a, b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            if (!executionResult.isReady()) {
                Assert.fail();
            }
        }
        boolean repeated = this.isValueRepeated(a);
        Assert.assertFalse((boolean)(repeated &= this.isValueRepeated(a)));
    }

    @Test
    public void testAtomic07() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray a = new IntArray(32);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestAtomics::atomic07, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            if (!executionResult.isReady()) {
                Assert.fail();
            }
        }
        boolean repeated = this.isValueRepeated(a);
        Assert.assertFalse((boolean)repeated);
    }

    @Test
    public void testAtomic08_decrementAndGet() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray a = new IntArray(32);
        a.init(1);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestAtomics::atomic08, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            if (!executionResult.isReady()) {
                Assert.fail();
            }
        }
        boolean repeated = this.isValueRepeated(a);
        Assert.assertFalse((boolean)repeated);
    }

    private boolean isValueRepeated(IntArray array) {
        HashSet<Integer> set = new HashSet<Integer>();
        boolean repeated = false;
        for (int i = 0; i < array.getSize(); ++i) {
            if (set.contains(array.get(i))) {
                repeated = true;
                break;
            }
            set.add(array.get(i));
        }
        return repeated;
    }

    @Test
    public void testAtomic09() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray a = new IntArray(32);
        a.init(1);
        int initialValue = 311;
        AtomicInteger ai = new AtomicInteger(311);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, ai}).task("t0", TestAtomics::atomic09, (Object)a, (Object)ai).transferToHost(1, new Object[]{a, ai});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        boolean repeated = this.isValueRepeated(a);
        int lastValue = ai.get();
        Assert.assertFalse((boolean)repeated);
        Assert.assertEquals((long)343L, (long)lastValue);
    }

    @Test
    public void testAtomic10() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray a = new IntArray(32);
        a.init(1);
        int initialValue = 311;
        AtomicInteger ai = new AtomicInteger(311);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestAtomics::atomic09, (Object)a, (Object)ai).transferToHost(1, new Object[]{a, ai});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        boolean repeated = this.isValueRepeated(a);
        int lastValue = ai.get();
        Assert.assertFalse((boolean)repeated);
        Assert.assertEquals((long)343L, (long)lastValue);
    }

    @Test
    public void testAtomic11() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray a = new IntArray(32);
        a.init(1);
        int initialValue = 311;
        AtomicInteger ai = new AtomicInteger(311);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestAtomics::atomic09, (Object)a, (Object)ai).transferToHost(1, new Object[]{ai, a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        boolean repeated = this.isValueRepeated(a);
        int lastValue = ai.get();
        Assert.assertFalse((boolean)repeated);
        Assert.assertEquals((long)343L, (long)lastValue);
    }

    @Test
    public void testAtomic12() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray a = new IntArray(32);
        a.init(1);
        int initialValueA = 311;
        int initialValueB = 500;
        AtomicInteger ai = new AtomicInteger(311);
        AtomicInteger bi = new AtomicInteger(500);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestAtomics::atomic10, (Object)a, (Object)ai, (Object)bi).transferToHost(1, new Object[]{ai, a, bi});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        boolean repeated = this.isValueRepeated(a);
        int lastValue = ai.get();
        Assert.assertFalse((boolean)repeated);
        Assert.assertEquals((long)343L, (long)lastValue);
        lastValue = bi.get();
        Assert.assertEquals((long)532L, (long)lastValue);
    }

    @Test
    public void testAtomic13_decrementAndGet() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        Random random = new Random();
        int size = 32;
        IntArray a = new IntArray(32);
        IntArray dataSequential = new IntArray(32);
        for (int i = 0; i < 32; ++i) {
            int intRandomValue = random.nextInt();
            a.set(i, intRandomValue);
            dataSequential.set(i, intRandomValue);
        }
        int initialValueA = 311;
        AtomicInteger ai = new AtomicInteger(311);
        AtomicInteger jai = new AtomicInteger(311);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestAtomics::atomic13DecrementAndGet, (Object)a, (Object)ai).transferToHost(1, new Object[]{ai, a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestAtomics.atomic13DecrementAndGet(dataSequential, jai);
        boolean repeated = this.isValueRepeated(a);
        int lastValue = ai.get();
        Assert.assertFalse((boolean)repeated);
        Assert.assertEquals((long)279L, (long)lastValue);
        Assert.assertArrayEquals((int[])dataSequential.toHeapArray(), (int[])a.toHeapArray());
    }

    @Test
    public void testAtomic13_getAndDecrement() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        Random random = new Random();
        int size = 32;
        IntArray a = new IntArray(32);
        IntArray dataSequential = new IntArray(32);
        for (int i = 0; i < 32; ++i) {
            int intRandomValue = random.nextInt();
            a.set(i, intRandomValue);
            dataSequential.set(i, intRandomValue);
        }
        int initialValueA = 311;
        AtomicInteger ai = new AtomicInteger(311);
        AtomicInteger jai = new AtomicInteger(311);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestAtomics::atomic13GetAndDecrement, (Object)a, (Object)ai).transferToHost(1, new Object[]{ai, a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestAtomics.atomic13GetAndDecrement(dataSequential, jai);
        boolean repeated = this.isValueRepeated(a);
        int lastValue = ai.get();
        Assert.assertFalse((boolean)repeated);
        Assert.assertEquals((long)279L, (long)lastValue);
        Assert.assertArrayEquals((int[])dataSequential.toHeapArray(), (int[])a.toHeapArray());
    }

    @Test
    public void testAtomic14() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray a = new IntArray(32);
        a.init(1);
        int initialValueA = 311;
        int initialValueB = 50;
        AtomicInteger ai = new AtomicInteger(311);
        AtomicInteger bi = new AtomicInteger(50);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestAtomics::atomic14, (Object)a, (Object)ai, (Object)bi).transferToHost(1, new Object[]{ai, a, bi});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        int lastValue = ai.get();
        Assert.assertEquals((long)343L, (long)lastValue);
        lastValue = bi.get();
        Assert.assertEquals((long)18L, (long)lastValue);
    }

    @Test
    public void testAtomic15() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray a = new IntArray(32);
        a.init(1);
        int initialValueA = 311;
        AtomicInteger ai = new AtomicInteger(311);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", TestAtomics::atomic15, (Object)a, (Object)ai).transferToHost(1, new Object[]{ai, a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        int lastValue = ai.get();
        Assert.assertEquals((long)343L, (long)lastValue);
        boolean repeated = this.isValueRepeated(a);
        Assert.assertFalse((boolean)repeated);
    }

    @Test
    public void testAtomic16() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray a = new IntArray(32);
        a.init(1);
        int initialValueA = 311;
        AtomicInteger ai = new AtomicInteger(311);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, ai}).task("t0", TestAtomics::atomic16, (Object)a, (Object)ai).transferToHost(1, new Object[]{ai, a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        int iterations = 50;
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            IntStream.range(0, 50).forEach(n -> executionPlan.execute());
        }
        int lastValue = ai.get();
        Assert.assertEquals((long)1911L, (long)lastValue);
    }

    @Test
    public void testAtomic17_getAndIncrement_kernel_api() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        Random random = new Random();
        int size = 32;
        IntArray dataTornadoVM = new IntArray(32);
        IntArray dataSequential = new IntArray(32);
        for (int i = 0; i < 32; ++i) {
            int intRandomValue = random.nextInt();
            dataTornadoVM.set(i, intRandomValue);
            dataSequential.set(i, intRandomValue);
        }
        KernelContext context = new KernelContext();
        AtomicInteger ai = new AtomicInteger(200);
        AtomicInteger jai = new AtomicInteger(200);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataTornadoVM, ai}).task("t0", TestAtomics::atomic17GetAndIncrement, (Object)context, (Object)dataTornadoVM, (Object)ai).transferToHost(1, new Object[]{dataTornadoVM, ai});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        WorkerGrid1D workerGrid = new WorkerGrid1D(32);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)workerGrid);
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        TestAtomics.atomic17GetAndIncrement(dataSequential, jai);
        Assert.assertEquals((long)jai.get(), (long)ai.get());
        Assert.assertArrayEquals((int[])dataSequential.toHeapArray(), (int[])dataTornadoVM.toHeapArray());
    }

    @Test
    public void testAtomic17_getAndIncrement_parallel_api() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        Random random = new Random();
        int size = 32;
        IntArray dataTornadoVM = new IntArray(32);
        IntArray dataSequential = new IntArray(32);
        for (int i = 0; i < 32; ++i) {
            int intRandomValue = random.nextInt();
            dataTornadoVM.set(i, intRandomValue);
            dataSequential.set(i, intRandomValue);
        }
        AtomicInteger ai = new AtomicInteger(200);
        AtomicInteger jai = new AtomicInteger(200);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataTornadoVM, ai}).task("t0", TestAtomics::atomic17GetAndIncrement, (Object)dataTornadoVM, (Object)ai).transferToHost(1, new Object[]{dataTornadoVM, ai});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestAtomics.atomic17GetAndIncrement(dataSequential, jai);
        Assert.assertEquals((long)jai.get(), (long)ai.get());
        Assert.assertArrayEquals((int[])dataSequential.toHeapArray(), (int[])dataTornadoVM.toHeapArray());
    }

    @Test
    public void testAtomic17_incrementAndGet_kernel_api() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        Random random = new Random();
        int size = 32;
        IntArray dataTornadoVM = new IntArray(32);
        IntArray dataSequential = new IntArray(32);
        for (int i = 0; i < 32; ++i) {
            int intRandomValue = random.nextInt();
            dataTornadoVM.set(i, intRandomValue);
            dataSequential.set(i, intRandomValue);
        }
        KernelContext context = new KernelContext();
        AtomicInteger ai = new AtomicInteger(200);
        AtomicInteger jai = new AtomicInteger(200);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataTornadoVM, ai}).task("t0", TestAtomics::atomic17IncrementAndGet, (Object)context, (Object)dataTornadoVM, (Object)ai).transferToHost(1, new Object[]{dataTornadoVM, ai});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        WorkerGrid1D workerGrid = new WorkerGrid1D(32);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)workerGrid);
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        TestAtomics.atomic17IncrementAndGet(dataSequential, jai);
        Assert.assertEquals((long)jai.get(), (long)ai.get());
        Assert.assertArrayEquals((int[])dataSequential.toHeapArray(), (int[])dataTornadoVM.toHeapArray());
    }

    @Test
    public void testAtomic17_incrementAndGet_parallel_api() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        Random random = new Random();
        int size = 32;
        IntArray dataTornadoVM = new IntArray(32);
        IntArray dataSequential = new IntArray(32);
        for (int i = 0; i < 32; ++i) {
            int intRandomValue = random.nextInt();
            dataTornadoVM.set(i, intRandomValue);
            dataSequential.set(i, intRandomValue);
        }
        AtomicInteger ai = new AtomicInteger(200);
        AtomicInteger jai = new AtomicInteger(200);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataTornadoVM, ai}).task("t0", TestAtomics::atomic17IncrementAndGet, (Object)dataTornadoVM, (Object)ai).transferToHost(1, new Object[]{dataTornadoVM, ai});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestAtomics.atomic17IncrementAndGet(dataSequential, jai);
        Assert.assertEquals((long)jai.get(), (long)ai.get());
        Assert.assertArrayEquals((int[])dataSequential.toHeapArray(), (int[])dataTornadoVM.toHeapArray());
    }

    @Test
    public void testAtomic18_parallel_api_IntegerArray() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray dataTornadoVM = new IntArray(32);
        IntArray dataJava = new IntArray(32);
        for (int i = 0; i < 32; ++i) {
            dataTornadoVM.set(i, i);
            dataJava.set(i, i);
        }
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataTornadoVM}).task("t0", TestAtomics::atomic18, (Object)context, (Object)dataTornadoVM).transferToHost(1, new Object[]{dataTornadoVM});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withDefaultScheduler().execute();
        }
        TestAtomics.atomic18(context, dataJava);
        Assert.assertArrayEquals((int[])dataJava.toHeapArray(), (int[])dataTornadoVM.toHeapArray());
    }

    @Test
    public void testAtomic18_parallel_api_int_array() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        int[] dataTornadoVM = new int[32];
        int[] incrementingValues = new int[32];
        int[] dataJava = new int[32];
        for (int i = 0; i < 32; ++i) {
            dataTornadoVM[i] = i;
            dataJava[i] = i;
            incrementingValues[i] = 2 * i;
        }
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataTornadoVM, incrementingValues}).task("t0", TestAtomics::atomic18, (Object)context, (Object)dataTornadoVM, (Object)incrementingValues).transferToHost(1, new Object[]{dataTornadoVM});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withDefaultScheduler().execute();
        }
        TestAtomics.atomic18(context, dataJava, incrementingValues);
        Assert.assertArrayEquals((int[])dataJava, (int[])dataTornadoVM);
    }

    @Test
    public void testAtomic18_parallel_api_LongArray() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        LongArray dataTornadoVM = new LongArray(32);
        LongArray dataJava = new LongArray(32);
        for (int i = 0; i < 32; ++i) {
            dataTornadoVM.set(i, (long)i);
            dataJava.set(i, (long)i);
        }
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataTornadoVM}).task("t0", TestAtomics::atomic18, (Object)context, (Object)dataTornadoVM).transferToHost(1, new Object[]{dataTornadoVM});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withDefaultScheduler().execute();
        }
        TestAtomics.atomic18(context, dataJava);
        Assert.assertArrayEquals((long[])dataJava.toHeapArray(), (long[])dataTornadoVM.toHeapArray());
    }

    @Test
    public void testAtomic18_parallel_api_FloatArray() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.OPENCL);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        FloatArray dataTornadoVM = new FloatArray(32);
        for (int i = 0; i < 32; ++i) {
            dataTornadoVM.set(i, (float)i);
        }
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataTornadoVM}).task("t0", TestAtomics::atomic18, (Object)context, (Object)dataTornadoVM).transferToHost(1, new Object[]{dataTornadoVM});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withDefaultScheduler().execute();
        }
        for (int i = 0; i < 32; ++i) {
            Assert.assertEquals((float)(i + 1), (float)dataTornadoVM.get(i), (float)0.1f);
        }
    }

    @Test
    public void testAtomic18_parallel_api_DoubleArray() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.OPENCL);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        DoubleArray dataTornadoVM = new DoubleArray(32);
        for (int i = 0; i < 32; ++i) {
            dataTornadoVM.set(i, (double)i);
        }
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataTornadoVM}).task("t0", TestAtomics::atomic18, (Object)context, (Object)dataTornadoVM).transferToHost(1, new Object[]{dataTornadoVM});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withDefaultScheduler().execute();
        }
        for (int i = 0; i < 32; ++i) {
            Assert.assertEquals((double)(i + 1), (double)dataTornadoVM.get(i), (double)0.1f);
        }
    }

    @Test
    public void testAtomic18_kernel_api() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.OPENCL);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        IntArray dataTornadoVM = new IntArray(32);
        IntArray dataJava = new IntArray(32);
        for (int i = 0; i < 32; ++i) {
            dataTornadoVM.set(i, i);
            dataJava.set(i, i);
        }
        KernelContext context = new KernelContext();
        WorkerGrid1D workerGrid = new WorkerGrid1D(32);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)workerGrid);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataTornadoVM}).task("t0", TestAtomics::atomic18Kernel, (Object)context, (Object)dataTornadoVM).transferToHost(1, new Object[]{dataTornadoVM});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        TestAtomics.atomic18(context, dataJava);
        Assert.assertArrayEquals((int[])dataJava.toHeapArray(), (int[])dataTornadoVM.toHeapArray());
    }

    @Test
    public void testAtomic19_parallel_api() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.OPENCL);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        int indexForHistogram = 16;
        IntArray dataTornadoVM = new IntArray(32);
        IntArray output = new IntArray(32);
        IntArray outputJava = new IntArray(32);
        dataTornadoVM.init(16);
        output.init(0);
        KernelContext context = new KernelContext();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataTornadoVM}).task("t0", TestAtomics::atomic19, (Object)context, (Object)dataTornadoVM, (Object)output).transferToHost(1, new Object[]{output});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withDefaultScheduler().execute();
        }
        TestAtomics.atomic19(context, dataTornadoVM, outputJava);
        Assert.assertArrayEquals((int[])outputJava.toHeapArray(), (int[])output.toHeapArray());
    }

    @Test
    public void testAtomic19_kernel_api() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.OPENCL);
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int size = 32;
        int indexForHistogram = 16;
        IntArray dataTornadoVM = new IntArray(32);
        IntArray output = new IntArray(32);
        IntArray outputJava = new IntArray(32);
        dataTornadoVM.init(16);
        output.init(0);
        KernelContext context = new KernelContext();
        WorkerGrid1D workerGrid = new WorkerGrid1D(32);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)workerGrid);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataTornadoVM}).task("t0", TestAtomics::atomic19Kernel, (Object)context, (Object)dataTornadoVM, (Object)output).transferToHost(1, new Object[]{output});
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{taskGraph.snapshot()});){
            executionPlan.withGridScheduler(gridScheduler).execute();
        }
        TestAtomics.atomic19(context, dataTornadoVM, outputJava);
        Assert.assertArrayEquals((int[])outputJava.toHeapArray(), (int[])output.toHeapArray());
    }
}

