/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.arrays;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestBasicOperations
extends TornadoTestBase {
    public static void vectorAddDouble(DoubleArray a, DoubleArray b, DoubleArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void vectorSubDouble(DoubleArray a, DoubleArray b, DoubleArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) - b.get(i));
        }
    }

    public static void vectorMulDouble(DoubleArray a, DoubleArray b, DoubleArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) * b.get(i));
        }
    }

    public static void vectorDivDouble(DoubleArray a, DoubleArray b, DoubleArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) / b.get(i));
        }
    }

    public static void vectorAddFloat(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void vectorSubFloat(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) - b.get(i));
        }
    }

    public static void vectorMulFloat(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) * b.get(i));
        }
    }

    public static void vectorDivFloat(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) / b.get(i));
        }
    }

    public static void vectorAddInteger(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void vectorSubInteger(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) - b.get(i));
        }
    }

    public static void vectorMulInteger(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) * b.get(i));
        }
    }

    public static void vectorDivInteger(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) / b.get(i));
        }
    }

    public static void vectorAddLong(LongArray a, LongArray b, LongArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void vectorSubLong(LongArray a, LongArray b, LongArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) - b.get(i));
        }
    }

    public static void vectorMulLong(LongArray a, LongArray b, LongArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) * b.get(i));
        }
    }

    public static void vectorDivLong(LongArray a, LongArray b, LongArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) / b.get(i));
        }
    }

    public static void vectorAddShort(ShortArray a, ShortArray b, ShortArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, (short)(a.get(i) + b.get(i)));
        }
    }

    public static void vectorSubShort(ShortArray a, ShortArray b, ShortArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, (short)(a.get(i) - b.get(i)));
        }
    }

    public static void vectorMulShort(ShortArray a, ShortArray b, ShortArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, (short)(a.get(i) * b.get(i)));
        }
    }

    public static void vectorDivShort(ShortArray a, ShortArray b, ShortArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, (short)(a.get(i) / b.get(i)));
        }
    }

    public static void vectorAddChar(char[] a, char[] b, char[] c) {
        for (int i = 0; i < a.length; ++i) {
            c[i] = (char)(a[i] + b[i]);
        }
    }

    public static void vectorSubChar(char[] a, char[] b, char[] c) {
        for (int i = 0; i < a.length; ++i) {
            c[i] = (char)(a[i] - b[i]);
        }
    }

    public static void vectorMulChar(char[] a, char[] b, char[] c) {
        for (int i = 0; i < a.length; ++i) {
            c[i] = (char)(a[i] * b[i]);
        }
    }

    public static void vectorDivChar(char[] a, char[] b, char[] c) {
        for (int i = 0; i < a.length; ++i) {
            c[i] = (char)(a[i] / b[i]);
        }
    }

    @Test
    public void testVectorAdditionDouble() {
        int numElements = 32;
        DoubleArray a = new DoubleArray(32);
        DoubleArray b = new DoubleArray(32);
        DoubleArray c = new DoubleArray(32);
        IntStream.range(0, 32).sequential().forEach(i -> {
            a.set(i, (double)((float)Math.random()));
            b.set(i, (double)((float)Math.random()));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorAddDouble, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((double)(a.get(i2) + b.get(i2)), (double)c.get(i2), (double)0.01);
        }
    }

    @Test
    public void testVectorSubtractionDouble() {
        int numElements = 32;
        DoubleArray a = new DoubleArray(32);
        DoubleArray b = new DoubleArray(32);
        DoubleArray c = new DoubleArray(32);
        IntStream.range(0, 32).sequential().forEach(i -> {
            a.set(i, (double)((float)Math.random()));
            b.set(i, (double)((float)Math.random()));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorSubDouble, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((double)(a.get(i2) - b.get(i2)), (double)c.get(i2), (double)0.01);
        }
    }

    @Test
    public void testVectorMultiplicationDouble() {
        int numElements = 32;
        DoubleArray a = new DoubleArray(32);
        DoubleArray b = new DoubleArray(32);
        DoubleArray c = new DoubleArray(32);
        IntStream.range(0, 32).sequential().forEach(i -> {
            a.set(i, (double)((float)Math.random()));
            b.set(i, (double)((float)Math.random()));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorMulDouble, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((double)(a.get(i2) * b.get(i2)), (double)c.get(i2), (double)0.01);
        }
    }

    @Test
    public void testVectorDivisionDouble() {
        int numElements = 32;
        DoubleArray a = new DoubleArray(32);
        DoubleArray b = new DoubleArray(32);
        DoubleArray c = new DoubleArray(32);
        IntStream.range(0, 32).sequential().forEach(i -> {
            a.set(i, (double)((float)Math.random()));
            b.set(i, (double)((float)Math.random()));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorDivDouble, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((double)(a.get(i2) / b.get(i2)), (double)c.get(i2), (double)0.01);
        }
    }

    @Test
    public void testVectorAdditionFloat() {
        int numElements = 32;
        FloatArray a = new FloatArray(32);
        FloatArray b = new FloatArray(32);
        FloatArray c = new FloatArray(32);
        IntStream.range(0, 32).sequential().forEach(i -> {
            a.set(i, (float)Math.random());
            b.set(i, (float)Math.random());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorAddFloat, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((float)(a.get(i2) + b.get(i2)), (float)c.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testVectorSubtractionFloat() {
        int numElements = 32;
        FloatArray a = new FloatArray(32);
        FloatArray b = new FloatArray(32);
        FloatArray c = new FloatArray(32);
        IntStream.range(0, 32).sequential().forEach(i -> {
            a.set(i, (float)Math.random());
            b.set(i, (float)Math.random());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorSubFloat, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((float)(a.get(i2) - b.get(i2)), (float)c.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testVectorMultiplicationFloat() {
        int numElements = 32;
        FloatArray a = new FloatArray(32);
        FloatArray b = new FloatArray(32);
        FloatArray c = new FloatArray(32);
        IntStream.range(0, 32).sequential().forEach(i -> {
            a.set(i, (float)Math.random());
            b.set(i, (float)Math.random());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorMulFloat, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((float)(a.get(i2) * b.get(i2)), (float)c.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testVectorDivisionFloat() {
        int numElements = 32;
        FloatArray a = new FloatArray(32);
        FloatArray b = new FloatArray(32);
        FloatArray c = new FloatArray(32);
        IntStream.range(0, 32).sequential().forEach(i -> {
            a.set(i, (float)Math.random());
            b.set(i, (float)Math.random());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorDivFloat, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((float)(a.get(i2) / b.get(i2)), (float)c.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testVectorAdditionInteger() {
        int numElements = 32;
        IntArray a = new IntArray(32);
        IntArray b = new IntArray(32);
        IntArray c = new IntArray(32);
        Random r = new Random();
        IntStream.range(0, 32).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorAddInteger, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((long)(a.get(i2) + b.get(i2)), (long)c.get(i2));
        }
    }

    @Test
    public void testVectorSubtractionInteger() {
        int numElements = 32;
        IntArray a = new IntArray(32);
        IntArray b = new IntArray(32);
        IntArray c = new IntArray(32);
        Random r = new Random();
        IntStream.range(0, 32).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorSubInteger, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((long)(a.get(i2) - b.get(i2)), (long)c.get(i2));
        }
    }

    @Test
    public void testVectorMultiplicationInteger() {
        int numElements = 32;
        IntArray a = new IntArray(32);
        IntArray b = new IntArray(32);
        IntArray c = new IntArray(32);
        Random r = new Random();
        IntStream.range(0, 32).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorMulInteger, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((long)(a.get(i2) * b.get(i2)), (long)c.get(i2));
        }
    }

    @Test
    public void testVectorDivisionInteger() {
        int numElements = 32;
        IntArray a = new IntArray(32);
        IntArray b = new IntArray(32);
        IntArray c = new IntArray(32);
        Random r = new Random();
        IntStream.range(0, 32).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorDivInteger, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((long)(a.get(i2) / b.get(i2)), (long)c.get(i2));
        }
    }

    @Test
    public void testVectorAdditionLong() {
        int numElements = 32;
        LongArray a = new LongArray(32);
        LongArray b = new LongArray(32);
        LongArray c = new LongArray(32);
        Random r = new Random();
        IntStream.range(0, 32).parallel().forEach(i -> {
            a.set(i, r.nextLong());
            b.set(i, r.nextLong());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorAddLong, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((long)(a.get(i2) + b.get(i2)), (long)c.get(i2));
        }
    }

    @Test
    public void testVectorSubtractionLong() {
        int numElements = 32;
        LongArray a = new LongArray(32);
        LongArray b = new LongArray(32);
        LongArray c = new LongArray(32);
        Random r = new Random();
        IntStream.range(0, 32).parallel().forEach(i -> {
            a.set(i, r.nextLong());
            b.set(i, r.nextLong());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorSubLong, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((long)(a.get(i2) - b.get(i2)), (long)c.get(i2));
        }
    }

    @Test
    public void testVectorMultiplicationLong() {
        int numElements = 32;
        LongArray a = new LongArray(32);
        LongArray b = new LongArray(32);
        LongArray c = new LongArray(32);
        Random r = new Random();
        IntStream.range(0, 32).parallel().forEach(i -> {
            a.set(i, r.nextLong());
            b.set(i, r.nextLong());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorMulLong, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((long)(a.get(i2) * b.get(i2)), (long)c.get(i2));
        }
    }

    @Test
    public void testVectorDivisionLong() {
        int numElements = 32;
        LongArray a = new LongArray(32);
        LongArray b = new LongArray(32);
        LongArray c = new LongArray(32);
        Random r = new Random();
        IntStream.range(0, 32).parallel().forEach(i -> {
            a.set(i, r.nextLong());
            b.set(i, r.nextLong());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorDivLong, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((long)(a.get(i2) / b.get(i2)), (long)c.get(i2));
        }
    }

    @Test
    public void testVectorAdditionShort() {
        int numElements = 32;
        ShortArray a = new ShortArray(32);
        ShortArray b = new ShortArray(32);
        ShortArray c = new ShortArray(32);
        IntStream.range(0, 32).parallel().forEach(idx -> {
            a.set(idx, (short)20);
            b.set(idx, (short)34);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorAddShort, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((long)((short)(a.get(i) + b.get(i))), (long)c.get(i));
        }
    }

    @Test
    public void testVectorSubtractionShort() {
        int numElements = 32;
        ShortArray a = new ShortArray(32);
        ShortArray b = new ShortArray(32);
        ShortArray c = new ShortArray(32);
        IntStream.range(0, 32).parallel().forEach(idx -> {
            a.set(idx, (short)20);
            a.set(idx, (short)34);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorSubShort, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((long)((short)(a.get(i) - b.get(i))), (long)c.get(i));
        }
    }

    @Test
    public void testVectorMultiplicationShort() {
        int numElements = 32;
        ShortArray a = new ShortArray(32);
        ShortArray b = new ShortArray(32);
        ShortArray c = new ShortArray(32);
        IntStream.range(0, 32).parallel().forEach(idx -> {
            a.set(idx, (short)20);
            a.set(idx, (short)34);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorMulShort, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((long)((short)(a.get(i) * b.get(i))), (long)c.get(i));
        }
    }

    @Test
    public void testVectorDivisionShort() {
        int numElements = 32;
        ShortArray a = new ShortArray(32);
        ShortArray b = new ShortArray(32);
        ShortArray c = new ShortArray(32);
        IntStream.range(0, 32).parallel().forEach(idx -> {
            a.set(idx, (short)20);
            b.set(idx, (short)34);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorDivShort, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((long)((short)(a.get(i) / b.get(i))), (long)c.get(i));
        }
    }

    @Test
    public void testVectorAdditionChar() {
        int numElements = 32;
        char[] a = new char[32];
        char[] b = new char[32];
        char[] c = new char[32];
        IntStream.range(0, 32).parallel().forEach(idx -> {
            a[idx] = 20;
            b[idx] = 34;
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorAddChar, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < c.length; ++i) {
            Assert.assertEquals((long)((char)(a[i] + b[i])), (long)c[i]);
        }
    }

    @Test
    public void testVectorSubtractionChar() {
        int numElements = 32;
        char[] a = new char[32];
        char[] b = new char[32];
        char[] c = new char[32];
        IntStream.range(0, 32).parallel().forEach(idx -> {
            a[idx] = 20;
            b[idx] = 34;
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorSubChar, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < c.length; ++i) {
            Assert.assertEquals((long)((char)(a[i] - b[i])), (long)c[i]);
        }
    }

    @Test
    public void testVectorMultiplicationChar() {
        int numElements = 32;
        char[] a = new char[32];
        char[] b = new char[32];
        char[] c = new char[32];
        IntStream.range(0, 32).parallel().forEach(idx -> {
            a[idx] = 20;
            b[idx] = 34;
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorMulChar, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < c.length; ++i) {
            Assert.assertEquals((long)((char)(a[i] * b[i])), (long)c[i]);
        }
    }

    @Test
    public void testVectorDivisionChar() {
        int numElements = 32;
        char[] a = new char[32];
        char[] b = new char[32];
        char[] c = new char[32];
        IntStream.range(0, 32).parallel().forEach(idx -> {
            a[idx] = 20;
            b[idx] = 34;
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestBasicOperations::vectorDivChar, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});
        executionPlan.execute();
        for (int i = 0; i < c.length; ++i) {
            Assert.assertEquals((long)((char)(a[i] / b[i])), (long)c[i]);
        }
    }
}

