/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.arrays;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.KernelContext;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.WorkerGrid1D;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.CharArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestArrays
extends TornadoTestBase {
    public static void addAccumulator(IntArray a, int value) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, a.get(i) + value);
        }
    }

    public static void vectorAddDouble(DoubleArray a, DoubleArray b, DoubleArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void vectorAddFloat(FloatArray a, FloatArray b, FloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void vectorAddInteger(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void vectorAddIntegerKernelContext(IntArray a, KernelContext context, IntArray b, IntArray c) {
        int idx = context.globalIdx;
        c.set(idx, a.get(idx) + b.get(idx));
    }

    public static void vectorAddLong(LongArray a, LongArray b, LongArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void vectorAddShort(ShortArray a, ShortArray b, ShortArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, (short)(a.get(i) + b.get(i)));
        }
    }

    public static void vectorChars(CharArray a, CharArray b, CharArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, 'f');
        }
    }

    public static void vectorAddByte(ByteArray a, ByteArray b, ByteArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, (byte)(a.get(i) + b.get(i)));
        }
    }

    public static void addChars(CharArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, (char)(a.get(i) + b.get(i)));
        }
    }

    public static void initHalfFloatVector(HalfFloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, new HalfFloat(100.0f));
        }
    }

    public static void vectorAddHalfFloat(HalfFloatArray a, HalfFloatArray b, HalfFloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, HalfFloat.add((HalfFloat)a.get(i), (HalfFloat)b.get(i)));
        }
    }

    public static void vectorSubHalfFloat(HalfFloatArray a, HalfFloatArray b, HalfFloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, HalfFloat.sub((HalfFloat)a.get(i), (HalfFloat)b.get(i)));
        }
    }

    public static void vectorMultHalfFloat(HalfFloatArray a, HalfFloatArray b, HalfFloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, HalfFloat.mult((HalfFloat)a.get(i), (HalfFloat)b.get(i)));
        }
    }

    public static void vectorDivHalfFloat(HalfFloatArray a, HalfFloatArray b, HalfFloatArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, HalfFloat.div((HalfFloat)a.get(i), (HalfFloat)b.get(i)));
        }
    }

    public static void initializeSequentialByte(ByteArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, (byte)21);
        }
    }

    public static void initializeSequential(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 1);
        }
    }

    public static void initializeToOneParallel(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, 1);
        }
    }

    @Test
    public void testWarmUp() throws TornadoExecutionPlanException {
        int N = 128;
        int numKernels = 16;
        IntArray data = new IntArray(128);
        IntStream.range(0, 128).parallel().forEach(idx -> data.set(idx, idx));
        TaskGraph taskGraph = new TaskGraph("s0");
        Assert.assertNotNull((Object)taskGraph);
        taskGraph.transferToDevice(0, new Object[]{data});
        for (int i = 0; i < numKernels; ++i) {
            taskGraph.task("t" + i, TestArrays::addAccumulator, (Object)data, (Object)1);
        }
        taskGraph.transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withPreCompilation().execute();
        }
        for (int i = 0; i < 128; ++i) {
            Assert.assertEquals((long)(i + numKernels), (long)data.get(i));
        }
    }

    @Test
    public void testInitByteArray() throws TornadoExecutionPlanException {
        int N = 128;
        ByteArray data = new ByteArray(128);
        TaskGraph taskGraph = new TaskGraph("s0");
        Assert.assertNotNull((Object)taskGraph);
        taskGraph.task("t0", TestArrays::initializeSequentialByte, (Object)data);
        taskGraph.transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withPreCompilation().execute();
        }
        for (int i = 0; i < 128; ++i) {
            Assert.assertEquals((long)21L, (long)data.get(i));
        }
    }

    @Test
    public void testInitNotParallel() throws TornadoExecutionPlanException {
        int N = 128;
        IntArray data = new IntArray(128);
        TaskGraph taskGraph = new TaskGraph("s0");
        Assert.assertNotNull((Object)taskGraph);
        taskGraph.task("t0", TestArrays::initializeSequential, (Object)data);
        taskGraph.transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withPreCompilation().execute();
        }
        for (int i = 0; i < 128; ++i) {
            Assert.assertEquals((double)1.0, (double)data.get(i), (double)1.0E-4);
        }
    }

    @Test
    public void testInitParallel() throws TornadoExecutionPlanException {
        int N = 128;
        IntArray data = new IntArray(128);
        TaskGraph taskGraph = new TaskGraph("s0");
        Assert.assertNotNull((Object)taskGraph);
        taskGraph.task("t0", TestArrays::initializeToOneParallel, (Object)data);
        taskGraph.transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withPreCompilation().execute();
        }
        for (int i = 0; i < 128; ++i) {
            Assert.assertEquals((double)1.0, (double)data.get(i), (double)1.0E-4);
        }
    }

    @Test
    public void testAdd() throws TornadoExecutionPlanException {
        int N = 128;
        int numKernels = 8;
        IntArray data = new IntArray(128);
        IntStream.range(0, 128).parallel().forEach(idx -> data.set(idx, idx));
        TaskGraph taskGraph = new TaskGraph("s0");
        Assert.assertNotNull((Object)taskGraph);
        taskGraph.transferToDevice(1, new Object[]{data});
        for (int i = 0; i < numKernels; ++i) {
            taskGraph.task("t" + i, TestArrays::addAccumulator, (Object)data, (Object)1);
        }
        taskGraph.transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withPreCompilation().execute();
        }
        for (int i = 0; i < 128; ++i) {
            Assert.assertEquals((double)(i + numKernels), (double)data.get(i), (double)1.0E-4);
        }
    }

    @Test
    public void testVectorAdditionDouble() throws TornadoExecutionPlanException {
        int numElements = 4096;
        DoubleArray a = new DoubleArray(4096);
        DoubleArray b = new DoubleArray(4096);
        DoubleArray c = new DoubleArray(4096);
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, (double)((float)Math.random()));
            b.set(i, (double)((float)Math.random()));
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestArrays::vectorAddDouble, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((double)(a.get(i2) + b.get(i2)), (double)c.get(i2), (double)0.01);
        }
    }

    @Test
    public void testVectorAdditionFloat() throws TornadoExecutionPlanException {
        int numElements = 4096;
        FloatArray a = new FloatArray(4096);
        FloatArray b = new FloatArray(4096);
        FloatArray c = new FloatArray(4096);
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, (float)Math.random());
            b.set(i, (float)Math.random());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestArrays::vectorAddFloat, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((float)(a.get(i2) + b.get(i2)), (float)c.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testVectorAdditionInteger() throws TornadoExecutionPlanException {
        int numElements = 4096;
        IntArray a = new IntArray(4096);
        IntArray b = new IntArray(4096);
        IntArray c = new IntArray(4096);
        Random r = new Random();
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestArrays::vectorAddInteger, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            for (int i2 = 0; i2 < 10; ++i2) {
                executionPlan.execute();
            }
        }
        for (int i3 = 0; i3 < c.getSize(); ++i3) {
            Assert.assertEquals((long)(a.get(i3) + b.get(i3)), (long)c.get(i3));
        }
    }

    @Test
    public void testVectorAdditionIntegerKernelContext() throws TornadoExecutionPlanException {
        int numElements = 4096;
        IntArray a = new IntArray(4096);
        IntArray b = new IntArray(4096);
        IntArray c = new IntArray(4096);
        Random r = new Random();
        IntStream.range(0, 4096).sequential().forEach(i -> {
            a.set(i, r.nextInt());
            b.set(i, r.nextInt());
        });
        KernelContext context = new KernelContext();
        WorkerGrid1D grid = new WorkerGrid1D(4096);
        GridScheduler gridScheduler = new GridScheduler("s0.t0", (WorkerGrid)grid);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b, context}).task("t0", TestArrays::vectorAddIntegerKernelContext, (Object)a, (Object)context, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withGridScheduler(gridScheduler).execute();
            for (int i2 = 0; i2 < 10; ++i2) {
                executionPlan.execute();
            }
        }
        for (int i3 = 0; i3 < c.getSize(); ++i3) {
            Assert.assertEquals((long)(a.get(i3) + b.get(i3)), (long)c.get(i3));
        }
    }

    @Test
    public void testVectorAdditionLong() throws TornadoExecutionPlanException {
        int numElements = 4096;
        LongArray a = new LongArray(4096);
        LongArray b = new LongArray(4096);
        LongArray c = new LongArray(4096);
        IntStream.range(0, 4096).parallel().forEach(i -> {
            a.set(i, (long)i);
            b.set(i, (long)i);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestArrays::vectorAddLong, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i2 = 0; i2 < c.getSize(); ++i2) {
            Assert.assertEquals((long)(a.get(i2) + b.get(i2)), (long)c.get(i2));
        }
    }

    @Test
    public void testVectorAdditionShort() throws TornadoExecutionPlanException {
        int numElements = 4096;
        ShortArray a = new ShortArray(4096);
        ShortArray b = new ShortArray(4096);
        ShortArray c = new ShortArray(4096);
        IntStream.range(0, 4096).parallel().forEach(idx -> {
            a.set(idx, (short)20);
            b.set(idx, (short)34);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestArrays::vectorAddShort, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((long)(a.get(i) + b.get(i)), (long)c.get(i));
        }
    }

    @Test
    public void testVectorChars() throws TornadoExecutionPlanException {
        int numElements = 4096;
        CharArray a = new CharArray(4096);
        CharArray b = new CharArray(4096);
        CharArray c = new CharArray(4096);
        IntStream.range(0, 4096).parallel().forEach(idx -> {
            a.set(idx, 'a');
            b.set(idx, '0');
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestArrays::vectorChars, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((long)102L, (long)c.get(i));
        }
    }

    @Test
    public void testVectorBytes() throws TornadoExecutionPlanException {
        int numElements = 4096;
        ByteArray a = new ByteArray(4096);
        ByteArray b = new ByteArray(4096);
        ByteArray c = new ByteArray(4096);
        IntStream.range(0, 4096).parallel().forEach(idx -> {
            a.set(idx, (byte)10);
            b.set(idx, (byte)11);
        });
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestArrays::vectorAddByte, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((long)21L, (long)c.get(i));
        }
    }

    @Test
    public void testHalfFloatInitialization() throws TornadoExecutionPlanException {
        int numElements = 4096;
        HalfFloatArray c = new HalfFloatArray(4096);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestArrays::initHalfFloatVector, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((float)100.0f, (float)c.get(i).getFloat32(), (float)0.01f);
        }
    }

    @Test
    public void testVectorAdditionHalfFloat() throws TornadoExecutionPlanException {
        int numElements = 4096;
        HalfFloatArray a = new HalfFloatArray(4096);
        HalfFloatArray b = new HalfFloatArray(4096);
        HalfFloatArray c = new HalfFloatArray(4096);
        a.init(new HalfFloat(6.0f));
        b.init(new HalfFloat(2.0f));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestArrays::vectorAddHalfFloat, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((float)8.0f, (float)c.get(i).getFloat32(), (float)0.01f);
        }
    }

    @Test
    public void testVectorSubtractionHalfFloat() throws TornadoExecutionPlanException {
        int numElements = 4096;
        HalfFloatArray a = new HalfFloatArray(4096);
        HalfFloatArray b = new HalfFloatArray(4096);
        HalfFloatArray c = new HalfFloatArray(4096);
        a.init(new HalfFloat(6.0f));
        b.init(new HalfFloat(2.0f));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestArrays::vectorSubHalfFloat, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((float)4.0f, (float)c.get(i).getFloat32(), (float)0.01f);
        }
    }

    @Test
    public void testVectorMultiplicationHalfFloat() throws TornadoExecutionPlanException {
        int numElements = 4096;
        HalfFloatArray a = new HalfFloatArray(4096);
        HalfFloatArray b = new HalfFloatArray(4096);
        HalfFloatArray c = new HalfFloatArray(4096);
        a.init(new HalfFloat(6.0f));
        b.init(new HalfFloat(2.0f));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestArrays::vectorMultHalfFloat, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((float)12.0f, (float)c.get(i).getFloat32(), (float)0.01f);
        }
    }

    @Test
    public void testVectorDivisionHalfFloat() throws TornadoExecutionPlanException {
        int numElements = 4096;
        HalfFloatArray a = new HalfFloatArray(4096);
        HalfFloatArray b = new HalfFloatArray(4096);
        HalfFloatArray c = new HalfFloatArray(4096);
        a.init(new HalfFloat(6.0f));
        b.init(new HalfFloat(2.0f));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestArrays::vectorDivHalfFloat, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((float)3.0f, (float)c.get(i).getFloat32(), (float)0.01f);
        }
    }

    @Test
    public void testVectorCharsMessage() throws TornadoExecutionPlanException {
        CharArray a = new CharArray(12);
        a.set(0, 'h');
        a.set(1, 'e');
        a.set(2, 'l');
        a.set(3, 'l');
        a.set(4, 'o');
        a.set(5, ' ');
        a.set(6, '\u0000');
        a.set(7, '\u0000');
        a.set(8, '\u0000');
        a.set(9, '\u0000');
        a.set(10, '\u0000');
        a.set(11, '\u0000');
        IntArray b = new IntArray(16);
        b.set(0, 15);
        b.set(1, 10);
        b.set(2, 6);
        b.set(3, 0);
        b.set(4, -11);
        b.set(5, 1);
        b.set(6, 0);
        b.set(7, 0);
        b.set(8, 0);
        b.set(9, 0);
        b.set(10, 0);
        b.set(11, 0);
        b.set(12, 0);
        b.set(13, 0);
        b.set(14, 0);
        b.set(15, 0);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a, b}).task("t0", TestArrays::addChars, (Object)a, (Object)b).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        Assert.assertEquals((long)119L, (long)a.get(0));
        Assert.assertEquals((long)111L, (long)a.get(1));
        Assert.assertEquals((long)114L, (long)a.get(2));
        Assert.assertEquals((long)108L, (long)a.get(3));
        Assert.assertEquals((long)100L, (long)a.get(4));
        Assert.assertEquals((long)33L, (long)a.get(5));
    }
}

