/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.arrays;

import java.util.Random;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestArrayCopies
extends TornadoTestBase {
    public static void intPrivateCopy(IntArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            int[] arrayA = new int[128];
            int[] arrayB = new int[128];
            for (int j = 0; j < 128; ++j) {
                arrayA[j] = j;
                arrayB[j] = 2;
            }
            if (a.get(i) % 2 == 0) {
                arrayB = arrayA;
            }
            b.set(i, arrayB[i]);
        }
    }

    public static void floatPrivateCopy(FloatArray a, FloatArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            float[] arrayA = new float[128];
            float[] arrayB = new float[128];
            for (int j = 0; j < 128; ++j) {
                arrayA[j] = j;
                arrayB[j] = 2.0f;
            }
            if (a.get(i) == 1.0f) {
                arrayB = arrayA;
            }
            b.set(i, arrayB[i]);
        }
    }

    public static void doublePrivateCopy(DoubleArray a, DoubleArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            double[] arrayA = new double[128];
            double[] arrayB = new double[128];
            for (int j = 0; j < 128; ++j) {
                arrayA[j] = j;
                arrayB[j] = 2.0;
            }
            double variable = a.get(i) * 2.0;
            if (variable < 0.3) {
                arrayB = arrayA;
            }
            b.set(i, arrayB[i]);
        }
    }

    public static void longPrivateCopy(LongArray a, LongArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            long[] arrayA = new long[128];
            long[] arrayB = new long[128];
            for (int j = 0; j < 128; ++j) {
                arrayA[j] = j;
                arrayB[j] = 2L;
            }
            if (a.get(i) % 2L == 0L) {
                arrayB = arrayA;
            }
            b.set(i, arrayB[i]);
        }
    }

    public static void intPrivateCopyNoCondition(IntArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            int[] arrayA = new int[128];
            int[] arrayB = new int[128];
            for (int j = 0; j < 128; ++j) {
                arrayA[j] = j;
                arrayB[j] = 2;
            }
            arrayB = arrayA;
            b.set(i, arrayB[i]);
        }
    }

    @Test
    public void testPrivateArrayCopyInt() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int numElements = 16;
        IntArray a = new IntArray(16);
        IntArray b = new IntArray(16);
        IntArray c = new IntArray(16);
        Random r = new Random();
        IntStream.range(0, 16).sequential().forEach(i -> a.set(i, r.nextInt()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestArrayCopies::intPrivateCopy, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestArrayCopies.intPrivateCopy(a, c);
        for (int i2 = 0; i2 < 16; ++i2) {
            Assert.assertEquals((long)b.get(i2), (long)c.get(i2));
        }
    }

    @Test
    public void testPrivateArrayCopyFloat() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int numElements = 16;
        FloatArray a = new FloatArray(16);
        FloatArray b = new FloatArray(16);
        FloatArray c = new FloatArray(16);
        Random r = new Random();
        IntStream.range(0, 16).sequential().forEach(i -> a.set(i, r.nextFloat()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestArrayCopies::floatPrivateCopy, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestArrayCopies.floatPrivateCopy(a, c);
        for (int i2 = 0; i2 < 16; ++i2) {
            Assert.assertEquals((float)b.get(i2), (float)c.get(i2), (float)0.01f);
        }
    }

    @Test
    public void testPrivateArrayCopyDouble() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int numElements = 16;
        DoubleArray a = new DoubleArray(16);
        DoubleArray b = new DoubleArray(16);
        DoubleArray c = new DoubleArray(16);
        Random r = new Random();
        IntStream.range(0, 16).sequential().forEach(i -> a.set(i, r.nextDouble()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestArrayCopies::doublePrivateCopy, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestArrayCopies.doublePrivateCopy(a, c);
        for (int i2 = 0; i2 < 16; ++i2) {
            Assert.assertEquals((double)b.get(i2), (double)c.get(i2), (double)0.01);
        }
    }

    @Test
    public void testPrivateArrayCopyLong() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int numElements = 16;
        LongArray a = new LongArray(16);
        LongArray b = new LongArray(16);
        LongArray c = new LongArray(16);
        Random r = new Random();
        IntStream.range(0, 16).sequential().forEach(i -> a.set(i, r.nextLong()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestArrayCopies::longPrivateCopy, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestArrayCopies.longPrivateCopy(a, c);
        for (int i2 = 0; i2 < 16; ++i2) {
            Assert.assertEquals((long)b.get(i2), (long)c.get(i2));
        }
    }

    @Test
    public void testPrivateArrayCopyIntNoCondition() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        int numElements = 16;
        IntArray a = new IntArray(16);
        IntArray b = new IntArray(16);
        IntArray c = new IntArray(16);
        Random r = new Random();
        IntStream.range(0, 16).sequential().forEach(i -> a.set(i, r.nextInt()));
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestArrayCopies::intPrivateCopyNoCondition, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestArrayCopies.intPrivateCopyNoCondition(a, c);
        for (int i2 = 0; i2 < 16; ++i2) {
            Assert.assertEquals((long)b.get(i2), (long)c.get(i2));
        }
    }
}

