/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.api;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.CharArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestSlice
extends TornadoTestBase {
    private final int numElements = 256;

    @Test
    public void testFloatArraySlice() {
        FloatArray a = new FloatArray(256);
        FloatArray b = new FloatArray(256);
        FloatArray e = new FloatArray(256);
        a.init(100.0f);
        b.init(5.0f);
        e.init(12.0f);
        FloatArray c = FloatArray.concat((FloatArray[])new FloatArray[]{a, b, e});
        FloatArray slice = c.slice(256, 256);
        for (int i = 0; i < slice.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of slice", (float)5.0f, (float)slice.get(i), (float)0.0f);
        }
    }

    @Test
    public void testDoubleArraySlice() {
        DoubleArray a = new DoubleArray(256);
        DoubleArray b = new DoubleArray(256);
        DoubleArray e = new DoubleArray(256);
        a.init(100.0);
        b.init(5.0);
        e.init(12.0);
        DoubleArray c = DoubleArray.concat((DoubleArray[])new DoubleArray[]{a, b, e});
        DoubleArray slice = c.slice(256, 256);
        for (int i = 0; i < slice.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of slice", (double)5.0, (double)slice.get(i), (double)0.0);
        }
    }

    @Test
    public void testByteArraySlice() {
        ByteArray a = new ByteArray(256);
        ByteArray b = new ByteArray(256);
        ByteArray e = new ByteArray(256);
        a.init((byte)100);
        b.init((byte)5);
        e.init((byte)12);
        ByteArray c = ByteArray.concat((ByteArray[])new ByteArray[]{a, b, e});
        ByteArray slice = c.slice(256, 256);
        for (int i = 0; i < slice.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of slice", (double)5.0, (double)slice.get(i), (double)0.0);
        }
    }

    @Test
    public void testLongArraySlice() {
        LongArray a = new LongArray(256);
        LongArray b = new LongArray(256);
        LongArray e = new LongArray(256);
        a.init(100L);
        b.init(5L);
        e.init(12L);
        LongArray c = LongArray.concat((LongArray[])new LongArray[]{a, b, e});
        LongArray slice = c.slice(256, 256);
        for (int i = 0; i < slice.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of slice", (double)5.0, (double)slice.get(i), (double)0.0);
        }
    }

    @Test
    public void testIntArraySlice() {
        IntArray a = new IntArray(256);
        IntArray b = new IntArray(256);
        IntArray e = new IntArray(256);
        a.init(100);
        b.init(5);
        e.init(12);
        IntArray c = IntArray.concat((IntArray[])new IntArray[]{a, b, e});
        IntArray slice = c.slice(256, 256);
        for (int i = 0; i < slice.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of slice", (double)5.0, (double)slice.get(i), (double)0.0);
        }
    }

    @Test
    public void testShortArraySlice() {
        ShortArray a = new ShortArray(256);
        ShortArray b = new ShortArray(256);
        ShortArray e = new ShortArray(256);
        a.init((short)100);
        b.init((short)5);
        e.init((short)12);
        ShortArray c = ShortArray.concat((ShortArray[])new ShortArray[]{a, b, e});
        ShortArray slice = c.slice(256, 256);
        for (int i = 0; i < slice.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of slice", (double)5.0, (double)slice.get(i), (double)0.0);
        }
    }

    @Test
    public void testCharArraySlice() {
        CharArray a = new CharArray(256);
        CharArray b = new CharArray(256);
        CharArray e = new CharArray(256);
        a.init('d');
        b.init('\u0005');
        e.init('\f');
        CharArray c = CharArray.concat((CharArray[])new CharArray[]{a, b, e});
        CharArray slice = c.slice(256, 256);
        for (int i = 0; i < slice.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of slice", (double)5.0, (double)slice.get(i), (double)0.0);
        }
    }

    @Test
    public void testHalfFloatArraySlice() {
        HalfFloatArray a = new HalfFloatArray(256);
        HalfFloatArray b = new HalfFloatArray(256);
        HalfFloatArray e = new HalfFloatArray(256);
        a.init(new HalfFloat(100.0f));
        b.init(new HalfFloat(5.0f));
        e.init(new HalfFloat(12.0f));
        HalfFloatArray c = HalfFloatArray.concat((HalfFloatArray[])new HalfFloatArray[]{a, b, e});
        HalfFloatArray slice = c.slice(256, 256);
        for (int i = 0; i < slice.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of slice", (double)5.0, (double)slice.get(i).getFloat32(), (double)0.0);
        }
    }
}

