/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.api;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestMemorySegmentsAsType
extends TornadoTestBase {
    private final int numElements = 256;

    private static void getMemorySegment(MemorySegment a) {
        float test = a.getAtIndex(ValueLayout.JAVA_FLOAT, 5L);
    }

    @Test(expected=TornadoRuntimeException.class)
    public void testMemorySegmentAsInput() throws TornadoExecutionPlanException {
        long segmentByteSize = 256L * ValueLayout.JAVA_FLOAT.byteSize();
        MemorySegment segment = Arena.ofAuto().allocate(segmentByteSize, 1L);
        segment.setAtIndex(ValueLayout.JAVA_INT, 0L, 256);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{segment}).task("t0", TestMemorySegmentsAsType::getMemorySegment, (Object)segment).transferToHost(1, new Object[]{segment});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
    }
}

