/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.api;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.CharArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestInitDataTypes
extends TornadoTestBase {
    @Test
    public void testInitByteArray() throws TornadoExecutionPlanException {
        ByteArray array = new ByteArray(0x100000);
        TaskGraph taskGraph = new TaskGraph("graph").transferToDevice(0, new Object[]{array}).task("init", ByteArray::initialize, (Object)array, (Object)2).transferToHost(1, new Object[]{array});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((long)2L, (long)array.get(i));
        }
    }

    @Test
    public void testInitCharArray() throws TornadoExecutionPlanException {
        CharArray array = new CharArray(0x100000);
        TaskGraph taskGraph = new TaskGraph("graph").transferToDevice(0, new Object[]{array}).task("init", CharArray::initialize, (Object)array, (Object)Character.valueOf('a')).transferToHost(1, new Object[]{array});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((long)97L, (long)array.get(i));
        }
    }

    @Test
    public void testInitFloatArray() throws TornadoExecutionPlanException {
        FloatArray array = new FloatArray(0x100000);
        TaskGraph taskGraph = new TaskGraph("graph").transferToDevice(0, new Object[]{array}).task("init", FloatArray::initialize, (Object)array, (Object)Float.valueOf(2.0f)).transferToHost(1, new Object[]{array});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((float)2.0f, (float)array.get(i), (float)0.001f);
        }
    }

    @Test
    public void testInitDoubleArray() throws TornadoExecutionPlanException {
        DoubleArray array = new DoubleArray(0x100000);
        TaskGraph taskGraph = new TaskGraph("graph").transferToDevice(0, new Object[]{array}).task("init", DoubleArray::initialize, (Object)array, (Object)2.0).transferToHost(1, new Object[]{array});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((double)2.0, (double)array.get(i), (double)0.001f);
        }
    }

    @Test
    public void testInitShortArray() throws TornadoExecutionPlanException {
        ShortArray array = new ShortArray(0x100000);
        TaskGraph taskGraph = new TaskGraph("graph").transferToDevice(0, new Object[]{array}).task("init", ShortArray::initialize, (Object)array, (Object)2).transferToHost(1, new Object[]{array});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((long)2L, (long)array.get(i));
        }
    }

    @Test
    public void testInitIntArray() throws TornadoExecutionPlanException {
        IntArray array = new IntArray(0x100000);
        TaskGraph taskGraph = new TaskGraph("graph").transferToDevice(0, new Object[]{array}).task("init", IntArray::initialize, (Object)array, (Object)2).transferToHost(1, new Object[]{array});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((long)2L, (long)array.get(i));
        }
    }

    @Test
    public void testInitLongArray() throws TornadoExecutionPlanException {
        LongArray array = new LongArray(0x100000);
        TaskGraph taskGraph = new TaskGraph("graph").transferToDevice(0, new Object[]{array}).task("init", LongArray::initialize, (Object)array, (Object)2L).transferToHost(1, new Object[]{array});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((long)2L, (long)array.get(i));
        }
    }

    @Test
    public void testInitHalfFloatArray() throws TornadoExecutionPlanException {
        HalfFloatArray array = new HalfFloatArray(0x100000);
        TaskGraph taskGraph = new TaskGraph("graph").transferToDevice(0, new Object[]{array}).task("init", HalfFloatArray::initialize, (Object)array, (Object)new HalfFloat(2.0f)).transferToHost(1, new Object[]{array});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        float f = new HalfFloat(2.0f).getFloat32();
        for (int i = 0; i < array.getSize(); ++i) {
            Assert.assertEquals((float)f, (float)array.get(i).getFloat32(), (float)0.001f);
        }
    }
}

