/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.api;

import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.unittests.arrays.TestArrays;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestIO
extends TornadoTestBase {
    private FloatArray createAndInitializeArray(int size) {
        FloatArray array = new FloatArray(size);
        IntStream.range(0, size).parallel().forEach(idx -> array.set(idx, (float)idx));
        return array;
    }

    @Test
    public void testForceCopyIn() throws TornadoExecutionPlanException {
        int N = 128;
        FloatArray arrayA = this.createAndInitializeArray(128);
        FloatArray arrayB = this.createAndInitializeArray(128);
        FloatArray arrayC = new FloatArray(128);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{arrayA, arrayB}).task("t0", TestArrays::vectorAddFloat, (Object)arrayA, (Object)arrayB, (Object)arrayC).transferToHost(1, new Object[]{arrayC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            for (int i = 0; i < 4; ++i) {
                executionPlan.execute();
            }
        }
        for (int i = 0; i < 128; ++i) {
            Assert.assertEquals((float)(2 * i), (float)arrayC.get(i), (float)0.0f);
        }
    }

    @Test
    public void testStreamIn() throws TornadoExecutionPlanException {
        int N = 128;
        FloatArray arrayA = this.createAndInitializeArray(128);
        FloatArray arrayB = this.createAndInitializeArray(128);
        FloatArray arrayC = new FloatArray(128);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{arrayA, arrayB}).task("t0", TestArrays::vectorAddFloat, (Object)arrayA, (Object)arrayB, (Object)arrayC).transferToHost(1, new Object[]{arrayC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            for (int i = 0; i < 4; ++i) {
                executionPlan.execute();
            }
        }
        for (int i = 0; i < 128; ++i) {
            Assert.assertEquals((float)(2 * i), (float)arrayC.get(i), (float)0.0f);
        }
    }

    @Test
    public void testLockObjectsInMemory() throws TornadoExecutionPlanException {
        int N = 128;
        FloatArray arrayA = this.createAndInitializeArray(128);
        FloatArray arrayB = this.createAndInitializeArray(128);
        FloatArray arrayC = new FloatArray(128);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{arrayA, arrayB}).task("t0", TestArrays::vectorAddFloat, (Object)arrayA, (Object)arrayB, (Object)arrayC).transferToHost(1, new Object[]{arrayC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            for (int i = 0; i < 4; ++i) {
                executionPlan.execute();
            }
        }
        for (int i = 0; i < 128; ++i) {
            Assert.assertEquals((float)(2 * i), (float)arrayC.get(i), (float)0.0f);
        }
    }

    @Test
    public void testCopyInWithDevice() throws TornadoExecutionPlanException {
        int N = 16384;
        int ITERATIONS = 40;
        FloatArray arrayA = this.createAndInitializeArray(16384);
        FloatArray arrayB = this.createAndInitializeArray(16384);
        FloatArray arrayC = new FloatArray(16384);
        System.setProperty("tornado.profiler", "True");
        TaskGraph taskGraph = new TaskGraph("foo").transferToDevice(0, new Object[]{arrayA}).transferToDevice(1, new Object[]{arrayB}).task("bar", TestArrays::vectorAddFloat, (Object)arrayA, (Object)arrayB, (Object)arrayC).transferToHost(1, new Object[]{arrayC});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            long copyInSumSimpleExec = 0L;
            for (int i = 0; i < 40; ++i) {
                TornadoExecutionResult executionResult = executionPlan.execute();
                copyInSumSimpleExec += executionResult.getProfilerResult().getDeviceWriteTime();
            }
            executionPlan.freeDeviceMemory();
            executionPlan.withDevice(TornadoExecutionPlan.getDevice((int)0, (int)0));
            long copyInSumSimpleExecWithDev = 0L;
            for (int i = 0; i < 40; ++i) {
                TornadoExecutionResult executionResult = executionPlan.execute();
                copyInSumSimpleExecWithDev += executionResult.getProfilerResult().getDeviceWriteTime();
            }
            Assert.assertEquals((float)copyInSumSimpleExec, (float)copyInSumSimpleExecWithDev, (float)((float)copyInSumSimpleExec / 4.0f));
        }
    }
}

