/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.api;

import java.util.List;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.TornadoBackend;
import uk.ac.manchester.tornado.api.TornadoDeviceMap;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.enums.TornadoDeviceType;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoBackendNotFound;
import uk.ac.manchester.tornado.api.exceptions.TornadoDeviceNotFound;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestDevices
extends TornadoTestBase {
    @Test(expected=TornadoBackendNotFound.class)
    public void test01() {
        TornadoDevice device = TornadoExecutionPlan.getDevice((int)100, (int)0);
    }

    @Test(expected=TornadoDeviceNotFound.class)
    public void test02() {
        TornadoDevice device = TornadoExecutionPlan.getDevice((int)0, (int)100);
    }

    @Test
    public void test03() {
        TornadoDeviceMap tornadoDeviceMap = TornadoExecutionPlan.getTornadoDeviceMap();
        int numBackends = tornadoDeviceMap.getNumBackends();
        Assert.assertTrue((numBackends >= 1 ? 1 : 0) != 0);
        List backends = tornadoDeviceMap.getAllBackends();
        Assert.assertFalse((boolean)backends.isEmpty());
        int numDevicesBackendZero = ((TornadoBackend)backends.getFirst()).getNumDevices();
        Assert.assertTrue((numDevicesBackendZero >= 1 ? 1 : 0) != 0);
        TornadoDevice device = ((TornadoBackend)backends.getFirst()).getDevice(0);
        Assert.assertNotNull((Object)device);
    }

    @Test
    public void test04() {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        TornadoDeviceMap tornadoDeviceMap = TornadoExecutionPlan.getTornadoDeviceMap();
        int numBackends = tornadoDeviceMap.getNumBackends();
        Assert.assertTrue((numBackends >= 1 ? 1 : 0) != 0);
        List openCLBackend = tornadoDeviceMap.getBackendsWithPredicate(backend -> backend.getBackendType() == TornadoVMBackendType.OPENCL);
        Assert.assertNotNull((Object)openCLBackend);
        List multiDeviceBackends = tornadoDeviceMap.getBackendsWithPredicate(backend -> backend.getNumDevices() > 1);
        Assert.assertTrue((multiDeviceBackends.size() >= 1 ? 1 : 0) != 0);
        List spirvSupported = tornadoDeviceMap.getBackendsWithPredicate(backend -> backend.getDefaultDevice().isSPIRVSupported());
        List backendsWithNVIDIAAccess = tornadoDeviceMap.getBackendsWithDevicePredicate(device -> device.getPhysicalDevice().getDeviceName().toLowerCase().contains("nvidia"));
        Assert.assertFalse((boolean)backendsWithNVIDIAAccess.isEmpty());
        List backendsWithNVIDIAAccess2 = tornadoDeviceMap.getBackendsWithPredicate(backend -> backend.getAllDevices().stream().anyMatch(device -> device.getPhysicalDevice().getDeviceName().toLowerCase().contains("nvidia")));
        Assert.assertFalse((boolean)backendsWithNVIDIAAccess2.isEmpty());
    }

    @Test
    public void test05() {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        TornadoDeviceMap deviceMap = new TornadoDeviceMap();
        Stream deviceStream = deviceMap.getDevicesByName("NVIDIA");
        TornadoDevice device = (TornadoDevice)deviceStream.findFirst().get();
        Assert.assertNotNull((Object)device);
        Assert.assertTrue((boolean)device.getPhysicalDevice().getDeviceName().toLowerCase().contains("nvidia"));
    }

    @Test
    public void test06() {
        this.assertNotBackend(TornadoVMBackendType.PTX);
        TornadoDeviceType typeToFind = TornadoDeviceType.CPU;
        TornadoDeviceMap deviceMap = new TornadoDeviceMap();
        Stream deviceStream = deviceMap.getDevicesByType(typeToFind);
        TornadoDevice device = (TornadoDevice)deviceStream.findFirst().get();
        Assert.assertNotNull((Object)device);
        Assert.assertSame((Object)typeToFind, (Object)device.getDeviceType());
    }

    @Test
    public void test07() {
        TornadoDeviceMap deviceMap = new TornadoDeviceMap();
        Stream deviceStream = deviceMap.getDevicesByName("foo");
        Assert.assertTrue((boolean)deviceStream.findAny().isEmpty());
    }
}

