/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.api;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.CharArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestConcat
extends TornadoTestBase {
    public final int numElements = 256;

    @Test
    public void testFloatArrayConcat() {
        int i;
        FloatArray a = new FloatArray(256);
        FloatArray b = new FloatArray(256);
        FloatArray e = new FloatArray(256);
        a.init(100.0f);
        b.init(5.0f);
        e.init(12.0f);
        FloatArray c = FloatArray.concat((FloatArray[])new FloatArray[]{a, b, e});
        for (i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in first part of c", (float)100.0f, (float)c.get(i), (float)0.0f);
        }
        for (i = 0; i < b.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of c", (float)5.0f, (float)c.get(a.getSize() + i), (float)0.0f);
        }
        for (i = 0; i < e.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in third part of c", (float)12.0f, (float)c.get(a.getSize() + b.getSize() + i), (float)0.0f);
        }
    }

    @Test
    public void testDoubleArrayConcat() {
        int i;
        DoubleArray a = new DoubleArray(256);
        DoubleArray b = new DoubleArray(256);
        DoubleArray e = new DoubleArray(256);
        a.init(100.0);
        b.init(5.0);
        e.init(12.0);
        DoubleArray c = DoubleArray.concat((DoubleArray[])new DoubleArray[]{a, b, e});
        for (i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in first part of c", (double)100.0, (double)c.get(i), (double)0.0);
        }
        for (i = 0; i < b.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of c", (double)5.0, (double)c.get(a.getSize() + i), (double)0.0);
        }
        for (i = 0; i < e.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in third part of c", (double)12.0, (double)c.get(a.getSize() + b.getSize() + i), (double)0.0);
        }
    }

    @Test
    public void testByteArrayConcat() {
        int i;
        ByteArray a = new ByteArray(256);
        ByteArray b = new ByteArray(256);
        ByteArray e = new ByteArray(256);
        a.init((byte)100);
        b.init((byte)5);
        e.init((byte)12);
        ByteArray c = ByteArray.concat((ByteArray[])new ByteArray[]{a, b, e});
        for (i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in first part of c", (float)100.0f, (float)c.get(i), (float)0.0f);
        }
        for (i = 0; i < b.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of c", (float)5.0f, (float)c.get(a.getSize() + i), (float)0.0f);
        }
        for (i = 0; i < e.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in third part of c", (float)12.0f, (float)c.get(a.getSize() + b.getSize() + i), (float)0.0f);
        }
    }

    @Test
    public void testLongArrayConcat() {
        int i;
        LongArray a = new LongArray(256);
        LongArray b = new LongArray(256);
        LongArray e = new LongArray(256);
        a.init(100L);
        b.init(5L);
        e.init(12L);
        LongArray c = LongArray.concat((LongArray[])new LongArray[]{a, b, e});
        for (i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in first part of c", (float)100.0f, (float)c.get(i), (float)0.0f);
        }
        for (i = 0; i < b.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of c", (float)5.0f, (float)c.get(a.getSize() + i), (float)0.0f);
        }
        for (i = 0; i < e.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in third part of c", (float)12.0f, (float)c.get(a.getSize() + b.getSize() + i), (float)0.0f);
        }
    }

    @Test
    public void testIntArrayConcat() {
        int i;
        IntArray a = new IntArray(256);
        IntArray b = new IntArray(256);
        IntArray e = new IntArray(256);
        a.init(100);
        b.init(5);
        e.init(12);
        IntArray c = IntArray.concat((IntArray[])new IntArray[]{a, b, e});
        for (i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in first part of c", (float)100.0f, (float)c.get(i), (float)0.0f);
        }
        for (i = 0; i < b.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of c", (float)5.0f, (float)c.get(a.getSize() + i), (float)0.0f);
        }
        for (i = 0; i < e.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in third part of c", (float)12.0f, (float)c.get(a.getSize() + b.getSize() + i), (float)0.0f);
        }
    }

    @Test
    public void testShortArrayConcat() {
        int i;
        ShortArray a = new ShortArray(256);
        ShortArray b = new ShortArray(256);
        ShortArray e = new ShortArray(256);
        a.init((short)100);
        b.init((short)5);
        e.init((short)12);
        ShortArray c = ShortArray.concat((ShortArray[])new ShortArray[]{a, b, e});
        for (i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in first part of c", (float)100.0f, (float)c.get(i), (float)0.0f);
        }
        for (i = 0; i < b.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of c", (float)5.0f, (float)c.get(a.getSize() + i), (float)0.0f);
        }
        for (i = 0; i < e.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in third part of c", (float)12.0f, (float)c.get(a.getSize() + b.getSize() + i), (float)0.0f);
        }
    }

    @Test
    public void testCharArrayConcat() {
        int i;
        CharArray a = new CharArray(256);
        CharArray b = new CharArray(256);
        CharArray e = new CharArray(256);
        a.init('d');
        b.init('\u0005');
        e.init('\f');
        CharArray c = CharArray.concat((CharArray[])new CharArray[]{a, b, e});
        for (i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in first part of c", (float)100.0f, (float)c.get(i), (float)0.0f);
        }
        for (i = 0; i < b.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of c", (float)5.0f, (float)c.get(a.getSize() + i), (float)0.0f);
        }
        for (i = 0; i < e.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in third part of c", (float)12.0f, (float)c.get(a.getSize() + b.getSize() + i), (float)0.0f);
        }
    }

    @Test
    public void testHalfFloatArrayConcat() {
        int i;
        HalfFloatArray a = new HalfFloatArray(256);
        HalfFloatArray b = new HalfFloatArray(256);
        HalfFloatArray e = new HalfFloatArray(256);
        a.init(new HalfFloat(100.0f));
        b.init(new HalfFloat(5.0f));
        e.init(new HalfFloat(12.0f));
        HalfFloatArray c = HalfFloatArray.concat((HalfFloatArray[])new HalfFloatArray[]{a, b, e});
        for (i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in first part of c", (float)100.0f, (float)c.get(i).getFloat32(), (float)0.0f);
        }
        for (i = 0; i < b.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in second part of c", (float)5.0f, (float)c.get(a.getSize() + i).getFloat32(), (float)0.0f);
        }
        for (i = 0; i < e.getSize(); ++i) {
            Assert.assertEquals((String)"Mismatch in third part of c", (float)12.0f, (float)c.get(a.getSize() + b.getSize() + i).getFloat32(), (float)0.0f);
        }
    }
}

