/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.api;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestByteArrayTypedAccess
extends TornadoTestBase {
    private void assertHalfFloatEquals(String message, float expected, HalfFloat actual, float tolerance) {
        if (Float.isNaN(expected)) {
            Assert.assertTrue((String)(message + " - NaN not preserved"), (boolean)Float.isNaN(actual.getFloat32()));
        } else if (Float.isInfinite(expected)) {
            Assert.assertEquals((String)(message + " - Infinite value not preserved"), (float)expected, (float)actual.getFloat32(), (float)0.0f);
        } else {
            Assert.assertEquals((String)message, (float)expected, (float)actual.getFloat32(), (float)tolerance);
        }
    }

    @Test
    public void testByteArrayHalfFloatOperations() {
        int byteIndex;
        int i;
        int numHalfFloats = 5;
        int byteArraySize = 10;
        ByteArray byteArray = new ByteArray(10);
        HalfFloat[] testValues = new HalfFloat[]{new HalfFloat(1.5f), new HalfFloat(2.25f), new HalfFloat(-3.75f), new HalfFloat(0.0f), new HalfFloat(Float.MAX_VALUE)};
        for (i = 0; i < 5; ++i) {
            byteIndex = i * 2;
            byteArray.setHalfFloat(byteIndex, testValues[i]);
        }
        for (i = 0; i < 5; ++i) {
            byteIndex = i * 2;
            HalfFloat retrieved = byteArray.getHalfFloat(byteIndex);
            Assert.assertEquals((String)("Half-float value mismatch at index " + byteIndex), (float)testValues[i].getFloat32(), (float)retrieved.getFloat32(), (float)0.01f);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testByteArrayHalfFloatMisalignedSet() {
        ByteArray byteArray = new ByteArray(10);
        HalfFloat value = new HalfFloat(1.0f);
        byteArray.setHalfFloat(1, value);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testByteArrayHalfFloatMisalignedGet() {
        ByteArray byteArray = new ByteArray(10);
        byteArray.getHalfFloat(3);
    }

    @Test
    public void testByteArrayHalfFloatBoundaryValues() {
        ByteArray byteArray = new ByteArray(8);
        HalfFloat zero = new HalfFloat(0.0f);
        HalfFloat negativeZero = new HalfFloat(-0.0f);
        HalfFloat one = new HalfFloat(1.0f);
        HalfFloat minusOne = new HalfFloat(-1.0f);
        byteArray.setHalfFloat(0, zero);
        byteArray.setHalfFloat(2, negativeZero);
        byteArray.setHalfFloat(4, one);
        byteArray.setHalfFloat(6, minusOne);
        Assert.assertEquals((float)0.0f, (float)byteArray.getHalfFloat(0).getFloat32(), (float)0.001f);
        Assert.assertEquals((float)-0.0f, (float)byteArray.getHalfFloat(2).getFloat32(), (float)0.001f);
        Assert.assertEquals((float)1.0f, (float)byteArray.getHalfFloat(4).getFloat32(), (float)0.001f);
        Assert.assertEquals((float)-1.0f, (float)byteArray.getHalfFloat(6).getFloat32(), (float)0.001f);
    }

    @Test
    public void testByteArrayHalfFloatSpecialValues() {
        ByteArray byteArray = new ByteArray(16);
        HalfFloat[] specialValues = new HalfFloat[]{new HalfFloat(0.0f), new HalfFloat(-0.0f), new HalfFloat(1.0f), new HalfFloat(-1.0f), new HalfFloat(Float.POSITIVE_INFINITY), new HalfFloat(Float.NEGATIVE_INFINITY), new HalfFloat(Float.NaN), new HalfFloat(65504.0f)};
        for (int i = 0; i < specialValues.length; ++i) {
            int byteIndex = i * 2;
            byteArray.setHalfFloat(byteIndex, specialValues[i]);
            HalfFloat retrieved = byteArray.getHalfFloat(byteIndex);
            this.assertHalfFloatEquals("Special value not preserved at index " + i, specialValues[i].getFloat32(), retrieved, 0.001f);
        }
    }

    @Test
    public void testByteArrayHalfFloatSequentialAndOverwrite() {
        HalfFloat retrieved;
        int i;
        ByteArray byteArray = new ByteArray(8);
        for (i = 0; i < 4; ++i) {
            HalfFloat value = new HalfFloat((float)i + 0.5f);
            byteArray.setHalfFloat(i * 2, value);
        }
        for (i = 0; i < 4; ++i) {
            retrieved = byteArray.getHalfFloat(i * 2);
            Assert.assertEquals((String)("Sequential half-float mismatch at position " + i), (float)((float)i + 0.5f), (float)retrieved.getFloat32(), (float)0.001f);
        }
        HalfFloat overwriteValue = new HalfFloat(-99.75f);
        byteArray.setHalfFloat(4, overwriteValue);
        retrieved = byteArray.getHalfFloat(4);
        Assert.assertEquals((String)"Overwrite failed", (float)-99.75f, (float)retrieved.getFloat32(), (float)0.001f);
        Assert.assertEquals((String)"Adjacent value corrupted", (float)0.5f, (float)byteArray.getHalfFloat(0).getFloat32(), (float)0.001f);
        Assert.assertEquals((String)"Adjacent value corrupted", (float)3.5f, (float)byteArray.getHalfFloat(6).getFloat32(), (float)0.001f);
    }
}

