/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.api;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.CharArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestBuildFromByteBuffers
extends TornadoTestBase {
    final int SIZE = 10;

    @Test
    public void testBuildFromFloatBuffer() {
        FloatBuffer buffer = FloatBuffer.allocate(10);
        buffer.put(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f});
        buffer.flip();
        FloatArray floatArray = FloatArray.fromFloatBuffer((FloatBuffer)buffer);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((float)buffer.get(i), (float)floatArray.get(i), (float)0.0f);
        }
    }

    @Test
    public void testBuildFromDoubleBuffer() {
        DoubleBuffer buffer = DoubleBuffer.allocate(10);
        buffer.put(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 1.0, 2.0, 3.0, 4.0, 5.0});
        buffer.flip();
        DoubleArray doubleArray = DoubleArray.fromDoubleBuffer((DoubleBuffer)buffer);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((double)buffer.get(i), (double)doubleArray.get(i), (double)0.0);
        }
    }

    @Test
    public void testBuildFromIntBuffer() {
        IntBuffer buffer = IntBuffer.allocate(10);
        buffer.put(new int[]{1, 2, 3, 4, 5, 1, 2, 3, 4, 5});
        buffer.flip();
        IntArray intArray = IntArray.fromIntBuffer((IntBuffer)buffer);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)buffer.get(i), (long)intArray.get(i));
        }
    }

    @Test
    public void testBuildFromLongBuffer() {
        LongBuffer buffer = LongBuffer.allocate(10);
        buffer.put(new long[]{1L, 2L, 3L, 4L, 5L, 1L, 2L, 3L, 4L, 5L});
        buffer.flip();
        LongArray longArray = LongArray.fromLongBuffer((LongBuffer)buffer);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)buffer.get(i), (long)longArray.get(i));
        }
    }

    @Test
    public void testBuildFromShortBuffer() {
        ShortBuffer buffer = ShortBuffer.allocate(10);
        buffer.put(new short[]{1, 2, 3, 4, 5, 1, 2, 3, 4, 5});
        buffer.flip();
        ShortArray shortArray = ShortArray.fromShortBuffer((ShortBuffer)buffer);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)buffer.get(i), (long)shortArray.get(i));
        }
    }

    @Test
    public void testBuildFromCharBuffer() {
        CharBuffer buffer = CharBuffer.allocate(10);
        buffer.put(new char[]{'a', 'b', 'c', 'd', 'e', 'a', 'b', 'c', 'd', 'e'});
        buffer.flip();
        CharArray charArray = CharArray.fromCharBuffer((CharBuffer)buffer);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)buffer.get(i), (long)charArray.get(i));
        }
    }

    @Test
    public void testBuildFromByteBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        buffer.put(new byte[]{1, 2, 3, 4, 5, 1, 2, 3, 4, 5});
        buffer.flip();
        ByteArray byteArray = ByteArray.fromByteBuffer((ByteBuffer)buffer);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)buffer.get(i), (long)byteArray.get(i));
        }
    }
}

