/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests.api;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.DoubleBuffer;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.DataRange;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoExecutionResult;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.CharArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.arrays.Int8Array;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;
import uk.ac.manchester.tornado.unittests.arrays.TestArrays;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestAPI
extends TornadoTestBase {
    @Test
    public void testSegmentsByte() {
        ByteArray dataA = ByteArray.fromElements((byte[])new byte[]{0, 1, 2, 3});
        ByteArray dataB = ByteArray.fromArray((byte[])new byte[]{0, 1, 2, 3});
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)dataA.get(i), (long)dataB.get(i));
        }
        byte[] fArray = dataA.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)fArray[i], (long)dataA.get(i));
        }
        byte[] fArrayB = dataB.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)fArrayB[i], (long)dataB.get(i));
        }
    }

    @Test
    public void testSegmentsChar() {
        CharArray dataA = CharArray.fromElements((char[])new char[]{'\u0000', '\u0001', '\u0002', '\u0003'});
        CharArray dataB = CharArray.fromArray((char[])new char[]{'\u0000', '\u0001', '\u0002', '\u0003'});
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)dataA.get(i), (long)dataB.get(i));
        }
        char[] fArray = dataA.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)fArray[i], (long)dataA.get(i));
        }
        char[] fArrayB = dataB.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)fArrayB[i], (long)dataB.get(i));
        }
    }

    @Test
    public void testSegmentsShort() {
        ShortArray dataA = ShortArray.fromElements((short[])new short[]{0, 1, 2, 3});
        ShortArray dataB = ShortArray.fromArray((short[])new short[]{0, 1, 2, 3});
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)dataA.get(i), (long)dataB.get(i));
        }
        short[] fArray = dataA.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)fArray[i], (long)dataA.get(i));
        }
        short[] fArrayB = dataB.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)fArrayB[i], (long)dataB.get(i));
        }
    }

    @Test
    public void testSegmentsIntegers() {
        IntArray dataA = IntArray.fromElements((int[])new int[]{0, 1, 2, 3});
        IntArray dataB = IntArray.fromArray((int[])new int[]{0, 1, 2, 3});
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)dataA.get(i), (long)dataB.get(i));
        }
        int[] fArray = dataA.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)fArray[i], (long)dataA.get(i));
        }
        int[] fArrayB = dataB.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)fArrayB[i], (long)dataB.get(i));
        }
    }

    @Test
    public void testSegmentsLong() {
        LongArray dataA = LongArray.fromElements((long[])new long[]{0L, 1L, 2L, 3L});
        LongArray dataB = LongArray.fromArray((long[])new long[]{0L, 1L, 2L, 3L});
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)dataA.get(i), (long)dataB.get(i));
        }
        long[] fArray = dataA.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)fArray[i], (long)dataA.get(i));
        }
        long[] fArrayB = dataB.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((long)fArrayB[i], (long)dataB.get(i));
        }
    }

    @Test
    public void testSegmentsFloats() {
        FloatArray dataA = FloatArray.fromElements((float[])new float[]{0.0f, 1.0f, 2.0f, 3.0f});
        FloatArray dataB = FloatArray.fromArray((float[])new float[]{0.0f, 1.0f, 2.0f, 3.0f});
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((float)dataA.get(i), (float)dataB.get(i), (float)0.01f);
        }
        float[] fArray = dataA.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((float)fArray[i], (float)dataA.get(i), (float)0.01f);
        }
        float[] fArrayB = dataB.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((float)fArrayB[i], (float)dataB.get(i), (float)0.01f);
        }
    }

    @Test
    public void testSegmentsDouble() {
        DoubleArray dataA = DoubleArray.fromElements((double[])new double[]{0.0, 1.0, 2.0, 3.0});
        DoubleArray dataB = DoubleArray.fromArray((double[])new double[]{0.0, 1.0, 2.0, 3.0});
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((double)dataA.get(i), (double)dataB.get(i), (double)0.001);
        }
        double[] fArray = dataA.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((double)fArray[i], (double)dataA.get(i), (double)0.001);
        }
        double[] fArrayB = dataB.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((double)fArrayB[i], (double)dataB.get(i), (double)0.001);
        }
    }

    @Test
    public void testSegmentsHalfFloats() {
        HalfFloatArray dataA = HalfFloatArray.fromElements((HalfFloat[])new HalfFloat[]{new HalfFloat(0.0f), new HalfFloat(1.0f), new HalfFloat(2.0f), new HalfFloat(3.0f)});
        HalfFloatArray dataB = HalfFloatArray.fromArray((HalfFloat[])new HalfFloat[]{new HalfFloat(0.0f), new HalfFloat(1.0f), new HalfFloat(2.0f), new HalfFloat(3.0f)});
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((float)dataA.get(i).getFloat32(), (float)dataB.get(i).getFloat32(), (float)0.01f);
        }
        HalfFloat[] fArray = dataA.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((float)fArray[i].getFloat32(), (float)dataA.get(i).getFloat32(), (float)0.01f);
        }
        HalfFloat[] fArrayB = dataB.toHeapArray();
        for (int i = 0; i < dataA.getSize(); ++i) {
            Assert.assertEquals((float)fArrayB[i].getFloat32(), (float)dataB.get(i).getFloat32(), (float)0.01f);
        }
    }

    @Test
    public void testLazyCopyOut() throws TornadoExecutionPlanException {
        int N = 1024;
        int size = 20;
        IntArray data = new IntArray(1024);
        data.init(size);
        TaskGraph taskGraph = new TaskGraph("s0");
        Assert.assertNotNull((Object)taskGraph);
        taskGraph.transferToDevice(0, new Object[]{data}).task("t0", TestArrays::addAccumulator, (Object)data, (Object)1).transferToHost(2, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            executionResult.transferToHost(new Object[]{data});
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)21L, (long)data.get(i));
        }
    }

    @Test
    public void testLazyCopyOut2() throws TornadoExecutionPlanException {
        int N = 128;
        int size = 20;
        IntArray data = new IntArray(128);
        IntStream.range(0, 128).parallel().forEach(idx -> data.set(idx, size));
        TaskGraph taskGraph = new TaskGraph("s0");
        Assert.assertNotNull((Object)taskGraph);
        taskGraph.transferToDevice(0, new Object[]{data});
        taskGraph.task("t0", TestArrays::addAccumulator, (Object)data, (Object)1);
        taskGraph.transferToHost(2, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            executionResult.transferToHost(new Object[]{data});
        }
        for (int i = 0; i < 128; ++i) {
            Assert.assertEquals((long)21L, (long)data.get(i));
        }
    }

    @Test
    public void testLazyPartialCopyOut() throws TornadoExecutionPlanException {
        int N = 1024;
        int size = 20;
        IntArray data = new IntArray(1024);
        IntStream.range(0, 1024).parallel().forEach(idx -> data.set(idx, size));
        TaskGraph taskGraph = new TaskGraph("s0");
        Assert.assertNotNull((Object)taskGraph);
        taskGraph.transferToDevice(0, new Object[]{data}).task("t0", TestArrays::addAccumulator, (Object)data, (Object)1).transferToHost(2, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            TornadoExecutionResult executionResult = executionPlan.execute();
            DataRange dataRange = new DataRange((TornadoNativeArray)data);
            executionResult.transferToHost(dataRange.withSize(512L));
            executionResult.transferToHost(dataRange.withOffset(512L).withSize(512L));
        }
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)21L, (long)data.get(i));
        }
    }

    @Test
    public void testWarmUp() throws TornadoExecutionPlanException {
        int N = 128;
        int size = 20;
        IntArray data = new IntArray(128);
        IntStream.range(0, 128).parallel().forEach(idx -> data.set(idx, size));
        TaskGraph taskGraph = new TaskGraph("s0");
        Assert.assertNotNull((Object)taskGraph);
        taskGraph.transferToDevice(0, new Object[]{data}).task("t0", TestArrays::addAccumulator, (Object)data, (Object)1).transferToHost(1, new Object[]{data});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.withPreCompilation().execute();
        }
        for (int i = 0; i < 128; ++i) {
            Assert.assertEquals((long)21L, (long)data.get(i));
        }
    }

    @Test
    public void testBuildWithSegmentsFloat() {
        int n = 10;
        MemorySegment m = Arena.ofAuto().allocate(ValueLayout.JAVA_FLOAT.byteSize() * 10L);
        for (int i = 0; i < 10; ++i) {
            m.setAtIndex(ValueLayout.JAVA_FLOAT, (long)i, (float)(10 + i));
        }
        FloatArray floatArray = FloatArray.fromSegment((MemorySegment)m);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((float)(10 + i), (float)floatArray.get(i), (float)0.001f);
        }
    }

    @Test
    public void testBuildWithSegmentsDouble() {
        int n = 10;
        MemorySegment m = Arena.ofAuto().allocate(ValueLayout.JAVA_DOUBLE.byteSize() * 10L);
        for (int i = 0; i < 10; ++i) {
            m.setAtIndex(ValueLayout.JAVA_DOUBLE, (long)i, (double)(10 + i));
        }
        DoubleArray doubleArray = DoubleArray.fromSegment((MemorySegment)m);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((double)(10 + i), (double)doubleArray.get(i), (double)0.001);
        }
    }

    @Test
    public void testBuildWithSegmentsInt() {
        int n = 10;
        MemorySegment m = Arena.ofAuto().allocate(ValueLayout.JAVA_INT.byteSize() * 10L);
        for (int i = 0; i < 10; ++i) {
            m.setAtIndex(ValueLayout.JAVA_INT, (long)i, 10 + i);
        }
        IntArray intArray = IntArray.fromSegment((MemorySegment)m);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)(10 + i), (long)intArray.get(i));
        }
    }

    @Test
    public void testBuildWithSegmentsLong() {
        int n = 10;
        MemorySegment m = Arena.ofAuto().allocate(ValueLayout.JAVA_LONG.byteSize() * 10L);
        for (int i = 0; i < 10; ++i) {
            m.setAtIndex(ValueLayout.JAVA_LONG, (long)i, (long)(10 + i));
        }
        LongArray longArray = LongArray.fromSegment((MemorySegment)m);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)(10 + i), (long)longArray.get(i));
        }
    }

    @Test
    public void testBuildWithSegmentsShort() {
        int n = 10;
        MemorySegment m = Arena.ofAuto().allocate(ValueLayout.JAVA_SHORT.byteSize() * 10L);
        for (int i = 0; i < 10; ++i) {
            m.setAtIndex(ValueLayout.JAVA_SHORT, (long)i, (short)(10 + i));
        }
        ShortArray shortArray = ShortArray.fromSegment((MemorySegment)m);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)(10 + i), (long)shortArray.get(i));
        }
    }

    @Test
    public void testBuildWithSegmentsByte() {
        int n = 10;
        MemorySegment m = Arena.ofAuto().allocate(ValueLayout.JAVA_BYTE.byteSize() * 10L);
        for (int i = 0; i < 10; ++i) {
            m.setAtIndex(ValueLayout.JAVA_BYTE, (long)i, (byte)(10 + i));
        }
        ByteArray array = ByteArray.fromSegment((MemorySegment)m);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)(10 + i), (long)array.get(i));
        }
    }

    @Test
    public void testBuildWithSegmentsChar() {
        int n = 10;
        MemorySegment m = Arena.ofAuto().allocate(ValueLayout.JAVA_CHAR.byteSize() * 10L);
        for (int i = 0; i < 10; ++i) {
            m.setAtIndex(ValueLayout.JAVA_CHAR, (long)i, (char)(10 + i));
        }
        CharArray charArray = CharArray.fromSegment((MemorySegment)m);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)(10 + i), (long)charArray.get(i));
        }
    }

    @Test
    public void testBuildWithSegmentsHalfFloat() {
        int n = 10;
        MemorySegment m = Arena.ofAuto().allocate(ValueLayout.JAVA_SHORT.byteSize() * 10L);
        for (int i = 0; i < 10; ++i) {
            m.setAtIndex(ValueLayout.JAVA_SHORT, (long)i, Float.floatToFloat16(10 + i));
        }
        HalfFloatArray halfFloatArray = HalfFloatArray.fromSegment((MemorySegment)m);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((float)(10 + i), (float)halfFloatArray.get(i).getFloat32(), (float)0.001f);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuildWithSegmentsWrongSize() {
        int num_elements = 10;
        boolean additional_bytes = true;
        long byteSize = 41L;
        MemorySegment m = Arena.ofAuto().allocate(41L);
        IntArray intArray = IntArray.fromSegment((MemorySegment)m);
    }

    @Test
    public void testBuildFromSegmentsShallowFloat() {
        int n = 10;
        long headerSize = TornadoNativeArray.ARRAY_HEADER;
        long dataSize = ValueLayout.JAVA_FLOAT.byteSize() * 10L;
        long totalSize = headerSize + dataSize;
        MemorySegment segment = Arena.ofAuto().allocate(totalSize);
        long headerOffset = headerSize / ValueLayout.JAVA_FLOAT.byteSize();
        for (int i = 0; i < 10; ++i) {
            segment.setAtIndex(ValueLayout.JAVA_FLOAT, headerOffset + (long)i, (float)(20 + i));
        }
        FloatArray floatArray = FloatArray.fromSegmentShallow((MemorySegment)segment);
        Assert.assertEquals((long)10L, (long)floatArray.getSize());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((float)(20 + i), (float)floatArray.get(i), (float)0.001f);
        }
    }

    @Test
    public void testBuildFromSegmentsShallowHalfFloat() {
        int n = 10;
        long headerSize = TornadoNativeArray.ARRAY_HEADER;
        long dataSize = ValueLayout.JAVA_SHORT.byteSize() * 10L;
        long totalSize = headerSize + dataSize;
        MemorySegment segment = Arena.ofAuto().allocate(totalSize);
        long headerOffset = headerSize / ValueLayout.JAVA_SHORT.byteSize();
        for (int i = 0; i < 10; ++i) {
            segment.setAtIndex(ValueLayout.JAVA_SHORT, headerOffset + (long)i, Float.floatToFloat16(20 + i));
        }
        HalfFloatArray halfFloatArray = HalfFloatArray.fromSegmentShallow((MemorySegment)segment);
        Assert.assertEquals((long)10L, (long)halfFloatArray.getSize());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((float)(20 + i), (float)halfFloatArray.get(i).getFloat32(), (float)0.001f);
        }
    }

    @Test
    public void testBuildFromSegmentsShallowByte() {
        int n = 10;
        long headerSize = TornadoNativeArray.ARRAY_HEADER;
        long dataSize = ValueLayout.JAVA_BYTE.byteSize() * 10L;
        long totalSize = headerSize + dataSize;
        MemorySegment segment = Arena.ofAuto().allocate(totalSize);
        long headerOffset = headerSize / ValueLayout.JAVA_BYTE.byteSize();
        for (int i = 0; i < 10; ++i) {
            segment.setAtIndex(ValueLayout.JAVA_BYTE, headerOffset + (long)i, (byte)(20 + i));
        }
        ByteArray byteArray = ByteArray.fromSegmentShallow((MemorySegment)segment);
        Assert.assertEquals((long)10L, (long)byteArray.getSize());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)((byte)(20 + i)), (long)byteArray.get(i));
        }
    }

    @Test
    public void testBuildFromSegmentsShallowChar() {
        int n = 10;
        long headerSize = TornadoNativeArray.ARRAY_HEADER;
        long dataSize = ValueLayout.JAVA_CHAR.byteSize() * 10L;
        long totalSize = headerSize + dataSize;
        MemorySegment segment = Arena.ofAuto().allocate(totalSize);
        long headerOffset = headerSize / ValueLayout.JAVA_CHAR.byteSize();
        for (int i = 0; i < 10; ++i) {
            segment.setAtIndex(ValueLayout.JAVA_CHAR, headerOffset + (long)i, (char)(20 + i));
        }
        CharArray charArray = CharArray.fromSegmentShallow((MemorySegment)segment);
        Assert.assertEquals((long)10L, (long)charArray.getSize());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)(20 + i), (long)charArray.get(i));
        }
    }

    @Test
    public void testBuildFromSegmentsShallowDouble() {
        int n = 10;
        long headerSize = TornadoNativeArray.ARRAY_HEADER;
        long dataSize = ValueLayout.JAVA_DOUBLE.byteSize() * 10L;
        long totalSize = headerSize + dataSize;
        MemorySegment segment = Arena.ofAuto().allocate(totalSize);
        long headerOffset = headerSize / ValueLayout.JAVA_DOUBLE.byteSize();
        for (int i = 0; i < 10; ++i) {
            segment.setAtIndex(ValueLayout.JAVA_DOUBLE, headerOffset + (long)i, (double)(20 + i));
        }
        DoubleArray doubleArray = DoubleArray.fromSegmentShallow((MemorySegment)segment);
        Assert.assertEquals((long)10L, (long)doubleArray.getSize());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((double)(20 + i), (double)doubleArray.get(i), (double)0.001f);
        }
    }

    @Test
    public void testBuildFromSegmentsShallowInt8() {
        int n = 10;
        long headerSize = TornadoNativeArray.ARRAY_HEADER;
        long dataSize = ValueLayout.JAVA_BYTE.byteSize() * 10L;
        long totalSize = headerSize + dataSize;
        MemorySegment segment = Arena.ofAuto().allocate(totalSize);
        long headerOffset = headerSize / ValueLayout.JAVA_BYTE.byteSize();
        for (int i = 0; i < 10; ++i) {
            segment.setAtIndex(ValueLayout.JAVA_BYTE, headerOffset + (long)i, (byte)(20 + i));
        }
        Int8Array int8Array = Int8Array.fromSegmentShallow((MemorySegment)segment);
        Assert.assertEquals((long)10L, (long)int8Array.getSize());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)((byte)(20 + i)), (long)int8Array.get(i));
        }
    }

    @Test
    public void testBuildFromSegmentsShallowInt() {
        int n = 10;
        long headerSize = TornadoNativeArray.ARRAY_HEADER;
        long dataSize = ValueLayout.JAVA_INT.byteSize() * 10L;
        long totalSize = headerSize + dataSize;
        MemorySegment segment = Arena.ofAuto().allocate(totalSize);
        long headerOffset = headerSize / ValueLayout.JAVA_INT.byteSize();
        for (int i = 0; i < 10; ++i) {
            segment.setAtIndex(ValueLayout.JAVA_INT, headerOffset + (long)i, 20 + i);
        }
        IntArray intArray = IntArray.fromSegmentShallow((MemorySegment)segment);
        Assert.assertEquals((long)10L, (long)intArray.getSize());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)(20 + i), (long)intArray.get(i));
        }
    }

    @Test
    public void testBuildFromSegmentsShallowLong() {
        int n = 10;
        long headerSize = TornadoNativeArray.ARRAY_HEADER;
        long dataSize = ValueLayout.JAVA_LONG.byteSize() * 10L;
        long totalSize = headerSize + dataSize;
        MemorySegment segment = Arena.ofAuto().allocate(totalSize);
        long headerOffset = headerSize / ValueLayout.JAVA_LONG.byteSize();
        for (int i = 0; i < 10; ++i) {
            segment.setAtIndex(ValueLayout.JAVA_LONG, headerOffset + (long)i, (long)(20 + i));
        }
        LongArray longArray = LongArray.fromSegmentShallow((MemorySegment)segment);
        Assert.assertEquals((long)10L, (long)longArray.getSize());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)(20 + i), (long)longArray.get(i));
        }
    }

    @Test
    public void testBuildFromSegmentsShallowShort() {
        int n = 10;
        long headerSize = TornadoNativeArray.ARRAY_HEADER;
        long dataSize = ValueLayout.JAVA_SHORT.byteSize() * 10L;
        long totalSize = headerSize + dataSize;
        MemorySegment segment = Arena.ofAuto().allocate(totalSize);
        long headerOffset = headerSize / ValueLayout.JAVA_SHORT.byteSize();
        for (int i = 0; i < 10; ++i) {
            segment.setAtIndex(ValueLayout.JAVA_SHORT, headerOffset + (long)i, (short)(20 + i));
        }
        ShortArray shortArray = ShortArray.fromSegmentShallow((MemorySegment)segment);
        Assert.assertEquals((long)10L, (long)shortArray.getSize());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)((short)(20 + i)), (long)shortArray.get(i));
        }
    }

    public static void simpleAddition(DoubleArray a, DoubleArray b) {
        for (int i = 0; i < b.getSize(); ++i) {
            b.set(i, a.get(i) + 1.0);
        }
    }

    @Test
    public void testArrayFromMemorySegment() throws TornadoExecutionPlanException {
        int numberOfElements = 256;
        double[] someArray = new double[256];
        IntStream.range(0, 256).sequential().forEach(i -> {
            someArray[i] = i;
        });
        MemorySegment a = MemorySegment.ofArray(someArray);
        DoubleArray dataA = DoubleArray.fromSegment((MemorySegment)a);
        DoubleArray dataB = new DoubleArray(256);
        DoubleArray dataBSeq = new DoubleArray(256);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataA}).task("t0", TestAPI::simpleAddition, (Object)dataA, (Object)dataB).transferToHost(1, new Object[]{dataB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestAPI.simpleAddition(dataA, dataBSeq);
        for (int i2 = 0; i2 < dataB.getSize(); ++i2) {
            Assert.assertEquals((double)dataBSeq.get(i2), (double)dataB.get(i2), (double)0.01f);
        }
    }

    @Test
    public void testArrayFromBuffer() throws TornadoExecutionPlanException {
        int numberOfElements = 256;
        double[] someArray = new double[256];
        IntStream.range(0, 256).sequential().forEach(i -> {
            someArray[i] = i;
        });
        DoubleBuffer buffer = DoubleBuffer.allocate(someArray.length);
        buffer.put(someArray);
        buffer.flip();
        DoubleArray dataA = DoubleArray.fromDoubleBuffer((DoubleBuffer)buffer);
        DoubleArray dataB = new DoubleArray(256);
        DoubleArray dataBSeq = new DoubleArray(256);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{dataA}).task("t0", TestAPI::simpleAddition, (Object)dataA, (Object)dataB).transferToHost(1, new Object[]{dataB});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        TestAPI.simpleAddition(dataA, dataBSeq);
        for (int i2 = 0; i2 < dataB.getSize(); ++i2) {
            Assert.assertEquals((double)dataBSeq.get(i2), (double)dataB.get(i2), (double)0.01f);
        }
    }
}

