/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.unittests;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.manchester.tornado.api.ImmutableTaskGraph;
import uk.ac.manchester.tornado.api.TaskGraph;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.Debug;
import uk.ac.manchester.tornado.api.exceptions.TornadoExecutionPlanException;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.unittests.common.TornadoTestBase;

public class TestHello
extends TornadoTestBase {
    private static void printHello(int n) {
        for (int i = 0; i < n; ++i) {
            Debug.printf((String)"hello\n", (Object[])new Object[0]);
        }
    }

    private static void printIntArray(IntArray a) {
        int firstValue = a.get(0);
        int secondValue = a.get(1);
        if (a.getSize() > 1) {
            Debug.printf((String)"First value %d, second value %d\n", (Object[])new Object[]{firstValue, secondValue});
        }
    }

    private static void printIntArray2(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            Debug.printf((String)"value a[%d] = %d\n", (Object[])new Object[]{i, a.get(i)});
        }
    }

    public static void add(IntArray a, IntArray b, IntArray c) {
        for (int i = 0; i < c.getSize(); ++i) {
            c.set(i, a.get(i) + b.get(i));
        }
    }

    public static void simple(IntArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            b.set(i, a.get(i) + 1);
        }
    }

    public static void compute(IntArray a) {
        for (int i = 0; i < a.getSize(); ++i) {
            a.set(i, a.get(i) * 2);
        }
    }

    public void compute(IntArray a, IntArray b) {
        for (int i = 0; i < a.getSize(); ++i) {
            b.set(i, a.get(i) * 2);
        }
    }

    public void compute(int[] a, int[] b) {
        for (int i = 0; i < a.length; ++i) {
            b[i] = a[i] * 2;
        }
    }

    @Test
    public void testHello() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestHello::printHello, (Object)8);
        Assert.assertNotNull((Object)taskGraph);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
    }

    @Test
    public void testPrintIntArray() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        this.assertNotBackend(TornadoVMBackendType.PTX);
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        a.set(0, 1);
        a.set(1, 2);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestHello::printIntArray, (Object)a);
        Assert.assertNotNull((Object)taskGraph);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
    }

    @Test
    public void testPrintIntArray2() throws TornadoExecutionPlanException {
        this.assertNotBackend(TornadoVMBackendType.SPIRV);
        this.assertNotBackend(TornadoVMBackendType.PTX);
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        for (int i = 0; i < numElements; ++i) {
            a.set(i, i + 1);
        }
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", TestHello::printIntArray2, (Object)a);
        Assert.assertNotNull((Object)taskGraph);
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
    }

    @Test
    public void testVectorAddition() throws TornadoExecutionPlanException {
        int numElements = 16;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        IntArray c = new IntArray(numElements);
        a.init(1);
        b.init(2);
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a, b}).task("t0", TestHello::add, (Object)a, (Object)b, (Object)c).transferToHost(1, new Object[]{c});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < c.getSize(); ++i) {
            Assert.assertEquals((double)(a.get(i) + b.get(i)), (double)c.get(i), (double)0.001);
        }
    }

    @Test
    public void testSimpleCompute() throws TornadoExecutionPlanException {
        int numElements = 256;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        a.init(10);
        TestHello t = new TestHello();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(0, new Object[]{a}).task("t0", t::compute, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < b.getSize(); ++i) {
            Assert.assertEquals((long)(a.get(i) * 2), (long)b.get(i));
        }
    }

    @Test
    public void testSimpleCompute2() throws TornadoExecutionPlanException {
        int numElements = 256;
        IntArray a = new IntArray(numElements);
        IntArray b = new IntArray(numElements);
        a.init(10);
        TestHello t = new TestHello();
        TaskGraph taskGraph = new TaskGraph("s0").transferToDevice(1, new Object[]{a}).task("t0", t::compute, (Object)a, (Object)b).transferToHost(1, new Object[]{b});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < b.getSize(); ++i) {
            Assert.assertEquals((long)(a.get(i) * 2), (long)b.get(i));
        }
    }

    @Test
    public void testSimpleInOut() throws TornadoExecutionPlanException {
        int numElements = 256;
        IntArray a = new IntArray(numElements);
        a.init(10);
        TaskGraph taskGraph = new TaskGraph("s0").task("t0", TestHello::compute, (Object)a).transferToHost(1, new Object[]{a});
        ImmutableTaskGraph immutableTaskGraph = taskGraph.snapshot();
        try (TornadoExecutionPlan executionPlan = new TornadoExecutionPlan(new ImmutableTaskGraph[]{immutableTaskGraph});){
            executionPlan.execute();
        }
        for (int i = 0; i < a.getSize(); ++i) {
            Assert.assertEquals((long)20L, (long)a.get(i));
        }
    }
}

