/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import uk.ac.manchester.tornado.api.enums.TornadoDeviceType;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;

public class TornadoUtils {
    public static int getSizeReduction(int inputSize, TornadoDeviceType where) {
        switch (where) {
            case CPU: {
                return Runtime.getRuntime().availableProcessors();
            }
            case GPU: 
            case FPGA: {
                int size = 1;
                if (inputSize > 256) {
                    size = inputSize / 256;
                }
                return size;
            }
        }
        return 0;
    }

    public static boolean hasAnnotatedField(Object wrapper, Class<? extends Annotation> annotation) {
        for (Field field : wrapper.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    public static Object getAnnotatedObjectFromField(Object wrapper, Class<? extends Annotation> annotation) {
        Field storageField = null;
        for (Field field : wrapper.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotation)) continue;
            storageField = field;
        }
        assert (storageField != null);
        storageField.setAccessible(true);
        try {
            return storageField.get(wrapper);
        }
        catch (IllegalAccessException e) {
            throw new TornadoRuntimeException((Exception)e);
        }
    }

    public static Object getObjectFromField(Field field, Object obj) {
        try {
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new TornadoRuntimeException((Exception)e);
        }
    }
}

