/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.utils;

import java.util.Map;
import uk.ac.manchester.tornado.api.TornadoDeviceContext;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.profiler.ProfilerType;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;
import uk.ac.manchester.tornado.runtime.common.RuntimeUtilities;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;

public class JsonHandler {
    private static final String SEPARATOR = "\":  \"";
    private static final String END_LINE = "\",\n";
    private static final String DEVICE_ID = "Device ID";
    private static final String DEVICE = "Device";
    private static final String IP = "IP";
    private StringBuilder indent;

    private void increaseIndent() {
        this.indent.append("    ");
    }

    private void decreaseIndent() {
        this.indent.delete(0, 4);
    }

    public String createJSon(Map<String, Integer> entry, String name, TornadoDeviceContext device) {
        this.indent = new StringBuilder();
        StringBuilder json = new StringBuilder("");
        json.append("{\n");
        this.increaseIndent();
        json.append(this.indent.toString() + "\"" + name + "\": { \n");
        this.increaseIndent();
        if (TornadoOptions.LOG_IP) {
            json.append(this.indent.toString() + "\"IP\": \"" + RuntimeUtilities.getTornadoInstanceIP() + END_LINE);
        }
        TornadoVMBackendType backendType = TornadoRuntimeProvider.getTornadoRuntime().getBackend(device.getDriverIndex()).getBackendType();
        json.append(this.indent.toString() + "\"" + String.valueOf(ProfilerType.BACKEND) + "\" : \"" + String.valueOf(backendType) + END_LINE);
        json.append(this.indent.toString() + "\"Device ID\":  \"" + device.getDriverIndex() + ":" + device.getDevicePlatform() + END_LINE);
        json.append(this.indent.toString() + "\"Device\":  \"" + device.getDeviceName() + END_LINE);
        for (String s : entry.keySet()) {
            json.append(this.indent.toString() + "\"" + s + SEPARATOR + String.valueOf(entry.get(s)) + END_LINE);
        }
        json.delete(json.length() - 2, json.length() - 1);
        this.decreaseIndent();
        json.append(this.indent.toString() + "}\n");
        this.decreaseIndent();
        json.append(this.indent.toString() + "}\n");
        return json.toString();
    }
}

