/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.tasks.meta;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.TornadoEvents;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoInternalError;
import uk.ac.manchester.tornado.runtime.EventSet;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.domain.DomainTree;
import uk.ac.manchester.tornado.runtime.tasks.meta.AbstractRTContext;
import uk.ac.manchester.tornado.runtime.tasks.meta.Coarseness;
import uk.ac.manchester.tornado.runtime.tasks.meta.ScheduleContext;

public class TaskDataContext
extends AbstractRTContext {
    public static final String LOCAL_WORKGROUP_SUFFIX = ".local.workgroup.size";
    public static final String GLOBAL_WORKGROUP_SUFFIX = ".global.workgroup.size";
    protected final Map<TornadoXPUDevice, BitSet> profiles;
    private final byte[] constantData;
    private final ScheduleContext scheduleMetaData;
    private final int constantSize;
    private final int localSize;
    protected Access[] argumentsAccess;
    protected DomainTree domain;
    private long[] globalOffset;
    private long[] globalWork;
    private long[] localWork;
    private boolean localWorkDefined;
    private boolean globalWorkDefined;

    public TaskDataContext(ScheduleContext scheduleMetaData, String taskID, int numParameters) {
        super(scheduleMetaData.getId() + "." + taskID, scheduleMetaData);
        this.scheduleMetaData = scheduleMetaData;
        this.constantSize = 0;
        this.localSize = 0;
        this.constantData = null;
        this.profiles = new HashMap<TornadoXPUDevice, BitSet>();
        this.argumentsAccess = new Access[numParameters];
        Arrays.fill(this.argumentsAccess, Access.NONE);
        this.inspectLocalWork();
        this.inspectGlobalWork();
        this.setNumThreads(scheduleMetaData.getNumThreads());
    }

    public TaskDataContext(ScheduleContext scheduleMetaData, String id) {
        this(scheduleMetaData, id, 0);
    }

    public static TaskDataContext create(ScheduleContext scheduleMeta, String id, Method method) {
        int numParameters = Modifier.isStatic(method.getModifiers()) ? method.getParameterCount() : method.getParameterCount() + 1;
        return new TaskDataContext(scheduleMeta, id, numParameters);
    }

    private static String formatWorkDimensionArray(long[] array, String defaults) {
        StringBuilder sb = new StringBuilder();
        if (array == null || array.length == 0) {
            sb.append("[").append(defaults).append("]");
        } else {
            sb.append(Arrays.toString(array));
        }
        return sb.toString();
    }

    private static String getProperty(String key) {
        return System.getProperty(key);
    }

    private void inspectLocalWork() {
        boolean bl = this.localWorkDefined = TaskDataContext.getProperty(this.getId() + LOCAL_WORKGROUP_SUFFIX) != null;
        if (this.localWorkDefined) {
            String[] values = TaskDataContext.getProperty(this.getId() + LOCAL_WORKGROUP_SUFFIX).split(",");
            this.localWork = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.localWork[i] = Long.parseLong(values[i]);
            }
        }
    }

    private void inspectGlobalWork() {
        boolean bl = this.globalWorkDefined = TaskDataContext.getProperty(this.getId() + GLOBAL_WORKGROUP_SUFFIX) != null;
        if (this.globalWorkDefined) {
            String[] values = TaskDataContext.getProperty(this.getId() + GLOBAL_WORKGROUP_SUFFIX).split(",");
            this.globalWork = new long[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.globalWork[i] = Long.parseLong(values[i]);
            }
        }
    }

    public boolean isLocalWorkDefined() {
        return this.localWorkDefined;
    }

    public boolean isGlobalWorkDefined() {
        return this.globalWorkDefined;
    }

    public void setLocalWorkToNull() {
        this.localWork = null;
    }

    public void setLocalWorkToNotDefined() {
        this.localWorkDefined = false;
    }

    public long[] initLocalWork() {
        this.localWork = new long[]{1L, 1L, 1L};
        return this.localWork;
    }

    public void setArgumentsAccess(Access[] access) {
        this.argumentsAccess = access;
    }

    public Access[] getArgumentsAccess() {
        return this.argumentsAccess;
    }

    public byte[] getConstantData() {
        return this.constantData;
    }

    public int getConstantSize() {
        return this.constantSize;
    }

    @Override
    public TornadoXPUDevice getXPUDevice() {
        if (this.scheduleMetaData.isDeviceManuallySet() || this.scheduleMetaData.isDeviceDefined() && !this.isDeviceDefined()) {
            return this.scheduleMetaData.getXPUDevice();
        }
        return super.getXPUDevice();
    }

    public int getDims() {
        return this.domain.getDepth();
    }

    public DomainTree getDomain() {
        return this.domain;
    }

    public void setDomain(DomainTree value) {
        this.domain = value;
        Coarseness coarseness = new Coarseness(this.domain.getDepth());
        String config = TaskDataContext.getProperty(this.getId() + ".coarseness");
        if (config != null && !config.isEmpty()) {
            coarseness.applyConfig(config);
        }
        int dims = this.domain.getDepth();
        this.globalOffset = new long[dims];
        if (!this.globalWorkDefined) {
            this.globalWork = new long[dims];
        }
        if (this.localWorkDefined) {
            TornadoInternalError.guarantee((this.localWork.length == dims ? 1 : 0) != 0, (String)"task %s has local work dims specified of wrong length", (Object[])new Object[]{this.getId()});
        } else {
            this.localWork = this.initLocalWork();
        }
    }

    public long[] getGlobalOffset() {
        return this.globalOffset;
    }

    @Override
    public long[] getGlobalWork() {
        return this.globalWork;
    }

    @Override
    public void setGlobalWork(long[] values) {
        if (this.globalWorkDefined) {
            return;
        }
        System.arraycopy(values, 0, this.globalWork, 0, values.length);
        this.globalWorkDefined = true;
    }

    public int getLocalSize() {
        return this.localSize;
    }

    @Override
    public long[] getLocalWork() {
        return this.localWork;
    }

    @Override
    public void setLocalWork(long[] values) {
        this.localWork = new long[values.length];
        System.arraycopy(values, 0, this.localWork, 0, values.length);
        this.localWorkDefined = true;
    }

    @Override
    public int getOpenCLGpuBlock2DX() {
        return this.isOpenclGpuBlock2DXDefined() ? super.getOpenCLGpuBlock2DX() : this.scheduleMetaData.getOpenCLGpuBlock2DX();
    }

    @Override
    public int getOpenCLGpuBlock2DY() {
        return this.isOpenclGpuBlock2DXDefined() ? super.getOpenCLGpuBlock2DY() : this.scheduleMetaData.getOpenCLGpuBlock2DY();
    }

    @Override
    public int getOpenCLGpuBlockX() {
        return this.isOpenclGpuBlockXDefined() ? super.getOpenCLGpuBlockX() : this.scheduleMetaData.getOpenCLGpuBlockX();
    }

    @Override
    public List<TornadoEvents> getProfiles(long executionPlanId) {
        ArrayList<TornadoEvents> result = new ArrayList<TornadoEvents>(this.profiles.keySet().size());
        for (TornadoXPUDevice device : this.profiles.keySet()) {
            result.add(new EventSet(device, this.profiles.get(device), executionPlanId));
        }
        return result;
    }

    public boolean hasDomain() {
        return this.domain != null;
    }

    @Override
    public boolean isDebug() {
        return super.isDebug() || this.scheduleMetaData.isDebug();
    }

    public boolean isParallel() {
        return this.hasDomain() && this.domain.getDepth() > 0;
    }

    private long[] calculateNumberOfWorkgroupsFromDomain(DomainTree domain) {
        long[] numOfWorkgroups = new long[domain.getDepth()];
        if (this.globalWork != null && this.localWork != null) {
            for (int i = 0; i < numOfWorkgroups.length; ++i) {
                numOfWorkgroups[i] = this.globalWork[i] / this.localWork[i];
            }
        }
        return numOfWorkgroups;
    }

    public void printThreadDims() {
        long[] workGroups;
        StringBuilder deviceDebug = new StringBuilder();
        boolean deviceBelongsToPTX = this.isPTXDevice(this.getXPUDevice());
        deviceDebug.append("Task info: " + this.getId() + "\n");
        deviceDebug.append("\tBackend           : " + this.getXPUDevice().getTornadoVMBackend().name() + "\n");
        deviceDebug.append("\tDevice            : " + this.getXPUDevice().getDescription() + "\n");
        deviceDebug.append("\tDims              : " + (this.isWorkerGridAvailable() ? this.getWorkerGrid(this.getId()).dimension() : (this.hasDomain() ? this.domain.getDepth() : 0)) + "\n");
        if (!deviceBelongsToPTX) {
            long[] go = this.isWorkerGridAvailable() ? this.getWorkerGrid(this.getId()).getGlobalOffset() : this.globalOffset;
            deviceDebug.append("\tGlobal work offset: " + TaskDataContext.formatWorkDimensionArray(go, "0") + "\n");
        }
        long[] lArray = workGroups = this.isWorkerGridAvailable() ? this.getWorkerGrid(this.getId()).getGlobalWork() : this.globalWork;
        if (deviceBelongsToPTX) {
            deviceDebug.append("\tThread dimensions : " + TaskDataContext.formatWorkDimensionArray(workGroups, "1") + "\n");
            deviceDebug.append("\tBlocks dimensions : " + TaskDataContext.formatWorkDimensionArray(this.getPTXBlockDim(), "1") + "\n");
            deviceDebug.append("\tGrids dimensions  : " + TaskDataContext.formatWorkDimensionArray(this.getPTXGridDim(), "1") + "\n");
        } else {
            long[] lw;
            long[] lArray2 = lw = this.isWorkerGridAvailable() ? this.getWorkerGrid(this.getId()).getLocalWork() : this.localWork;
            long[] nw = this.isWorkerGridAvailable() ? this.getWorkerGrid(this.getId()).getNumberOfWorkgroups() : (this.hasDomain() ? this.calculateNumberOfWorkgroupsFromDomain(this.domain) : null);
            deviceDebug.append("\tGlobal work size  : " + TaskDataContext.formatWorkDimensionArray(workGroups, "1") + "\n");
            deviceDebug.append("\tLocal  work size  : " + (lw == null ? "null" : TaskDataContext.formatWorkDimensionArray(lw, "1")) + "\n");
            deviceDebug.append("\tNumber of workgroups  : " + (nw == null ? "null" : TaskDataContext.formatWorkDimensionArray(nw, "1")) + "\n");
        }
        System.out.println(deviceDebug);
    }

    public boolean isPTXDevice(TornadoXPUDevice device) {
        return device.getTornadoVMBackend().equals((Object)TornadoVMBackendType.PTX);
    }

    @Override
    public boolean shouldUseOpenCLDriverScheduling() {
        return super.shouldUseOpenCLDriverScheduling() || this.scheduleMetaData.shouldUseOpenCLDriverScheduling();
    }

    public String toString() {
        return String.format("task meta data: domain=%s, global workgroup size=%s%n", this.domain, this.getGlobalWork() == null ? "null" : TaskDataContext.formatWorkDimensionArray(this.getGlobalWork(), "1"));
    }

    public boolean applyPartialLoopUnroll() {
        return TornadoOptions.isPartialUnrollEnabled();
    }
}

