/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.runtime.tasks.meta;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import uk.ac.manchester.tornado.api.GridScheduler;
import uk.ac.manchester.tornado.api.WorkerGrid;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.common.TornadoEvents;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.profiler.TornadoProfiler;
import uk.ac.manchester.tornado.api.runtime.TaskContextInterface;
import uk.ac.manchester.tornado.runtime.TornadoAcceleratorBackend;
import uk.ac.manchester.tornado.runtime.TornadoCoreRuntime;
import uk.ac.manchester.tornado.runtime.common.Tornado;
import uk.ac.manchester.tornado.runtime.common.TornadoOptions;
import uk.ac.manchester.tornado.runtime.common.TornadoXPUDevice;
import uk.ac.manchester.tornado.runtime.tasks.meta.MetaDataUtils;

public abstract class AbstractRTContext
implements TaskContextInterface {
    private static final long[] SEQUENTIAL_GLOBAL_WORK_GROUP = new long[]{1L, 1L, 1L};
    private final String id;
    private final boolean isDeviceDefined;
    private TornadoXPUDevice device;
    protected int backendIndex;
    protected int deviceIndex;
    private boolean deviceManuallySet;
    private boolean threadInfoEnabled;
    private boolean printKernel;
    private boolean resetThreads;
    private final boolean isOpenclGpuBlockXDefined;
    private final int openclGpuBlockX;
    private final boolean isOpenclGpuBlock2DXDefined;
    private final int openclGpuBlock2DX;
    private final boolean isOpenclGpuBlock2DYDefined;
    private final int openclGpuBlock2DY;
    private long numThreads;
    private GridScheduler gridScheduler;
    private long[] ptxBlockDim;
    private long[] ptxGridDim;
    private TornadoProfiler profiler;
    private ResolvedJavaMethod graph;
    private boolean useGridScheduler;
    private final ConcurrentHashMap<TornadoVMBackendType, String> compilerOptionsPerBackend;
    private boolean openclUseDriverScheduling;

    AbstractRTContext(String id, AbstractRTContext parent) {
        this.id = id;
        boolean bl = this.isDeviceDefined = AbstractRTContext.getProperty(id + ".device") != null;
        if (this.isDeviceDefined) {
            MetaDataUtils.BackendSelectionContainer backendSelection = MetaDataUtils.resolveDriverDeviceIndexes(AbstractRTContext.getProperty(id + ".device"));
            this.backendIndex = backendSelection.backendIndex();
            this.deviceIndex = backendSelection.deviceIndex();
        } else if (null != parent) {
            this.backendIndex = parent.getBackendIndex();
            this.deviceIndex = parent.getDeviceIndex();
        } else {
            this.backendIndex = TornadoOptions.DEFAULT_BACKEND_INDEX;
            this.deviceIndex = TornadoOptions.DEFAULT_DEVICE_INDEX;
        }
        this.threadInfoEnabled = TornadoOptions.THREAD_INFO;
        this.printKernel = TornadoOptions.PRINT_KERNEL_SOURCE;
        this.compilerOptionsPerBackend = new ConcurrentHashMap();
        this.compilerOptionsPerBackend.put(TornadoVMBackendType.OPENCL, TornadoOptions.DEFAULT_OPENCL_COMPILER_FLAGS);
        this.compilerOptionsPerBackend.put(TornadoVMBackendType.PTX, TornadoOptions.DEFAULT_PTX_COMPILER_FLAGS);
        this.compilerOptionsPerBackend.put(TornadoVMBackendType.SPIRV, TornadoOptions.DEFAULT_SPIRV_LEVEL_ZERO_COMPILER_FLAGS);
        this.openclGpuBlockX = Integer.parseInt(AbstractRTContext.getDefault("opencl.gpu.block.x", id, "256"));
        this.isOpenclGpuBlockXDefined = AbstractRTContext.getProperty(id + ".opencl.gpu.block.x") != null;
        this.openclGpuBlock2DX = Integer.parseInt(AbstractRTContext.getDefault("opencl.gpu.block2d.x", id, "4"));
        this.isOpenclGpuBlock2DXDefined = AbstractRTContext.getProperty(id + ".opencl.gpu.block2d.x") != null;
        this.openclGpuBlock2DY = Integer.parseInt(AbstractRTContext.getDefault("opencl.gpu.block2d.y", id, "4"));
        this.isOpenclGpuBlock2DYDefined = AbstractRTContext.getProperty(id + ".opencl.gpu.block2d.y") != null;
    }

    private static String getProperty(String key) {
        return System.getProperty(key);
    }

    protected static String getDefault(String keySuffix, String id, String defaultValue) {
        String propertyValue = AbstractRTContext.getProperty(id + "." + keySuffix);
        return propertyValue != null ? propertyValue : Tornado.getProperty("tornado." + keySuffix, defaultValue);
    }

    public TornadoXPUDevice getXPUDevice() {
        if (this.device == null) {
            this.device = MetaDataUtils.resolveDevice(Tornado.getProperty(this.id + ".device", this.backendIndex + ":" + this.deviceIndex));
        }
        return this.device;
    }

    private boolean hasSamePlatformName(TornadoAcceleratorBackend backend, TornadoDevice device, int index) {
        return backend.getDevice(index).getPlatformName().equals(device.getPlatformName());
    }

    private boolean hasSameDeviceName(TornadoAcceleratorBackend backend, TornadoDevice device, int index) {
        return backend.getDevice(index).getPhysicalDevice().getDeviceName().equals(device.getPhysicalDevice().getDeviceName());
    }

    private int getDeviceIndex(int driverIndex, TornadoDevice device) {
        TornadoAcceleratorBackend backend = TornadoCoreRuntime.getTornadoRuntime().getBackend(driverIndex);
        int totalNumDevices = backend.getNumDevices();
        for (int deviceIndex = 0; deviceIndex < totalNumDevices; ++deviceIndex) {
            if (!this.hasSamePlatformName(backend, device, deviceIndex) || !this.hasSameDeviceName(backend, device, deviceIndex)) continue;
            return deviceIndex;
        }
        throw new TornadoRuntimeException("[ERROR] Device not found: " + device.getPhysicalDevice().getDeviceName());
    }

    boolean isDeviceManuallySet() {
        return this.deviceManuallySet;
    }

    public void setDevice(TornadoDevice device) {
        this.backendIndex = device.getBackendIndex();
        this.deviceIndex = this.getDeviceIndex(this.backendIndex, device);
        if (device instanceof TornadoXPUDevice) {
            TornadoXPUDevice tornadoAcceleratorDevice;
            this.device = tornadoAcceleratorDevice = (TornadoXPUDevice)device;
        }
        this.deviceManuallySet = true;
    }

    public int getBackendIndex() {
        return this.backendIndex;
    }

    public int getDeviceIndex() {
        return this.deviceIndex;
    }

    public String getId() {
        return this.id;
    }

    public boolean isThreadInfoEnabled() {
        return this.threadInfoEnabled;
    }

    public boolean isDebug() {
        return TornadoOptions.DEBUG;
    }

    public String getCompilerFlags(TornadoVMBackendType backendType) {
        return this.compilerOptionsPerBackend.get(backendType);
    }

    public void setCompilerFlags(TornadoVMBackendType backendType, String compilerFlags) {
        this.compilerOptionsPerBackend.put(backendType, compilerFlags);
    }

    public int getOpenCLGpuBlockX() {
        return this.openclGpuBlockX;
    }

    public int getOpenCLGpuBlock2DX() {
        return this.openclGpuBlock2DX;
    }

    public int getOpenCLGpuBlock2DY() {
        return this.openclGpuBlock2DY;
    }

    public boolean shouldUseOpenCLDriverScheduling() {
        return this.openclUseDriverScheduling;
    }

    public boolean isDeviceDefined() {
        return this.isDeviceDefined;
    }

    public boolean isOpenclGpuBlockXDefined() {
        return this.isOpenclGpuBlockXDefined;
    }

    public boolean isOpenclGpuBlock2DXDefined() {
        return this.isOpenclGpuBlock2DXDefined;
    }

    public boolean isOpenclGpuBlock2DYDefined() {
        return this.isOpenclGpuBlock2DYDefined;
    }

    public List<TornadoEvents> getProfiles(long executionPlanId) {
        return null;
    }

    public long[] getGlobalWork() {
        return null;
    }

    public void setGlobalWork(long[] global) {
    }

    public long[] getLocalWork() {
        return null;
    }

    public void setLocalWork(long[] local) {
    }

    public long getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(long threads) {
        this.numThreads = threads;
    }

    public void attachProfiler(TornadoProfiler profiler) {
        this.profiler = profiler;
    }

    public TornadoProfiler getProfiler() {
        return this.profiler;
    }

    public void enableDefaultThreadScheduler(boolean use) {
        this.openclUseDriverScheduling = use;
    }

    public void setGridScheduler(GridScheduler gridScheduler) {
        this.gridScheduler = gridScheduler;
    }

    public boolean isWorkerGridAvailable() {
        return this.gridScheduler != null && this.gridScheduler.get(this.getId()) != null;
    }

    public boolean isGridSequential() {
        return Arrays.equals(this.getWorkerGrid(this.getId()).getGlobalWork(), SEQUENTIAL_GLOBAL_WORK_GROUP);
    }

    public WorkerGrid getWorkerGrid(String taskName) {
        return this.gridScheduler.get(taskName);
    }

    public long[] getPTXBlockDim() {
        return this.ptxBlockDim;
    }

    public long[] getPTXGridDim() {
        return this.ptxGridDim;
    }

    public void setPtxBlockDim(long[] blockDim) {
        this.ptxBlockDim = blockDim;
    }

    public void setPtxGridDim(long[] gridDim) {
        this.ptxGridDim = gridDim;
    }

    public void setCompiledGraph(Object graph) {
        if (graph instanceof ResolvedJavaMethod) {
            this.graph = (ResolvedJavaMethod)graph;
        }
    }

    public Object getCompiledResolvedJavaMethod() {
        return this.graph;
    }

    public void setUseGridScheduler(boolean use) {
        this.useGridScheduler = use;
    }

    public boolean isGridSchedulerEnabled() {
        return this.useGridScheduler;
    }

    public void enableThreadInfo() {
        this.threadInfoEnabled = true;
    }

    public void disableThreadInfo() {
        this.threadInfoEnabled = false;
    }

    public boolean isPrintKernelEnabled() {
        return this.printKernel;
    }

    public void setPrintKernelFlag(boolean printKernelEnabled) {
        this.printKernel = printKernelEnabled;
    }

    public void enablePrintKernel() {
        this.printKernel = true;
    }

    public void disablePrintKernel() {
        this.printKernel = false;
    }

    public void setThreadInfoEnabled(boolean threadInfoEnabled) {
        this.threadInfoEnabled = threadInfoEnabled;
    }

    public void resetThreadBlocks() {
        this.resetThreads = true;
    }

    public boolean shouldResetThreadsBlock() {
        return this.resetThreads;
    }

    public void disableResetThreadBlock() {
        this.resetThreads = false;
    }
}

